//
//  YHWorkExperienceModel.swift
//  galaxy
//
//  Created by EDY on 2024/2/19.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

enum YHWorkExperienceSelectType: Int {
    case normal = 0
    case unit = 1
    case nature = 2
    case country = 3
    case address = 4
    case time = 5
    case certificate = 6
    case structure = 7
    case level = 8
    case prove = 9
    case company = 10
    case field = 11
    case myCompany = 12
    case position = 13
}

enum YHWorkExperienceID: Int {
    case id1 = 0 // 用人单位
    case id2 = 1 // 用人单位性质
    case id3 = 2 // 用人单位介绍
    case id4 = 3 // 用人单位官网
    case id5 = 4 // 工作地区国家
    case id6 = 5 // 工作城市 国内
    case id7 = 6 // 工作城市国外
    case id8 = 7 // 职位
    case id9 = 8 // 入职年月
    case id10 = 9 // 离职年月
    case id11 = 10 // 工作证明文件
    case id12 = 11 // 职责性质
    case id13 = 12 // 是否国际工作经验
    case id14 = 13 // 企业人数规模
    case id15 = 14 // 行政架构层级
    case id16 = 15 // 下属管理人数
    case id17 = 16 // 公司营业额/港元
    case id18 = 17 // 公司性质/范畴/所属行业
    case id19 = 18 // 职位水平类型
    case id20 = 19 // 高管证明文件
    case id21 = 20 // 高管在职开始时间
    case id22 = 21 // 高管在职结束时间
    case id23 = 22 // 入职年月
    case id24 = 23 // 离职年月
}

struct YHWorkExperienceModel {
    var id: YHWorkExperienceID?
    var isNeed: Bool?
    var title: String?
    var isUserKeyBoard: Bool?
    var prompts: String?
    var message: String?
    var leftButtonString: String?
    var rightButtonString: String?
    var type: YHWorkExperienceSelectType?
    var value: [String]?
    var isShowPrompts: Bool?
    var alertMessage: String?
    
    init(id: YHWorkExperienceID? = nil, isNeed: Bool? = nil, title: String? = nil, isUserKeyBoard: Bool? = nil, prompts: String? = nil, message: String? = nil, leftButtonString: String? = nil, rightButtonString: String? = nil, type: YHWorkExperienceSelectType? = nil, value: [String]? = nil, isShowPrompts: Bool? = nil, alertMessage: String? = nil) {
        self.id = id
        self.isNeed = isNeed
        self.title = title
        self.isUserKeyBoard = isUserKeyBoard
        self.prompts = prompts
        self.message = message
        self.leftButtonString = leftButtonString
        self.rightButtonString = rightButtonString
        self.type = type
        self.value = value
        self.isShowPrompts = isShowPrompts
        self.alertMessage = alertMessage
    }
}

struct YHSectionWorkExperienceModel {
    var title: String?
    var models: [YHWorkExperienceModel]?
    
    init(title: String? = nil, models: [YHWorkExperienceModel]? = nil) {
        self.title = title
        self.models = models
    }
}
