//
//  YHWorkExperiencePositionItemView.swift
//  galaxy
//
//  Created by EDY on 2024/11/16.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHWorkExperiencePositionItemView: UIView {
    typealias ItemBlock = (_ model: YHWorkExperiencePositionModel) -> Void
    var clickBlock: ItemBlock?
    var deleteBlock: ItemBlock?
    var titleLabel: UILabel!
    var subTitleLabel: UILabel!
    var explainLabel: UILabel!
    var nextStepImageView: UIImageView!
    var deleteButton: UIButton!
    var centerButton: UIButton!
    var showPrompt: Bool = false {
        didSet {
            if showPrompt {
                subTitleLabel.isHidden = false
                if dataSource?.missing_item_num != 0 {
                    subTitleLabel.text = "有" + "\(dataSource?.missing_item_num ?? 0)" + "项未填写"
                    subTitleLabel.textColor = UIColor.failColor
                } else {
                    subTitleLabel.textColor = UIColor.labelTextColor2
                }
            } else {
                subTitleLabel.isHidden = true
                subTitleLabel.textColor = UIColor.labelTextColor2
            }
        }
    }

    var dataSource: YHWorkExperiencePositionModel? {
        didSet {
            updateAllViews()
        }
    }
    override init(frame: CGRect) {
        super.init(frame: frame)
        backgroundColor = .white
        setUpView()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func setUpView() {
        titleLabel = {
            let label = UILabel()
            label.font = UIFont.PFSC_B(ofSize: 14)
            label.textAlignment = .left
            label.numberOfLines = 2
            label.textColor = UIColor.mainTextColor
            return label
        }()
        addSubview(titleLabel)
        titleLabel.snp.makeConstraints { make in
            make.left.equalToSuperview()
            make.top.equalTo(16)
            make.width.equalTo(143)
        }
    
        subTitleLabel = {
            let label = UILabel()
            label.font = UIFont.PFSC_R(ofSize: 14)
            label.textAlignment = .left
            label.textColor = UIColor.labelTextColor2
            return label
        }()
        addSubview(subTitleLabel)
        subTitleLabel.snp.makeConstraints { make in
            make.left.right.equalToSuperview()
            make.height.equalTo(20)
            make.bottom.equalTo(-16)
        }
        
        explainLabel = {
            let label = UILabel()
            label.font = UIFont.PFSC_R(ofSize: 14)
            label.textAlignment = .right
            label.textColor = UIColor.labelTextColor2
            return label
        }()
        addSubview(explainLabel)
        explainLabel.snp.makeConstraints { make in
            make.right.equalTo(-24)
            make.left.equalTo(titleLabel.snp.right)
            make.height.equalTo(20)
            make.top.equalTo(16)
        }
        
        nextStepImageView = {
            let imageView = UIImageView()
            imageView.image = UIImage(named: "form_right_arrow")
            return imageView
        }()
        addSubview(nextStepImageView)
        nextStepImageView.snp.makeConstraints { make in
            make.right.equalToSuperview()
            make.centerY.equalTo(explainLabel.snp.centerY)
            make.height.width.equalTo(20)
        }
        
        centerButton = {
            let button = UIButton(type: .custom)
            button.addTarget(self, action: #selector(centerClick), for: .touchUpInside)
            return button
        }()
        addSubview(centerButton)
        centerButton.snp.makeConstraints { make in
            make.right.top.bottom.equalToSuperview()
            make.left.equalTo(112)
        }
        
        deleteButton = {
            let button = UIButton(type: .custom)
            button.titleLabel?.font = UIFont.PFSC_R(ofSize: 14)
            button.contentHorizontalAlignment = .center
            button.setTitle("删除", for: .normal)
            button.contentHorizontalAlignment = .right
            button.setTitleColor(UIColor.failColor, for: .normal)
            button.addTarget(self, action: #selector(deleteClick), for: .touchUpInside)
            button.isHidden = true
            return button
        }()
        addSubview(deleteButton)
        deleteButton.snp.makeConstraints { make in
            make.right.equalToSuperview()
            make.height.equalTo(20)
            make.width.equalTo(35)
            make.centerY.equalTo(titleLabel.snp.centerY)
        }
        
    }
    
    func updateAllViews() {
        guard let dataSource = dataSource else { return }
        titleLabel.text = dataSource.position_name
        if dataSource.missing_item_num != 0 {
            explainLabel.text = "有" + "\(dataSource.missing_item_num ?? 0)" + "项未填写"
        } else {
            explainLabel.text = (dataSource.entry_time ?? "") + " ～ " + (dataSource.departure_time ?? "")
        }
        if dataSource.position_name.count == 0 {
            titleLabel.text = "职位\(tag - 4000 + 1)"
        }
    }
    
    @objc func centerClick() {
        if let block = clickBlock {
            block(self.dataSource ?? YHWorkExperiencePositionModel())
        }
    }
    
    @objc func deleteClick() {
        if let block = deleteBlock {
            block(self.dataSource ?? YHWorkExperiencePositionModel())
        }
    }
    
    func isShowDelete(_ index: Int, isShow: Bool) {
        if isShow {
            explainLabel.isHidden = true
            nextStepImageView.isHidden = true
            deleteButton.isHidden = false
        } else {
            explainLabel.isHidden = false
            nextStepImageView.isHidden = false
            deleteButton.isHidden = true
        }
    }
}
