//
//  YHWorkItemListViewModel.swift
//  galaxy
//
//  Created by EDY on 2024/2/18.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHWorkItemListViewModel: YHBaseViewModel {
    var mainModel: YHWorkModel = YHWorkModel()
    var listModel: [YHWorkItemListModel]?
    var workId: Int = 0
    override init() {
        super.init()
    }
    
    func requestWorkList(_ orderId: String, callBackBlock: @escaping (_ success: [YHWorkItemListModel]?, _ error: YHErrorModel?) -> Void) {
//        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.WorkExperience.list + "?order_id=\(orderId)"
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.WorkExperience.list
        let params: [String: Any] = ["order_id": orderId]
        
        _ = YHNetRequest.getRequest(url: strUrl, params: params) { [weak self] json, _ in
            // 1. json字符串 转 对象
            guard let self = self else { return }
            if json.code == 200 {
                guard let dic = json.data?.peel as? [String: Any], let result = YHWorkModel.deserialize(from: dic) else {
                    callBackBlock([], nil)
                    return
                }
                self.mainModel = result
                self.listModel = result.list
                callBackBlock(self.listModel, nil)
            } else {
                let error: YHErrorModel = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg)
                callBackBlock([], error)
            }
        } failBlock: { err in
            callBackBlock([], err)
        }
    }
    
    func requestDeleteWorkExperience(_ orderId: String, callBackBlock: @escaping (_ success: Bool?, _ error: YHErrorModel?) -> Void) {
        let params: [String: Any] = ["id": orderId]
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.WorkExperience.del
        _ = YHNetRequest.postRequest(url: strUrl, params: params) { [weak self] json, _ in
            // 1. json字符串 转 对象
            guard let self = self else { return }
            if json.code == 200 {
                callBackBlock(true, nil)
            } else {
                let error: YHErrorModel = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg)
                callBackBlock(false, error)
            }
        } failBlock: { err in
            callBackBlock(false, err)
        }
    }
    
    func requestWorkTimeRemarkWorkExperience(_ orderId: String, _ isSaveAll: Int = 0, callBackBlock: @escaping (_ success: Bool?, _ error: YHErrorModel?) -> Void) {
        let params: [String: Any] = ["order_id": orderId,
                                      "work_time_empty_remark": self.mainModel.work_time_empty_remark,
                                      "work_time_overlap_remark": self.mainModel.work_time_overlap_remark,
                                      "is_save_all": isSaveAll]
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.WorkExperience.saveWorkTimeRemark
        _ = YHNetRequest.postRequest(url: strUrl, params: params) { [weak self] json, _ in
            // 1. json字符串 转 对象
            guard let self = self else { return }
            if json.code == 200 {
                callBackBlock(true, nil)
            } else {
                let error: YHErrorModel = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg)
                callBackBlock(false, error)
            }
        } failBlock: { err in
            callBackBlock(false, err)
        }
    }
    
    func requestCreateNewWork(_ orderId: Int, callBackBlock: @escaping (_ success: Int, _ error: YHErrorModel?) -> Void) {
//        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.WorkExperience.list + "?order_id=\(orderId)"
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.WorkExperience.createNewWork
        let params: [String: Any] = ["order_id": orderId]
        
        _ = YHNetRequest.postRequest(url: strUrl, params: params) { [weak self] json, _ in
            // 1. json字符串 转 对象
            guard let self = self else { return }
            if json.code == 200 {
                guard let dic = json.data?.peel as? [String: Any], let result = YHWorkExperienceDetailModel.deserialize(from: dic) else {
                    callBackBlock(0, nil)
                    return
                }
                self.workId = result.work_id
                callBackBlock(result.work_id, nil)
            } else {
                let error: YHErrorModel = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg)
                callBackBlock(0, error)
            }
        } failBlock: { err in
            callBackBlock(0, err)
        }
    }
}
