//
//  YHGCSchemeTableHeadView.swift
//  galaxy
//
//  Created by alexzzw on 2024/11/12.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import AttributedString
import UIKit

class YHGCSchemeTableHeadView: UIView {
    private lazy var centerImageView: UIImageView = {
        let view = UIImageView()
        view.image = UIImage(named: "gc_scheme_head_bg")
        return view
    }()

    private lazy var centerView: UIView = {
        let view = UIView()
        view.backgroundColor = .white
        return view
    }()

    private lazy var leftImageView: UIImageView = {
        let view = UIImageView()
        view.image = UIImage(named: "scheme_head_left")
        return view
    }()

    private lazy var rightImageView: UIImageView = {
        let view = UIImageView()
        view.image = UIImage(named: "scheme_head_right")
        return view
    }()

    private lazy var nameLabel: UILabel = {
        let label = UILabel()
        label.font = UIFont.PFSC_B(ofSize: 24)
        label.textColor = UIColor(hex: 0xFFFFFF)
        label.textAlignment = .center
        label.lineBreakMode = .byTruncatingMiddle
        label.text = "尊敬的--"
        return label
    }()

    private lazy var messageLabel: UILabel = {
        let label = UILabel()
        label.font = UIFont.PFSC_R(ofSize: 14)
        label.textColor = UIColor(hex: 0xFFFFFF)
        label.textAlignment = .center
        label.numberOfLines = 0
        label.text = "您好，如电话沟通，这是我们为您定制的申请方案，方案详情如下："
        return label
    }()

    private lazy var logoImageView: UIImageView = {
        let view = UIImageView()
        view.image = UIImage(named: "scheme_head_logo")
        return view
    }()

    private lazy var titleView: UIView = {
        let view = UIView()
        view.backgroundColor = UIColor(hex: 0xD48638)
        return view
    }()
    
    private lazy var titleCoverView: UIView = {
        let view = UIView()
        view.backgroundColor = .clear
        return view
    }()

    private lazy var titleLabel: UILabel = {
        let label = UILabel()
        label.font = UIFont.PFSC_M(ofSize: 17)
        label.textColor = UIColor.mainTextColor
        label.text = "申请方案"
        return label
    }()

    private lazy var subContainerView: YHBaseDynamicCornerRadiusView = {
        let view = YHBaseDynamicCornerRadiusView(cornerRadius: 6, corner: .allCorners)
        view.backgroundColor = UIColor(hex: 0xCF9764, alpha: 0.12)
        return view
    }()

    private lazy var applicationTypeLabel: UILabel = {
        let label = UILabel()
        label.font = UIFont.PFSC_M(ofSize: 14)
        label.textColor = UIColor.mainTextColor
        label.text = "申请类型："
        return label
    }()

    private lazy var applicationTypeResultLabel: UILabel = {
        let label = UILabel()
        label.font = UIFont.PFSC_B(ofSize: 24)
        label.textColor = UIColor(hex: 0xD48638)
        label.text = "--"
        return label
    }()

    private lazy var dotView: UIView = {
        let view = UIView()
        view.backgroundColor = UIColor(hexString: "#F2DABF")
        view.layer.cornerRadius = 1.0
        view.clipsToBounds = true
        return view
    }()

    private lazy var infoDetailLabel: UILabel = {
        let label = UILabel()
        label.font = UIFont.PFSC_M(ofSize: 14)
        label.textColor = UIColor.mainTextColor
        label.text = "--"
        label.numberOfLines = 0
        label.lineBreakMode = .byCharWrapping
        return label
    }()

    override init(frame: CGRect) {
        super.init(frame: frame)
        backgroundColor = UIColor(hex: 0x070E33)
        setUpView()
    }

    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }

    func update(type: YHGCApplicationType, name: String) {
        applicationTypeResultLabel.text = type.shortTitleString
        infoDetailLabel.attributed.text = type.attributedTips()
        nameLabel.text = name
    }

    private func setUpView() {
        addSubview(centerImageView)
        addSubview(centerView)
        addSubview(leftImageView)
        addSubview(rightImageView)
        addSubview(nameLabel)
        addSubview(messageLabel)
        addSubview(logoImageView)
        addSubview(titleCoverView)
        titleCoverView.addSubview(titleView)
        titleCoverView.addSubview(titleLabel)
        addSubview(subContainerView)
        subContainerView.addSubview(applicationTypeLabel)
        subContainerView.addSubview(applicationTypeResultLabel)
        addSubview(dotView)
        addSubview(infoDetailLabel)
        centerImageView.snp.makeConstraints { make in
            make.left.right.top.equalToSuperview()
            make.height.equalTo(416)
        }

        centerView.snp.makeConstraints { make in
            make.left.equalTo(8)
            make.right.equalTo(-8)
            make.top.equalTo(416)
            make.bottom.equalToSuperview()
        }

        leftImageView.snp.makeConstraints { make in
            make.left.equalTo(35)
            make.height.equalTo(80)
            make.width.equalTo(65)
            make.top.equalTo(27)
        }

        rightImageView.snp.makeConstraints { make in
            make.right.equalTo(-35)
            make.height.equalTo(80)
            make.width.equalTo(65)
            make.top.equalTo(27)
        }

        nameLabel.snp.makeConstraints { make in
            make.right.equalTo(-75)
            make.height.equalTo(33.5)
            make.left.equalTo(75)
            make.top.equalTo(26)
        }

        messageLabel.snp.makeConstraints { make in
            make.right.equalTo(-75)
            make.height.equalTo(43)
            make.left.equalTo(75)
            make.top.equalTo(65.5)
        }

        logoImageView.snp.makeConstraints { make in
            make.centerX.equalToSuperview()
            make.height.equalTo(22)
            make.width.equalTo(58.5)
            make.top.equalTo(147)
        }
        
        titleCoverView.snp.makeConstraints { make in
            make.left.equalTo(28)
            make.right.equalToSuperview().offset(-28)
            make.top.equalTo(234)
            make.height.equalTo(44)
        }

        titleView.snp.makeConstraints { make in
            make.left.equalToSuperview()
            make.top.equalTo(4)
            make.height.equalTo(16.5)
            make.width.equalTo(3.5)
        }

        titleLabel.snp.makeConstraints { make in
            make.centerY.equalTo(titleView.snp.centerY)
            make.left.equalTo(titleView.snp.right).offset(4)
        }

        subContainerView.snp.makeConstraints { make in
            make.left.equalTo(titleCoverView.snp.left)
            make.top.equalTo(titleCoverView.snp.bottom).offset(-2)
            make.right.equalToSuperview().offset(-28)
            make.height.equalTo(64)
        }

        applicationTypeLabel.snp.makeConstraints { make in
            make.left.equalToSuperview().offset(16)
            make.centerY.equalToSuperview()
        }

        applicationTypeResultLabel.snp.makeConstraints { make in
            make.right.equalToSuperview().offset(-16)
            make.centerY.equalToSuperview()
            make.left.greaterThanOrEqualTo(applicationTypeLabel.snp.right).offset(10)
        }

        infoDetailLabel.snp.makeConstraints { make in
            make.left.equalTo(subContainerView.snp.left).offset(11)
            make.top.equalTo(subContainerView.snp.bottom).offset(13)
            make.right.lessThanOrEqualToSuperview().offset(-28)
        }

        dotView.snp.makeConstraints { make in
            make.right.equalTo(infoDetailLabel.snp.left).offset(-4)
            make.top.equalTo(infoDetailLabel.snp.top).offset(8)
            make.width.height.equalTo(3)
        }
    }
}

private extension YHGCApplicationType {
    func attributedTips() -> ASAttributedString {
        switch self {
        case .typeA:
            let attr1: ASAttributedString = .init(string: "根据您提交的信息，您近12个月的税前收入超过", .font(UIFont.PFSC_R(ofSize: 14)), .foreground(UIColor.mainTextColor))
            let attr2: ASAttributedString = .init(string: "250万港元", .font(UIFont.PFSC_B(ofSize: 14)), .foreground(UIColor(hexString: "#D48638") ?? .brown))
            let attr3: ASAttributedString = .init(string: "，符合", .font(UIFont.PFSC_R(ofSize: 14)), .foreground(UIColor.mainTextColor))
            let attr4: ASAttributedString = .init(string: "高才A类", .font(UIFont.PFSC_B(ofSize: 14)), .foreground(UIColor(hexString: "#D48638") ?? .brown))
            let attr5: ASAttributedString = .init(string: "申请资格。", .font(UIFont.PFSC_R(ofSize: 14)), .foreground(UIColor.mainTextColor))
            return attr1 + attr2 + attr3 + attr4 + attr5
        case .typeB:
            let attr1: ASAttributedString = .init(string: "根据您提交的信息，您已取得", .font(UIFont.PFSC_R(ofSize: 14)), .foreground(UIColor.mainTextColor))
            let attr2: ASAttributedString = .init(string: "合资格高校学士学位", .font(UIFont.PFSC_B(ofSize: 14)), .foreground(UIColor(hexString: "#D48638") ?? .brown))
            let attr3: ASAttributedString = .init(string: "，符合", .font(UIFont.PFSC_R(ofSize: 14)), .foreground(UIColor.mainTextColor))
            let attr4: ASAttributedString = .init(string: "高才B类", .font(UIFont.PFSC_B(ofSize: 14)), .foreground(UIColor(hexString: "#D48638") ?? .brown))
            let attr5: ASAttributedString = .init(string: "申请资格。", .font(UIFont.PFSC_R(ofSize: 14)), .foreground(UIColor.mainTextColor))
            return attr1 + attr2 + attr3 + attr4 + attr5
        case .typeC:
            let attr1: ASAttributedString = .init(string: "根据您提交的信息，您已取得", .font(UIFont.PFSC_R(ofSize: 14)), .foreground(UIColor.mainTextColor))
            let attr2: ASAttributedString = .init(string: "合资格高校学士学位", .font(UIFont.PFSC_B(ofSize: 14)), .foreground(UIColor(hexString: "#D48638") ?? .brown))
            let attr3: ASAttributedString = .init(string: "，符合", .font(UIFont.PFSC_R(ofSize: 14)), .foreground(UIColor.mainTextColor))
            let attr4: ASAttributedString = .init(string: "高才C类", .font(UIFont.PFSC_B(ofSize: 14)), .foreground(UIColor(hexString: "#D48638") ?? .brown))
            let attr5: ASAttributedString = .init(string: "申请资格。", .font(UIFont.PFSC_R(ofSize: 14)), .foreground(UIColor.mainTextColor))
            return attr1 + attr2 + attr3 + attr4 + attr5
        }
    }
}
