//
//  YHGCMySchemeViewModel.swift
//  galaxy
//
//  Created by alexzzw on 2024/12/21.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHGCMySchemeViewModel: YHBaseViewModel {
    var schemeModel: YHGCMySchemeModel?

    // 我的方案
    func getMySchemeData(params: [String: Any], callBackBlock: @escaping (_ success: Bool, _ error: YHErrorModel?) -> Void) {
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.GCAssessment.applyPlanApi

        _ = YHNetRequest.getRequest(url: strUrl, params: params) { [weak self] json, _ in
            // 1. json字符串 转 对象
            guard let self = self else { return }
            printLog("model 是 ==> \(json)")

            if json.code == 200 {
                guard let dic = json.data?.peel as? [String: Any], let resultModel = YHGCMySchemeModel.deserialize(from: dic) else {
                    let err = YHErrorModel(errorCode: YHErrorCode.dictParseError.rawValue, errorMsg: YHErrorCode.dictParseError.description())
                    callBackBlock(false, err)
                    return
                }
                self.schemeModel = resultModel
                callBackBlock(true, nil)
            } else {
                let err = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg.isEmpty ? "" : json.msg)
                callBackBlock(false, err)
            }
        } failBlock: { err in
            callBackBlock(false, err)
        }
    }
}
