//
//  YHGCDocListCell.swift
//  galaxy
//
//  Created by EDY on 2024/12/24.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHGCDocListCell: UITableViewCell {
    var centerView: UIView = {
        let view = UIView()
        view.backgroundColor = .white
        view.layer.cornerRadius = kCornerRadius6
        return view
    }()
    
    var titleLabel: UILabel = {
        let label = UILabel()
        label.font = UIFont.PFSC_M(ofSize: 16)
        label.textColor = UIColor.mainTextColor
        label.lineBreakMode = .byWordWrapping
        label.numberOfLines = 0
        return label
    }()
    
    var statusLabel: UILabel!
    
    lazy var statusHoldView: UIView = {
        let view = UIView()
        return view
    }()
    
    lazy var checkButton: UIButton = {
        let button = UIButton(type: .custom)
        button.titleLabel?.font = UIFont.PFSC_R(ofSize: 15)
        button.contentHorizontalAlignment = .center
        button.setTitleColor(UIColor.mainTextColor, for: .normal)
        button.setImage(UIImage(named: "my_doc_check_btn_0"), for: .normal)
        button.setImage(UIImage(named: "my_doc_check_btn_1"), for: .selected)
        button.isUserInteractionEnabled = false
        return button
    }()
    
    var dataSourceForSign: YHGCMySignatureModel? {
        didSet {
            updateAllViewsForSign()
        }
    }
    
    required init?(coder: NSCoder) {
        super.init(coder: coder)
    }
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        selectionStyle = .none
        setupUI()
    }
    
    func setupUI() {
        backgroundColor = .clear
        
        contentView.addSubview(centerView)
        centerView.snp.makeConstraints { make in
            make.left.equalTo(kMargin)
            make.right.equalTo(-kMargin)
            make.top.equalTo(14)
            make.bottom.equalToSuperview()
        }
        
        centerView.addSubview(statusHoldView)
        statusHoldView.snp.makeConstraints { make in
            make.centerY.equalToSuperview()
            make.right.equalTo(-kMargin)
            make.height.equalTo(20)
            make.width.equalTo(62)
        }
        
        let imageV: UIImageView = UIImageView()
        imageV.image = UIImage(named: "my_doc_right_arrow")
        statusHoldView.addSubview(imageV)
        imageV.snp.makeConstraints { make in
            make.right.equalToSuperview()
            make.centerY.equalToSuperview()
            make.width.height.equalTo(kMargin)
        }
        
        statusLabel = {
            let label = UILabel()
            label.font = UIFont.PFSC_M(ofSize: 14)
            label.textColor = UIColor.brandMainColor
            label.textAlignment = .right
            label.text = "待审核"
            return label
        }()
        
        statusHoldView.addSubview(statusLabel)
        statusLabel.snp.makeConstraints { make in
            make.right.equalTo(imageV.snp.left).offset(-4)
            make.centerY.equalToSuperview()
            make.width.equalTo(42)
            make.height.equalTo(20)
        }
        centerView.addSubview(titleLabel)
        titleLabel.snp.makeConstraints { make in
            make.top.equalTo(22)
            make.left.equalTo(21)
            make.right.equalTo(-90)
            make.bottom.equalTo(-22)
        }
        
        centerView.addSubview(checkButton)
        checkButton.snp.makeConstraints { make in
            make.right.equalToSuperview().offset(-kMargin)
            make.centerY.equalToSuperview()
            make.width.height.equalTo(kMargin)
        }
        checkButton.isHidden = true
    }
    
    // 签字状态
    func updateAllViewsForSign() {
        guard let dataSource = dataSourceForSign else { return }
        titleLabel.text = dataSource.doc_type_text
        if dataSource.isEditFlag {
            checkButton.isHidden = false
            statusHoldView.isHidden = true
            checkButton.isSelected = dataSource.isSelectedFlag
        } else {
            checkButton.isHidden = true
            statusHoldView.isHidden = false
            /*
             3: '待签章',
             4: '已签章',
             5: '已完成',
             6: '已驳回'
             */
            var statusTxt = ""
            var color: UIColor = .brandMainColor
            
            let status = dataSource.doc_status
            if dataSource.doc_type == 1000 {
                if status == 1000 || status == 1001 || status == 1002 || status == 1003 {
                    statusTxt = "待签署"
                    color = UIColor.brandMainColor
                } else if status == 1004 || status == 1005 || status == 1006 {
                    statusTxt = "审核中"
                    color = UIColor.failColor
                } else if status == 1007 {
                    statusTxt = "已完成"
                    color = UIColor.labelTextColor2
                }
            } else if dataSource.doc_type == 1001 {
                if status == 1000 || status == 1001 || status == 1002 {
                    statusTxt = "待补充"
                    color = UIColor.brandMainColor
                } else if status == 1003 {
                    statusTxt = "待签章"
                    color = UIColor.brandMainColor
                } else if status == 1004 || status == 1005 || status == 1006 {
                    statusTxt = "审核中"
                    color = UIColor.failColor
                } else if status == 1007 {
                    statusTxt = "已完成"
                    color = UIColor.labelTextColor2
                }
            } else if dataSource.doc_type == 1002 {
                if status == 1000 || status == 1001 || status == 1002 || status == 1003 {
                    statusTxt = "待签署"
                    color = UIColor.brandMainColor
                } else if status == 1004 || status == 1005 || status == 1006 {
                    statusTxt = "审核中"
                    color = UIColor.failColor
                } else if status == 1007 {
                    statusTxt = "已完成"
                    color = UIColor.labelTextColor2
                }
            }
            
            statusLabel.text = statusTxt
            statusLabel.textColor = color
        }
        
    }
}
