//
//  YHGCSignatureAddViewModel.swift
//  galaxy
//
//  Created by EDY on 2024/12/25.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHGCSignatureAddViewModel: YHBaseViewModel {
    var position: YHGCSignatureAddModel = YHGCSignatureAddModel()
    
    override init() {
        super.init()
    }
    
    func getBaseDataSource(_ isShowPrompt: Bool) -> [YHSectionWorkExperienceModel] {
        let item = YHWorkExperienceModel(id: .id1, isNeed: true, title: "档案所在单位", isUserKeyBoard: true, prompts: "请输入", message: position.archives_location, isShowPrompts: isShowPrompt, alertMessage: "请输入")
        let item1 = YHWorkExperienceModel(id: .id2, isNeed: true, title: "单位名称", isUserKeyBoard: true, prompts: "请选择", message: position.unit_name, isShowPrompts: isShowPrompt, alertMessage: "请选择")
        let item2 = YHWorkExperienceModel(id: .id3, isNeed: true, title: "单位地址", isUserKeyBoard: true, prompts: "请选择", message: position.unit_address, isShowPrompts: isShowPrompt, alertMessage: "请输入")
        let item3 = YHWorkExperienceModel(id: .id4, isNeed: true, title: "负责人电话", isUserKeyBoard: true, prompts: "请输入", message: position.phone, isShowPrompts: isShowPrompt, alertMessage: "请输入")
        let item4 = YHWorkExperienceModel(id: .id5, isNeed: false, title: "公司邮箱", isUserKeyBoard: true, prompts: "请输入", message: position.email, isShowPrompts: isShowPrompt, alertMessage: "请输入")
       
        var section = YHSectionWorkExperienceModel(title: "企业信息", models: [item, item1, item2, item3, item4])

        return [section]
    }
    
    func updateModel(_ item: YHWorkExperienceModel) {
        guard let type = item.id else { return }
        switch type {
        case .id1: // 用人单位
            position.archives_location = item.message ?? ""
        case .id2: // 用人单位性质
            position.unit_name = item.message ?? ""
        case .id3:
            position.unit_address = item.message ?? ""
        case .id4:
            position.phone = item.message ?? ""
        case .id5:
            position.email = item.message ?? ""
        default: break
        }
    }
    
    func isCanNext() -> Bool {
        let archives_location = position.archives_location
        let unit_name = position.unit_name
        let unit_address = position.unit_address
        let phone = position.phone
        
        guard archives_location.count > 0 else { return false }
        guard unit_name.count > 0 else { return false }
        guard unit_address.count > 0 else { return false }
        guard phone.count > 0 else { return false }
        return true
    }
    
    func requestDetail(_ orderID: Int, callBackBlock: @escaping (_ success: Bool?, _ error: YHErrorModel?) -> Void) {
        let param: [String: Any] = ["order_id": orderID]
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.Signature.gcinfo
        _ = YHNetRequest.getRequest(url: strUrl, params: param) { [weak self] json, _ in
            // 1. json字符串 转 对象
            guard let self = self else { return }
            if json.code == 200 {
                
                guard let dic = json.data?.peel as? [String: Any], let result = YHGCSignatureAddModel.deserialize(from: dic) else {
                    callBackBlock(false, nil)
                    return
                }
                self.position = result
                callBackBlock(true, nil)
            } else {
                let error: YHErrorModel = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg)
                callBackBlock(false, error)
            }
        } failBlock: { err in
            callBackBlock(false, err)
        }
    }
    
    func saveGcSaveinfo(callBackBlock: @escaping (_ success: Bool?, _ error: YHErrorModel?) -> Void) {
        let params: [String: Any] = ["id": position.id,
                                      "order_id": position.order_id,
                                      "archives_location": position.archives_location,
                                      "unit_name": position.unit_name,
                                      "phone": position.phone,
                                      "unit_address": position.unit_address,
                                      "email": position.email]
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.Signature.gcSaveinfo
        _ = YHNetRequest.postRequest(url: strUrl, params: params) { [weak self] json, _ in
            guard let self = self else { return }
            if json.code == 200 {
                guard let dic = json.data?.peel as? [String: Any], let result = YHWorkExperiencePositionModel.deserialize(from: dic) else {
                    callBackBlock(false, nil)
                    return
                }
                callBackBlock(true, nil)
            } else {
                let error: YHErrorModel = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg)
                callBackBlock(false, error)
            }
        } failBlock: { err in
            callBackBlock(false, err)
        }
    }
}
