//
//  YHGCApplicationTypeViewModel.swift
//  galaxy
//
//  Created by alexzzw on 2024/11/12.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHGCApplicationTypeViewModel: YHBaseViewModel {
    
    func getApplyType(orderId: Int, callback: @escaping (_ model: YHGCApplicationTypeResponseModel?, _ error: YHErrorModel?) -> Void) {
        let params = ["order_id": orderId]
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.GCApplyType.getApplyType
        _ = YHNetRequest.getRequest(url: strUrl, params: params) { json, _ in
            // 1. json字符串 转 对象
            printLog("model 是 ==> \(json)")
            
            if json.code == 200 {
                guard let dic = json.data?.peel as? [String: Any], let resultModel = YHGCApplicationTypeResponseModel.deserialize(from: dic) else {
                    let err = YHErrorModel(errorCode: YHErrorCode.dictParseError.rawValue, errorMsg: YHErrorCode.dictParseError.description())
                    callback(nil, err)
                    return
                }
                callback(resultModel, nil)
                
            } else {
                let err = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg.isEmpty ? "" : json.msg)
                callback(nil, err)
            }
            
        } failBlock: { err in
            callback(nil, err)
        }
    }
    
    func submitApplyType(_ orderId: Int, _ applyType: Int, callBackBlock: @escaping (_ success: Bool, _ error: YHErrorModel?) -> Void ) {
        let params: [String: Any] = ["order_id": orderId, "apply_type": applyType]
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.GCApplyType.submitApplyType
        _ = YHNetRequest.postRequest(url: strUrl, params: params) { json, _ in
            // 1. json字符串 转 对象
            printLog("model 是 ==> \(json)")
            if json.code == 200 {
                callBackBlock(true, nil)
            } else {
                let err = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg.isEmpty ? "" : json.msg)
                callBackBlock(false, err)
            }
        } failBlock: { err in
            callBackBlock(false, err)
        }
    }

}
