//
//  YHGCChildPrimaryInfoVC.swift
//  galaxy
//
//  Created by Dufet on 2024/12/19.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

class YHGCChildPrimaryInfoVC: YHBaseViewController, YHFamilyMemberProtol {

    var child: YHFamilyMember?
    var mainApplicantInfo: YHMyMainApplicantInfoModel?

    weak var delegate: YHSpouseInfoVCProtocol?
    var isNeedShowError = false
    // 是否随行能编辑
    var isFollowCanEdit = true

    lazy var items: [[YHFormItemProtocol]] = [[YHFormItemProtocol]]()
    
    lazy var tableView: UITableView = {
        
        let tableView = UITableView(frame: .zero, style: .grouped)

        if #available(iOS 11.0, *) {
            tableView.contentInsetAdjustmentBehavior = .never
        }
        tableView.estimatedSectionHeaderHeight = 14.0
        tableView.estimatedSectionFooterHeight = 1.0
        tableView.showsVerticalScrollIndicator = false
        tableView.backgroundColor = UIColor(hexString: "#F8F8F8")
        tableView.separatorStyle = .none
        tableView.delegate = self
        tableView.dataSource = self
        tableView.register(UITableViewCell.self, forCellReuseIdentifier: "UITableViewCell")
        tableView.register(YHFormItemDoubleChoiceCell.self, forCellReuseIdentifier: YHFormItemDoubleChoiceCell.cellReuseIdentifier)
        tableView.register(YHFormItemInputTextCell.self, forCellReuseIdentifier: YHFormItemInputTextCell.cellReuseIdentifier)
        tableView.register(YHFormItemEnterDetailCell.self, forCellReuseIdentifier: YHFormItemEnterDetailCell.cellReuseIdentifier)
        tableView.register(YHFormItemTitleCell.self, forCellReuseIdentifier: YHFormItemTitleCell.cellReuseIdentifier)
        tableView.register(YHFormItemAddCell.self, forCellReuseIdentifier: YHFormItemAddCell.cellReuseIdentifier)
        tableView.register(YHFormItemSelectSheetCell.self, forCellReuseIdentifier: YHFormItemSelectSheetCell.cellReuseIdentifier)
        
        return tableView
    }()
    
    override func viewDidLoad() {
        super.viewDidLoad()
        gk_navigationBar.isHidden = true
        view.backgroundColor = UIColor(hexString: "#F8F8F8")
        createUI()
        loadInfo()
    }
    
    func loadInfo() {
                        
        guard let child = child else { return }
        
        items.removeAll()

        isFollowCanEdit = !child.is18YearsOld()
        // 随行
        let title0 = YHFormTitleItem(type: .E)
        let item00 = YHFormDetailItem(type: .ownCustody, value: String(child.isOwnCustody()))
        let item01 = YHFormDetailItem(type: .birthday, value: child.birthday, tips: "请选择出生日期".local)
        let item02 = YHFormDetailItem(type: .isAccompanyToHK, value: String(child.isFollow()))
        let arr0: [YHFormItemProtocol] = [title0, item00, item01, item02]
        items.append(arr0)
        
        if child.isFollow() { // 随行才加后面的信息
            // 国籍
            let title1 = YHFormTitleItem(type: .F)
            let item10 = YHFormDetailItem(type: .nationOrArea, value: child.nationality, tips: "请选择国籍".local)
            let arr1: [YHFormItemProtocol] = [title1, item10]
            
            // 居住信息
            let title2 = YHFormTitleItem(type: .G)
            let item20 = YHFormDetailItem(type: .isLiveTother, value: String(child.isLiveTother()))
            var arr2: [YHFormItemProtocol] = [title2, item20]
            
            let addResidenceBlock = {
                let item21 = YHFormDetailItem(type: .permanentResidenceStatus, value: String(child.havePermanentResidency))
                item21.tips = "请选择"
                arr2.append(item21)
            }
            
            if !child.isLiveTother() { // 不同住 才需填写国家/地区
                let item21 = YHFormDetailItem(type: .nationOrArea, value: child.address.country, tips: "请选择国家/地区".local)
                arr2.append(item21)
                
                // 国家/地区已填写 才显示现居住城市和详细地址两行
                
                if !child.address.country.isEmpty {
                        
                    // 居住信息中选择中国才会显示现居住城市
                    let isLiveInChina = child.address.country.contains("中国".local)
                    if isLiveInChina {
                        var value = ""
                        if !child.address.area.isEmpty {
                           value = child.address.area.joined(separator: ",")
                        }
                        let item22 = YHFormDetailItem(type: .liveCity, value: value, tips: "请选择现居住城市".local)
                        arr2.append(item22)
                    }
                    let placeHolder = (isLiveInChina ? "请填写小区、楼栋、单元室等".local : "请填写国外居住地".local)
                    let detailAddress = isLiveInChina ? child.address.details : child.address.foreign
                    let item23 = YHFormDetailItem(type: .detailAddress, value: detailAddress, placeHolder: placeHolder, tips: placeHolder)
                    arr2.append(item23)
                    
                    addResidenceBlock()
                    
                    if !isLiveInChina {// 在国外
                        // 是否在海外居住满1年及以上
                        let item24 = YHFormDetailItem(type: .isLiveOverSeasMore1Year, value: String(child.isOverSeasOver1Year()))
                        arr2.append(item24)
                    }
                } else {
                    addResidenceBlock()
                }
                
            } else {
                addResidenceBlock()
            }
            
            items.append(contentsOf: [arr1, arr2])
            
            // 港澳通信证
            var isHiddenHK = true
            // 国籍
            let nationality = child.nationality
            // 居住国家
            var liveCountry = child.address.country
            // 居住海外是否满一年
            var isLiveOverseaYear = child.isOverSeasOver1Year()
            
            if child.isLiveTother(), let mainApplicantInfo = mainApplicantInfo {
                // 与主申请人同住需要用主申请人居住信息判断
                liveCountry = mainApplicantInfo.applicant_address.country
                isLiveOverseaYear = mainApplicantInfo.isOverSeasOver1Year()

            }
            
            if child.nationality.contains("中国") { // 中国国籍
                let isLiveInChina = liveCountry.contains("中国".local)
                if isLiveInChina || (!isLiveInChina && !isLiveOverseaYear) {
                    // 中国国籍&居住国内、中国国籍&居住国外不满一年 需展示“港澳通行证”询问框
                    isHiddenHK = false
                }
            }
            
            if !isHiddenHK {
                let title3 = YHFormTitleItem(type: .hkAndMacaoPassport)
                let item30 = YHFormDetailItem(type: .isHandleHKPassPort, value: String(child.isNeedHandleHKPassPort()))
                let arr3: [YHFormItemProtocol] = [title3, item30]
                items.append(arr3)
            }
        }

        tableView.reloadData()
    }
    
    func createUI() {
        
        view.addSubview(tableView)
        let topHeight = k_Height_NavigationtBarAndStatuBar+YHStepView.height
        let bottomHeight = YHSaveAndSubmitView.height
        tableView.snp.makeConstraints { make in
            make.top.equalToSuperview()
            make.left.equalToSuperview().offset(16)
            make.right.equalToSuperview().offset(-16)
            make.height.equalTo(KScreenHeight-topHeight-bottomHeight)
        }
    }
    
    func getCellType(_ item: Any) -> HKFormItemCellType {
        if item is YHFormTitleItem {
            return .title
        }
        
        if item is YHFormDetailItem {
            guard let detailItem = item as? YHFormDetailItem else { return .defaultType }
            
            if detailItem.type == .birthCity {
                var isBirthOverSeas = false
                if let child = child {
                    isBirthOverSeas = child.isBirthOverSeas()
                }
                if isBirthOverSeas {
                    return .inputText
                } else {
                    return .selectSheet
                }
            }
            
            if detailItem.type == .detailAddress {
                return .inputText
            }
            
            if detailItem.type == .nationOrArea
                || detailItem.type == .nationOrArea
                || detailItem.type == .liveCity
                || detailItem.type == .birthday {
                return .selectSheet
            }
            if detailItem.type == .isAccompanyToHK
                || detailItem.type == .isHandleHKPassPort
                || detailItem.type == .ownCustody
                || detailItem.type == .isLiveTother
                || detailItem.type == .isLiveOverSeasMore1Year
                || detailItem.type == .permanentResidenceStatus {
                return .twoChoice
            }
        }
        return .defaultType
    }
}

extension YHGCChildPrimaryInfoVC: UITableViewDelegate, UITableViewDataSource {
    
    func numberOfSections(in tableView: UITableView) -> Int {
        return items.count
    }
    
    func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        if section >= items.count { return 0 }
        let arr = items[section]
        return arr.count
    }
    
    func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        
        if indexPath.section >= items.count { return createDefaultCell(indexPath) }
        let arr: [YHFormItemProtocol] = items[indexPath.section]
        if indexPath.row >= arr.count {  return createDefaultCell(indexPath) }
        
        let item: YHFormItemProtocol = arr[indexPath.row]
        
        if item is YHFormTitleItem { // 标题
            guard let cell = tableView.dequeueReusableCell(withIdentifier: YHFormItemTitleCell.cellReuseIdentifier, for: indexPath) as? YHFormItemTitleCell else { return UITableViewCell() }
            cell.setTitleAndSubTitle(title: item.getTitle())

            return cell
            
        } else if item is YHFormDetailItem { // 具体信息
            
            guard let detailItem = item as? YHFormDetailItem else { return UITableViewCell() }
            let cellType = self.getCellType(detailItem)
            
            if cellType == .twoChoice {
                
                guard let cell = tableView.dequeueReusableCell(withIdentifier: YHFormItemDoubleChoiceCell.cellReuseIdentifier, for: indexPath) as? YHFormItemDoubleChoiceCell else { return UITableViewCell() }
                cell.isMust = detailItem.isNeed
                cell.title = detailItem.getTitle()
                cell.enableEdit = true
                cell.disableEditTips = nil
                
                var isShowTips = detailItem.isShowTips
                if detailItem.type == .permanentResidenceStatus {
                    isShowTips = ((child?.isHavePermanentResidenceStatus()) == nil)
                    
                }
                cell.setTips(detailItem.tips, isShow: isNeedShowError && isShowTips)

                if detailItem.type == .isAccompanyToHK, let child = child, child.is18YearsOld() { // 是否随行至香港
                    // 年满18岁不能随行 随行按钮不可编辑固定为否
                    cell.enableEdit = isFollowCanEdit
                    cell.disableEditTips = "年满十八岁的子女不能随行至香港"
                }
                
                if detailItem.type == .permanentResidenceStatus { // 永久居留身份
                    var isSelectYES = false
                    var isSelectNO = false
                    
                    if let value = detailItem.value, let status = Int(value) {
                        if status == 2 {
                            isSelectYES = false
                            isSelectNO = false
                            
                        } else if status == 1 {
                            isSelectYES = true
                            isSelectNO = false
                            
                        } else if status == 0 {
                            isSelectYES = false
                            isSelectNO = true
                            
                        }
                    }
                    
                    let answers = [YHFormChoiceItem(title: "是".local, isSelect: isSelectYES), YHFormChoiceItem(title: "否".local, isSelect: isSelectNO)]
                    cell.answerArr = answers
                    
                } else {
                    
                    var select = false
                    if let value = detailItem.value {
                        select = Bool(value)!
                    }
                    
                    let answers = [YHFormChoiceItem(title: "是".local, isSelect: select), YHFormChoiceItem(title: "否".local, isSelect: !select)]
                    cell.answerArr = answers
                }
                            
                cell.answerBlock = {
                    
                    [weak self]  (arr, selectIndex) in
                    
                    let selectItem: YHFormChoiceItem = arr[selectIndex]
                    let option = (selectItem.title == "是".local ? true : false)

                    guard let self = self else { return }
                    if detailItem.type == .isAccompanyToHK { // 是否随行
                        
                        self.child?.setFollow(option)
                        if let delegate = delegate, delegate.responds(to: #selector(YHSpouseInfoVCProtocol.updateStepView)) {
                            delegate.updateStepView()
                        }
                        
                    } else if detailItem.type == .isHandleHKPassPort { // 是否办理港澳通行证
                        self.child?.setNeedHandleHKPassPort(option)
                        
                    } else if detailItem.type == .isLiveTother { // 是否与主申请人同住
                        self.child?.setLiveTother(option)
                        if option {
                            self.child?.address.clearAddress()
                        }
                    } else if detailItem.type == .isLiveOverSeasMore1Year { // 是否在海外居住满1年及以上
                        self.child?.setOverSearsOver1Year(option)
                        
                    } else if detailItem.type == .ownCustody { // 抚养权
                        self.child?.setOwnCustody(option)
                        
                    } else if detailItem.type == .permanentResidenceStatus { // 永久居留身份
                        self.child?.setHavePermanentResidenceStatus(option)
                    }

                    self.loadInfo()
                    save()
                }
                return cell
                
            } else if cellType == .selectSheet { // 选择列表面板
                
                guard let cell = tableView.dequeueReusableCell(withIdentifier: YHFormItemSelectSheetCell.cellReuseIdentifier, for: indexPath) as? YHFormItemSelectSheetCell else { return UITableViewCell() }
                cell.isMust = detailItem.isNeed
                cell.title = detailItem.getTitle()
                cell.detail = detailItem.value
                cell.setTips(detailItem.tips, isShow: isNeedShowError && detailItem.isShowTips)
                return cell
                
            } else if cellType == .inputText { // 输入文字cell
                guard let cell = tableView.dequeueReusableCell(withIdentifier: YHFormItemInputTextCell.cellReuseIdentifier, for: indexPath) as? YHFormItemInputTextCell else { return UITableViewCell() }
                cell.isMust = detailItem.isNeed
                cell.placeHolder = detailItem.placeHolder
                cell.title = detailItem.getTitle()
                cell.text = detailItem.value
                cell.setTips(detailItem.tips, isShow: isNeedShowError && detailItem.isShowTips)
                cell.textInputCondtion = {
                    textField in
                    if let textStr = textField.text {
                        let max = 100
                        textField.text = textStr.count > max ? textStr[safe: ..<max] : textStr
                    }
                    return true
                }
                cell.textChange = {
                    [weak self] (text, isEditEnd) in
                    guard let self = self else { return }
                    guard let child = child else { return }

                    if detailItem.type == .detailAddress {
                        if child.isLiveInChina() {
                            child.address.details = text ?? ""
                        } else {
                            child.address.foreign = text ?? ""
                        }
                    }
                    if isEditEnd {
                        self.loadInfo()
                        save()
                    }
                }
                return cell
            }
        }
        return createDefaultCell(indexPath)
    }
    
    func tableView(_ tableView: UITableView, willDisplay cell: UITableViewCell, forRowAt indexPath: IndexPath) {
        
        if indexPath.section >= items.count { return  }
        let arr: [YHFormItemProtocol] = items[indexPath.section]
        if indexPath.row >= arr.count {  return }
        
        createCorner(cell: cell, arr: arr, indexPath: indexPath)
    }
    
    func createDefaultCell(_ indexPath: IndexPath) -> UITableViewCell {
        let cell = tableView.dequeueReusableCell(withIdentifier: "UITableViewCell", for: indexPath)
        return cell
    }
    
    func tableView(_ tableView: UITableView, heightForRowAt indexPath: IndexPath) -> CGFloat {
        return UITableView.automaticDimension
    }
    
    func tableView(_ tableView: UITableView, viewForFooterInSection section: Int) -> UIView? {
        
        return UIView()
    }
    
    func tableView(_ tableView: UITableView, viewForHeaderInSection section: Int) -> UIView? {
        
        return UIView()
    }
    
    private func tableView(_ tableView: UITableView, viewForHeaderInSection section: Int) -> CGFloat {
        return 14.0
    }
    
    private func tableView(_ tableView: UITableView, viewForFooterInSection section: Int) -> CGFloat {
        if section == items.count-1 {
            return 14.0
        }
        return 1.0
    }
    
    func tableView(_ tableView: UITableView, didSelectRowAt indexPath: IndexPath) {

        if !(0..<items.count).contains(indexPath.section) { return }
        let arr: [YHFormItemProtocol] = items[indexPath.section]
        if !(0..<arr.count).contains(indexPath.row) {  return  }
        let item = arr[indexPath.row]
        
        if item is YHFormDetailItem {
            guard let detailItem = item as? YHFormDetailItem else { return }
            // 选国籍/现居住城市/详细地址
            if detailItem.type == .nationOrArea {
               let vc = YHSelectCountryViewController()
                vc.backLocationStringController = {
                    [weak self] country in
                    guard let self = self else { return }
                    guard let title = arr[0] as? YHFormTitleItem else { return }
                    if title.type == .F { // 选国籍
                        self.child?.nationality = country

                    } else if title.type == .G { // // 居住信息选国家地区
                        self.child?.address.country = country
                        // 选择国家地区后需清空城市
                        self.child?.address.area = []

                    }
                    self.loadInfo()
                    save()
                }
                self.navigationController?.pushViewController(vc)
                
            } else if detailItem.type == .liveCity {
                
                var provice = ""
                if let country = self.child?.address.country {
                    if country.contains("台湾") {
                        provice = "台湾省"
                    }
                    if country.contains("香港") {
                        provice = "香港特别行政区"
                    }
                    if country.contains("澳门") {
                        provice = "澳门特别行政区"
                    }
                }
                
                let addressPicker = YHAddressViewController(selectProvince: provice)
                addressPicker.backLocationStringController = {
                    [weak self] (address, province, city, area) in
                    guard let self = self else { return }
                    print("\(address)\n\(province)\n\(city)\n\(area)")
                    var citys: [String] = []
                    if !isEmptyString(province) {
                        citys.append(province)
                    }
                    if !isEmptyString(city) {
                       citys.append(city)
                    }
                    self.child?.address.area = citys
                    self.loadInfo()
                    save()
                }
                UIViewController.current?.present(addressPicker, animated: true, completion: nil)

            } else if detailItem.type == .birthday { // 出生日期
                
                // 子女选择年满18岁则【是否随行至香港】默认选择否，不可修改
                // 如果未年满18岁则【是否随行至香港】可选择【是/否】,可修改
                YHDatePickView.show(type: .yyyymmdd, title: "选择出生日期".local, lastIsTaday: true, currentDay: child?.birthday ?? "") { [weak self] date in
                    guard let self = self else { return }
                    
                    if detailItem.type == .birthday {
                        guard let child = child else { return }
                        child.birthday = date
                        isFollowCanEdit = !child.is18YearsOld()
                        if child.is18YearsOld() {
                            child.setFollow(false)
                        }
                        if let delegate = delegate, delegate.responds(to: #selector(YHSpouseInfoVCProtocol.updateStepView)) {
                            delegate.updateStepView()
                        }
                    }
                    self.loadInfo()
                    save()
                }
            }
        }
    }
        
    func createCorner(cell: UITableViewCell, arr: [Any], indexPath: IndexPath) {
        // 复用时需清理
        cell.layer.mask = nil
        // 设置每块section圆角
        if indexPath.row == 0 {
            let corner = UIRectCorner(rawValue: UIRectCorner.topLeft.rawValue | UIRectCorner.topRight.rawValue)
            cell.createCorner(CGSize(width: 12.0, height: 12.0), corner)
            
        } else if indexPath.row == arr.count-1 {
            let corner = UIRectCorner(rawValue: UIRectCorner.bottomLeft.rawValue | UIRectCorner.bottomRight.rawValue)
            cell.createCorner(CGSize(width: 12.0, height: 12.0), corner)
            
        } else {
            cell.layer.mask = nil
        }
    }
}

extension YHGCChildPrimaryInfoVC {
    
    // 检查填写信息完整性
    func checkIntegrity() -> Bool {
       
        guard let child = child else { return false}
        if !child.isFollow() {
            if isEmptyString(child.birthday) {
                return false
            }
            return true
        }
        
        if isEmptyString(child.birthday) {
            return false
        }
        
        if isEmptyString(child.nationality) {
            return false
        }
        
        if child.isHavePermanentResidenceStatus() == nil {
            return false
        }

        if !child.isLiveTother() { // 没有与主申请人同住
            if isEmptyString(child.address.country) {
                return false
            }
            if child.isLiveInChina() {
                if isEmptyArray(child.address.area) {
                    return false
                }
                if isEmptyString(child.address.details) {
                    return false
                }
            } else { // 住在国外
                if isEmptyString(child.address.foreign) {
                    return false
                }
            }
        }
        return true
    }
    
    func nextStep() -> Bool {
        let isChecked = checkIntegrity()
        isNeedShowError = !isChecked
        
        loadInfo()
        
        if !isChecked {
            YHHUD.flash(message: "资料还未填完")
            return false
        }
        return true
    }
    
    func save() {
        if let delegate = delegate, delegate.responds(to: #selector(YHSpouseInfoVCProtocol.saveInfoSilent)) {
            delegate.saveInfoSilent()
        }
    }
}
