//
//  YHGCSpouseBasicInfoVC.swift
//  galaxy
//
//  Created by Dufet on 2024/12/19.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHGCSpouseBasicInfoVC: YHBaseViewController, YHFamilyMemberProtol {
    
    var spouse: YHFamilyMember?
    weak var delegate: YHSpouseInfoVCProtocol?
    // 是否显示未填写错误提示
    var isNeedShowError = false
    var items: [[YHFormItemProtocol]] = [[YHFormItemProtocol]]()
    
    lazy var tableView: UITableView = {
        
        let tableView = UITableView(frame: .zero, style: .grouped)

        if #available(iOS 11.0, *) {
            tableView.contentInsetAdjustmentBehavior = .never
        }
        tableView.estimatedSectionHeaderHeight = 14.0
        tableView.estimatedSectionFooterHeight = 1.0
        tableView.showsVerticalScrollIndicator = false
        tableView.backgroundColor = UIColor(hexString: "#F8F8F8")
        tableView.separatorStyle = .none
        tableView.delegate = self
        tableView.dataSource = self
        tableView.register(UITableViewCell.self, forCellReuseIdentifier: "UITableViewCell")
        tableView.register(YHFormItemDoubleChoiceCell.self, forCellReuseIdentifier: YHFormItemDoubleChoiceCell.cellReuseIdentifier)
        tableView.register(YHFormItemInputTextCell.self, forCellReuseIdentifier: YHFormItemInputTextCell.cellReuseIdentifier)
        tableView.register(YHFormItemEnterDetailCell.self, forCellReuseIdentifier: YHFormItemEnterDetailCell.cellReuseIdentifier)
        tableView.register(YHFormItemTitleCell.self, forCellReuseIdentifier: YHFormItemTitleCell.cellReuseIdentifier)
        tableView.register(YHFormItemAddCell.self, forCellReuseIdentifier: YHFormItemAddCell.cellReuseIdentifier)
        tableView.register(YHFormItemSelectSheetCell.self, forCellReuseIdentifier: YHFormItemSelectSheetCell.cellReuseIdentifier)
        tableView.register(YHFormItemDegreeInfoCell.self, forCellReuseIdentifier: YHFormItemDegreeInfoCell.cellReuseIdentifier)
        
        return tableView
    }()
    
    override func viewDidLoad() {
        super.viewDidLoad()
        gk_navigationBar.isHidden = true
        view.backgroundColor = UIColor(hexString: "#F8F8F8")
        createUI()
        loadInfo()
    }
    
    func createUI() {
        
        view.addSubview(tableView)
        let topHeight = k_Height_NavigationtBarAndStatuBar+YHStepView.height
        let bottomHeight = YHSaveAndSubmitView.height
        tableView.snp.makeConstraints { make in
            make.top.equalToSuperview()
            make.left.equalToSuperview().offset(16)
            make.right.equalToSuperview().offset(-16)
            make.height.equalTo(KScreenHeight-topHeight-bottomHeight)
        }
    }
    
    func loadInfo() {
        
        guard let spouse = spouse else { return }
        
        items.removeAll()
        
        // 配偶信息
        let title0 = YHFormTitleItem(type: .spouseInfo)
        let item00 = YHFormDetailItem(type: .spouseName)
        item00.placeHolder = "请输入".local
        item00.value = spouse.subsetName
        item00.tips = "请输入配偶姓名".local
        
        let item01 = YHFormDetailItem(type: .everName, isNeed: false)
        item01.placeHolder = "选填".local
        item01.value = spouse.usedName
        
        let item02 = YHFormDetailItem(type: .befourMarryFirstName, isNeed: false)
        item02.placeHolder = "如有则填写，仅支持输入字".local
        item02.value = spouse.surname
        
        let item03 = YHFormDetailItem(type: .birthday)
        item03.placeHolder = "请选择".local
        item03.value = spouse.birthday
        item03.tips = "请选择出生日期".local

        let item04 = YHFormDetailItem(type: .birthNation)
        item04.value = String(spouse.isBirthOverSeas())
        
        let item05 = YHFormDetailItem(type: .birthCity)
        if spouse.isBirthOverSeas() {
            item05.value = spouse.birthPlace.foreign
            item05.placeHolder = "请输入".local
            item05.tips = "请输入出生城市".local

        } else {
            item05.value = spouse.birthPlace.details
            item05.placeHolder = "请输入".local
            item05.tips = "请输入出生城市".local
            
//            item05.value = spouse.birthPlace.area.joined(separator: ",")
//            item05.placeHolder = "请选择".local
//            item05.tips = "请选择出生城市".local

        }
        let arr0: [YHFormItemProtocol] = [title0, item00, item01, item02, item03, item04, item05]
        items.append(arr0)
        
        // 职业信息
//        let title1 = YHFormTitleItem(type: .occupationInfo)
//        let item10 = YHFormDetailItem(type: .occupation)
//        item10.value = spouse.occupation
//        item10.placeHolder = "请选择".local
//        item10.tips = "请选择职业".local
//
//        var arr1:[YHFormItemProtocol] = [title1, item10]
//
//        if spouse.isNowHaveJob()  {
//            let item11 = YHFormDetailItem(type: .occupationName)
//            item11.value = spouse.occupationName
//            item11.placeHolder = "请输入".local
//            item11.tips = "请输入职业名称".local
//            arr1.append(item11)
//        }
//
        // 学位信息
//        let title2 = YHFormTitleItem(type: .degreeInfo)
//        let item20 = YHFormDetailItem(type: .ownDegree)
//        item20.placeHolder = "请选择".local
//        item20.value = spouse.hasDegreeName()
//        item20.tips = "请选择是否拥有学位".local
//
//        var arr2:[YHFormItemProtocol] = [title2, item20]
//
//        if spouse.isHaveDegree() { // 选择了有学位
//            if !spouse.hasDegreeJson.isEmpty {
//                for degreeInfo in spouse.hasDegreeJson {
//                    let item = YHFormDetailItem(type: .degreeDetailInfo)
//                    arr2.append(item)
//                }
//            } else { // 学位数组为空则添加一个
//                let item = YHFormDetailItem(type: .degreeDetailInfo)
//                let newDegree = YHHasDegreeJson()
//                spouse.hasDegreeJson = [newDegree]
//                arr2.append(item)
//            }
//            // 添加一行增加学历学位信息
//            let item = YHFormAddItem(type: .addDegree)
//            arr2.append(item)
//        }
//        items.append(contentsOf: [arr1, arr2])
        
//        if spouse.isFollow() {
//            // 在港信息
//            let title3 = YHFormTitleItem(type: .inHongKongInfo)
//            let item30 = YHFormDetailItem(type: .isNowInHK)
//            item30.value = String(spouse.isNowInHK())
//            var arr3:[YHFormItemProtocol] = [title3, item30]
//
//            if spouse.isNowInHK() { // 目前在港才显示 逗留期限和在港身份
//                let item31 = YHFormDetailItem(type: .stayHKDate)
//                item31.placeHolder = "请选择".local
//                item31.value = spouse.childInHk.info
//                item31.tips = "请选择".local
//
//                let item32 = YHFormDetailItem(type: .roleInHK)
//                item32.placeHolder = "请选择".local
//                item32.value = spouse.hkIdentity
//                item32.tips = "请选择".local
//
//                arr3.append(contentsOf: [item31, item32])
//            }
//            items.append(arr3)
//        }

        // 香港身份证
        let title4 = YHFormTitleItem(type: .hkIdentityCardInfo)
        let item40 = YHFormDetailItem(type: .isHaveHkIdentityCard)
        item40.value = String(spouse.isHaveHKIdentityCard())
        var arr4: [YHFormItemProtocol] = [title4, item40]

        if spouse.isHaveHKIdentityCard() { // 办理过香港身份证才显示证号
            let item41 = YHFormDetailItem(type: .hkIdentityCardNumber)
            item41.value = spouse.hkIdentityCard
            let tips = isEmptyString(spouse.hkIdentityCard) ? "请输入香港身份证号码".local : "请输入正确的香港身份证号码".local
            item41.tips = tips
            arr4.append(item41)
        }
        items.append(arr4)
        tableView.reloadData()
    }
    
    // 检查填写信息完整性
    func checkIntegrity() -> Bool {
        
        guard let spouse = spouse else { return false}
        if isEmptyString(spouse.subsetName) {
            return false
        }
        
        if isEmptyString(spouse.birthday) {
            return false
        }
        
        if spouse.isBirthOverSeas() {
            if isEmptyString(spouse.birthPlace.foreign) {
                return false
            }
            
        } else {
            if isEmptyString(spouse.birthPlace.details) {
                return false
            }
        }
        
//        if isEmptyString(spouse.occupation) {
//            return false
//        }
//        if spouse.isNowHaveJob(), isEmptyString(spouse.occupationName)  {
//            return false
//        }
        
//        if spouse.hasDegree.isEmpty {
//            return false
//        }
        
//        if spouse.isHaveDegree() { // 选择了有学位
//            if !spouse.hasDegreeJson.isEmpty {
//                for degreeInfo in spouse.hasDegreeJson {
//                    if isEmptyString(degreeInfo.degree) || isEmptyString(degreeInfo.address) {
//                        return false
//                    }
//                }
//            }
//        }
        
//        if spouse.isFollow() {
//            if spouse.isNowInHK() {
//                if isEmptyString(spouse.childInHk.info) ||  isEmptyString(spouse.hkIdentity) {
//                    return false
//                }
//            }
//        }
        
        if spouse.isHaveHKIdentityCard() {
            if isEmptyString(spouse.hkIdentityCard) {
                return false
            }
        }
        return true
    }
        
    func nextStep() -> Bool {
        guard let spouse = spouse else { return false }
        let isChecked = checkIntegrity()
        isNeedShowError = !isChecked
        
        loadInfo()
        
        if !isChecked {
            YHHUD.flash(message: "资料还未填完")
            return false
        }
        if spouse.isHaveHKIdentityCard(), let hkIdentityCard = spouse.hkIdentityCard, !hkIdentityCard.isHKIdentityCardNumber() {
            isNeedShowError = true
            loadInfo()
            YHHUD.flash(message: "请输入正确的香港身份证号码")
            return false
        }
        return true
    }
    
    func getCellType(_ item: Any) -> HKFormItemCellType {
        if item is YHFormTitleItem {
            return .title
        }
        
        if item is YHFormAddItem {
            return .addItem
        }
        if item is YHFormDetailItem {
            guard let detailItem = item as? YHFormDetailItem else { return .defaultType }
            
            if detailItem.type == .birthCity {
                return .inputText
                
//                var isBirthOverSeas = false
//                if let spouse = spouse {
//                    isBirthOverSeas = spouse.isBirthOverSeas()
//                }
//                if isBirthOverSeas {
//                    return .inputText
//                } else {
//                    return .selectSheet
//                }
            }
            
            if detailItem.type == .spouseName
               || detailItem.type == .everName
               || detailItem.type == .befourMarryFirstName
               || detailItem.type == .occupationName
               || detailItem.type == .hkIdentityCardNumber {
                return .inputText
            }
            if detailItem.type == .birthday
                || detailItem.type == .occupation
                || detailItem.type == .stayHKDate
                || detailItem.type == .roleInHK
                || detailItem.type == .ownDegree {
                return .selectSheet
            }
            if detailItem.type == .birthNation
                || detailItem.type == .isNowInHK
                || detailItem.type == .isHaveHkIdentityCard {
                return .twoChoice
            }
            
            if detailItem.type == .degreeDetailInfo {
                return .degreeDetailInfo
            }
        }
        return .defaultType
    }
    
}

extension YHGCSpouseBasicInfoVC: UITableViewDelegate, UITableViewDataSource {
    
    func numberOfSections(in tableView: UITableView) -> Int {
        return items.count
    }
    
    func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        if section >= items.count { return 0 }
        let arr = items[section]
        return arr.count
    }
    
    func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        
        if indexPath.section >= items.count { return createDefaultCell(indexPath) }
        let arr: [YHFormItemProtocol] = items[indexPath.section]
        if indexPath.row >= arr.count {  return createDefaultCell(indexPath) }
        let item: YHFormItemProtocol = arr[indexPath.row]
        
        let cellType = getCellType(item)
        
        if cellType == .title { // 标题
            guard let cell = tableView.dequeueReusableCell(withIdentifier: YHFormItemTitleCell.cellReuseIdentifier, for: indexPath) as? YHFormItemTitleCell else { return UITableViewCell() }
            cell.setTitleAndSubTitle(title: item.getTitle())
            return cell
        }
        
        if cellType == .addItem { // 新增item cell
            guard let cell = tableView.dequeueReusableCell(withIdentifier: YHFormItemAddCell.cellReuseIdentifier, for: indexPath) as? YHFormItemAddCell else { return UITableViewCell() }
            cell.title = item.getTitle()
            cell.clickBlock = {
                [weak self] in
                guard let self = self else { return }
                let newDegree = YHHasDegreeJson()
                self.spouse?.hasDegreeJson.append(newDegree)
                self.loadInfo()
            }
            return cell
        }
        
        if item is YHFormDetailItem {
            guard let detailItem = item as? YHFormDetailItem else { return UITableViewCell() }
            
            if cellType == .inputText { // 输入文字cell
                guard let cell = tableView.dequeueReusableCell(withIdentifier: YHFormItemInputTextCell.cellReuseIdentifier, for: indexPath) as? YHFormItemInputTextCell else { return UITableViewCell() }
                cell.isMust = detailItem.isNeed
                cell.placeHolder = detailItem.placeHolder
                cell.title = detailItem.getTitle()
                cell.text = detailItem.value
                
                if detailItem.type == .hkIdentityCardNumber { // 输入香港身份证号码
                    let isEmptyValue = isEmptyString(detailItem.value)
                    var isUnvalidFormat = true
                    if let value = detailItem.value, value.isHKIdentityCardNumber() {
                        isUnvalidFormat = false
                    }
                    let isNeedShowTips = isEmptyValue || isUnvalidFormat
                    cell.setTips(detailItem.tips, isShow: isNeedShowError && isNeedShowTips)
                } else {
                    cell.setTips(detailItem.tips, isShow: isNeedShowError && detailItem.isShowTips)
                }
                
                if detailItem.type == .befourMarryFirstName {
                    cell.textField.keyboardType = .asciiCapable //  英文键盘
                } else {
                    cell.textField.keyboardType = .default
                }
                
                cell.textInputCondtion = {
                    textField in
                    
                    if detailItem.type == .befourMarryFirstName { // 仅支持输入最多30个大写字母
                        let regex = "[^A-Za-z]+"
                        textField.limitInputWithPattern(pattern: regex, 30)
                        return true
                    }
                    
                    var max = -1
                    if detailItem.type == .spouseName ||
                        detailItem.type == .everName {
                        max = 30
                    } else if detailItem.type == .occupationName {
                        max = 50
                    } else if detailItem.type == .birthCity {
                        max = 100
                    }

                    if max > 0 {
                        if let textStr = textField.text {
                            textField.text = (textStr.count > max ? textStr[safe: ..<max] : textStr)
                        }
                    }
                    return true
                }
                cell.textChange = {
                    [weak self] (text, isEditEnd) in
                    guard let self = self else { return }
                    if detailItem.type == .spouseName {
                        self.spouse?.subsetName = text ?? ""
                    } else if detailItem.type == .everName {
                        self.spouse?.usedName = text ??  ""
                    } else if detailItem.type == .befourMarryFirstName {
                        
                        let tt = text?.uppercased()
                        self.spouse?.surname = tt ??  ""
                        cell.textField.text = tt
                        
                    } else if detailItem.type == .birthCity {
                        if let spouse = spouse, spouse.isBirthOverSeas() { // 出生国外
                            self.spouse?.birthPlace.foreign = text ?? ""
                        } else {
                            self.spouse?.birthPlace.details = text ?? ""
                        }
                        
                    } else if detailItem.type == .occupationName {
                        self.spouse?.occupationName = text ??  ""
                    } else if detailItem.type == .hkIdentityCardNumber {
                        self.spouse?.hkIdentityCard = text
                    }
                    
                    if isEditEnd {
                        self.loadInfo()
                        if detailItem.type == .hkIdentityCardNumber {
                            if let text = text, !text.isEmpty, !text.isHKIdentityCardNumber() {
                                YHHUD.flash(message: "请输入正确的香港身份证号格式")
                                return
                            }
                        }
                        save()
                    }
                }
                return cell
            }
            
            if cellType == .selectSheet { // 点击选择列表cell
                guard let cell = tableView.dequeueReusableCell(withIdentifier: YHFormItemSelectSheetCell.cellReuseIdentifier, for: indexPath) as? YHFormItemSelectSheetCell else { return UITableViewCell() }
                cell.isMust = detailItem.isNeed
                cell.placeHolder = detailItem.placeHolder
                cell.title = detailItem.getTitle()
                cell.detail = detailItem.value
                cell.setTips(detailItem.tips, isShow: isNeedShowError && detailItem.isShowTips)

                return cell
            }
            
            if cellType == .twoChoice { // 双项选择cell
                
                guard let cell = tableView.dequeueReusableCell(withIdentifier: YHFormItemDoubleChoiceCell.cellReuseIdentifier, for: indexPath) as? YHFormItemDoubleChoiceCell else { return UITableViewCell() }
                cell.isMust = detailItem.isNeed
                cell.title = item.getTitle()

                cell.answerArr = nil
                
                if detailItem.type == .birthNation { // 出生国家
                    var select = false
                    if let value = detailItem.value {
                       select = Bool(value)!
                    }
                    let answers = [YHFormChoiceItem(title: "国内".local, isSelect: !select),
                                   YHFormChoiceItem(title: "国外".local, isSelect: select)]
                    cell.answerArr = answers
                    cell.answerBlock = {
                        [weak self] (answers, index) in
                        guard let self = self else { return }
                         let selectItem = answers[index]
                        self.view.endEditing(true)
                        self.spouse?.setBirthOverSeas(selectItem.title == "国外".local)
                        self.loadInfo()
                        save()
                    }
                } else if detailItem.type == .isHaveHkIdentityCard || detailItem.type == .isNowInHK { // 是否办理过香港身份证 是否在岗
                    var select = false
                    if let value = detailItem.value {
                       select = Bool(value)!
                    }
                    let answers = [YHFormChoiceItem(title: "是".local, isSelect: select),
                                   YHFormChoiceItem(title: "否".local, isSelect: !select)]
                    cell.answerArr = answers
                    cell.answerBlock = {
                        [weak self] (answers, index) in
                        guard let self = self else { return }
                         let selectItem = answers[index]
                        if detailItem.type == .isNowInHK {
                            self.spouse?.setNowIsInHK(selectItem.title == "是".local)
                        } else if detailItem.type == .isHaveHkIdentityCard {
                            let isHaveIdCard = selectItem.title == "是".local
                            self.spouse?.setHaveHKIdentityCard(isHaveIdCard)
                            if !isHaveIdCard {
                                self.spouse?.hkIdentityCard = ""
                            }
                        }
                        self.loadInfo()
                        save()
                    }
                }
                
                return cell
            }
            
            if cellType == .degreeDetailInfo { // 学位cell
                
                guard let cell = tableView.dequeueReusableCell(withIdentifier: YHFormItemDegreeInfoCell.cellReuseIdentifier, for: indexPath) as? YHFormItemDegreeInfoCell else { return UITableViewCell() }
                
                if let degreeArr = self.spouse?.hasDegreeJson {
                    if indexPath.row-2 < degreeArr.count {
                        let degreeInfo = degreeArr[indexPath.row-2]
                        cell.title = String(format: "%@%d", "学位信息".local, indexPath.row-1)
                       
                        // 前两行是 学历学位信息标题 和 是否拥有学位
                        cell.showDeleteBtn(indexPath.row > 2)
                        
                        // 学位
                        var degreeDesc = ""
                        if let degreeInt = Int(degreeInfo.degree), let item = YHSheetPickerView.getItem(type: .degree, index: degreeInt) {
                            degreeDesc = item.title
                        }
                        cell.degree = degreeDesc

                        // 颁发地区
                        var degreeAreaDesc = ""
                        if let areaInt = Int(degreeInfo.address), let item = YHSheetPickerView.getItem(type: .degreeLocation, index: areaInt) {
                            degreeAreaDesc = item.title
                        }
                        cell.degreePlace = degreeAreaDesc
                        
                        let isNeedShowDegreeTips = isNeedShowError && isEmptyString(degreeDesc)
                        let isNeedShowPlaceTips = isNeedShowError && isEmptyString(degreeAreaDesc)
                        cell.showTips(isShowDegreeTips: isNeedShowDegreeTips, isShowPlaceTips: isNeedShowPlaceTips)
                        
                        cell.degreeClickBlock = {
                            
                            YHSheetPickerView.show(type: .degree, selectTitle: degreeDesc) {
                                [weak self] selectItem in
                                guard let self = self else { return }
                                degreeInfo.degree = String(selectItem.index)
                                loadInfo()
                                save()
                            }
                        }
                        cell.areaClickBlock = {
                            YHSheetPickerView.show(type: .degreeLocation, selectTitle: degreeAreaDesc) {
                                [weak self] selectType in
                                guard let self = self else { return }
                                degreeInfo.address = String(selectType.index)
                                loadInfo()
                                save()
                            }
                        }
                        cell.deleteBlock = {
                            [weak self] in
                            guard let self = self else { return }
                            
                            var msg = "确定删除学位信息\(indexPath.row-1)吗"
                            YHTwoOptionAlertView.showAlertView(message: msg) { sure in
                                if !sure { return }
                                self.spouse?.hasDegreeJson.remove(at: indexPath.row-2)
                                self.loadInfo()
                                self.save()
                            }
                        }
                    }
                    
                }
                return cell
            }
        }
        return createDefaultCell(indexPath)
    }
    
    func tableView(_ tableView: UITableView, willDisplay cell: UITableViewCell, forRowAt indexPath: IndexPath) {
        
        if indexPath.section >= items.count { return  }
        let arr: [YHFormItemProtocol] = items[indexPath.section]
        if indexPath.row >= arr.count {  return }
        createCorner(cell: cell, arr: arr, indexPath: indexPath)
    }
    
    func createDefaultCell(_ indexPath: IndexPath) -> UITableViewCell {
        let cell = tableView.dequeueReusableCell(withIdentifier: "UITableViewCell", for: indexPath)
        return cell
    }
    
    func tableView(_ tableView: UITableView, heightForRowAt indexPath: IndexPath) -> CGFloat {
        
        return UITableView.automaticDimension
    }
    
    func tableView(_ tableView: UITableView, viewForFooterInSection section: Int) -> UIView? {
        
        return UIView()
    }
    
    func tableView(_ tableView: UITableView, viewForHeaderInSection section: Int) -> UIView? {
        
        return UIView()
    }
    
    private func tableView(_ tableView: UITableView, viewForHeaderInSection section: Int) -> CGFloat {
        return 14.0
    }
    
    private func tableView(_ tableView: UITableView, viewForFooterInSection section: Int) -> CGFloat {
        if section == items.count-1 {
            return 14.0
        }
        return 1.0
    }
    
    func tableView(_ tableView: UITableView, didSelectRowAt indexPath: IndexPath) {
        
        if !(0..<items.count).contains(indexPath.section) { return }
        let arr: [YHFormItemProtocol] = items[indexPath.section]
        if !(0..<arr.count).contains(indexPath.row) {  return  }
        let item = arr[indexPath.row]
        
        if item is YHFormDetailItem {
            guard let detailItem = item as? YHFormDetailItem else { return }
            
            if detailItem.type == .birthday || detailItem.type == .stayHKDate { // 出生日期/获准滞留至
                var title = ""
                if detailItem.type == .birthday {
                    title = "选择出生日期"
                } else if detailItem.type == .stayHKDate {
                    title = "选择逗留日期"
                }
                YHDatePickView.show(type: .yyyymmdd, title: title, lastIsTaday: true, currentDay: spouse?.birthday ?? "") { [weak self] dateStr in
                    guard let self = self else { return }
                    
                    if detailItem.type == .birthday {
                        let format = DateFormatter()
                        format.dateFormat = "yyyy-MM-dd"
                        if let selectDate = format.date(from: dateStr) {
                            let selectTimeInterval = selectDate.timeIntervalSince1970
                            let currentTimeInterval = Date().timeIntervalSince1970
                            // 出生日期须早于当前日期
                            if selectTimeInterval > currentTimeInterval {
                                YHHUD.flash(message: "出生日期不能晚于当前日期".local)
                                return
                            }
                        }
                        
                        self.spouse?.birthday = dateStr
                        
                    } else if detailItem.type == .stayHKDate {
                        self.spouse?.childInHk.info =  dateStr
                    }
                    loadInfo()
                    save()
                }
                
            } else if detailItem.type == .birthCity { // 出生城市
                  
//                var isBirthOverSeas = false
//                if let spouse = spouse {
//                    isBirthOverSeas = spouse.isBirthOverSeas()
//                }
//                // 出生国外时 出生城市是输入框
//                if isBirthOverSeas { return }
//
//                let vc = YHAddressViewController()
//                vc.backLocationStringController = {
//                     [weak self] (string1, string2, string3, string4) in
//                     guard let self = self else { return }
//                     print("\(string1)\n\(string2)\n\(string3)\n\(string4)")
//                    var citys:[String] = []
//                    if !isEmptyString(string2) {
//                        citys.append(string2)
//                    }
//                    if !isEmptyString(string3) {
//                        citys.append(string3)
//                    }
//                     self.spouse?.birthPlace.area = citys
//                     loadInfo()
//                     save()
//                 }
//                self.present(vc, animated: true)
 
            } else if detailItem.type == .roleInHK { // 在港身份
                
                let identity = self.spouse?.hkIdentity ?? ""
                YHSheetPickerView.show(type: .identity, selectTitle: identity) {
                    [weak self] selectItem in
                    guard let self = self else { return }
                    self.spouse?.hkIdentity = selectItem.title
                    loadInfo()
                    save()
                }
                
            } else if detailItem.type == .occupation {
                let occupation = self.spouse?.occupation ?? ""
                YHSheetPickerView.show(type: .occupation, selectTitle: occupation) {
                    [weak self] selectItem in
                    guard let self = self else { return }
                    self.spouse?.occupation = selectItem.title
                    loadInfo()
                    save()
                }
                
            } else if detailItem.type == .ownDegree {
                
                YHSheetPickerView.show(type: .ownDegree, selectTitle: self.spouse?.hasDegreeName()) {
                    [weak self] selectItem in
                    guard let self = self else { return }
                    let hasDegree = selectItem.index == 1
                    self.spouse?.setHaveDegree(hasDegree)
                    self.loadInfo()
                    save()
                }
            }
        }
    }
        
    func createCorner(cell: UITableViewCell, arr: [Any], indexPath: IndexPath) {
        // 复用时需清理
        cell.layer.mask = nil
        // 设置每块section圆角
        if indexPath.row == 0 {
            let corner = UIRectCorner(rawValue: UIRectCorner.topLeft.rawValue | UIRectCorner.topRight.rawValue)
            cell.createCorner(CGSize(width: 12.0, height: 12.0), corner)
            
        } else if indexPath.row == arr.count-1 {
            let corner = UIRectCorner(rawValue: UIRectCorner.bottomLeft.rawValue | UIRectCorner.bottomRight.rawValue)
            cell.createCorner(CGSize(width: 12.0, height: 12.0), corner)
            
        } else {
            cell.layer.mask = nil
        }
    }
    
    func save() {
        if let delegate = delegate, delegate.responds(to: #selector(YHSpouseInfoVCProtocol.saveInfoSilent)) {
            delegate.saveInfoSilent()
        }
    }
}
