//
//  YHIncomeDateTillNowCell.swift
//  galaxy
//
//  Created by alexzzw on 2024/12/24.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHIncomeDateTillNowCell: YHResignDocumentCell {

    static let cellReuseIdentifier = "YHIncomeDateTillNowCell"
    var tillNowButtonEvent: ((Bool) -> Void)?
    private var placeholder: String = ""
    
    private lazy var dotIcon: UIImageView = {
        let imageView = UIImageView(image: UIImage(named: "red_dot_6"))
        return imageView
    }()
    
    private lazy var infoTitleLabel: UILabel = {
        let label = UILabel()
        label.font = .PFSC_R(ofSize: 14)
        label.textColor = UIColor.mainTextColor
        label.text = "收入来源公司"
        return label
    }()
    
    private lazy var infoDetailLabel: UILabel = {
        let label = UILabel()
        label.font = .PFSC_M(ofSize: 14)
        label.textColor = UIColor.mainTextColor
        label.text = "请选择"
        label.numberOfLines = 0
        label.lineBreakMode = .byCharWrapping
        return label
    }()
    
    private lazy var bottomLineView: UIView = {
        let view = UIView()
        view.backgroundColor = UIColor(hexString: "#E9ECF0")
        return view
    }()
    
    private lazy var infoFailLabel: UILabel = {
        let label = UILabel()
        label.font = .PFSC_R(ofSize: 12)
        label.textColor = .failColor
        label.text = "请选择"
        return label
    }()
    
    private lazy var tillNowButton: UIButton = {
        let button = UIButton(type: .custom)
        button.iconInLeft(spacing: 6)
        button.setTitle("至今", for: .normal)
        button.titleLabel?.font = .PFSC_R(ofSize: 14)
        button.setTitleColor(.mainTextColor, for: .normal)
        button.setImage(UIImage(named: "income_date_check_btn_0"), for: .normal)
        button.setImage(UIImage(named: "income_date_check_btn_1"), for: .selected)
        button.addTarget(self, action: #selector(tillNowButtonClicked), for: .touchUpInside)
        return button
    }()
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        setupUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func setupCellInfo(title: String, detail: String?, placeholder: String = "请选择", showBottomLine: Bool = true, needShowFailButton: Bool) {
        infoTitleLabel.text = title
        self.placeholder = placeholder
        updateContentState(detail: detail, placeholder: placeholder)
        bottomLineView.isHidden = !showBottomLine
        infoFailLabel.text = placeholder
        updateFailLabel(needShowFailButton)
    }
}

extension YHIncomeDateTillNowCell {
    @objc private func tillNowButtonClicked() {
        tillNowButton.isSelected.toggle()
        tillNowButtonEvent?(tillNowButton.isSelected)
        let detail: String? = tillNowButton.isSelected ? "至今" : nil
        updateContentState(detail: detail, placeholder: self.placeholder)
    }
    
    private func updateFailLabel(_ needShowFailButton: Bool) {
        if needShowFailButton {
            infoFailLabel.isHidden = false
            
            infoFailLabel.snp.remakeConstraints { make in
                make.top.equalTo(infoTitleLabel.snp.bottom).offset(6)
                make.left.equalToSuperview().offset(18)
                make.right.lessThanOrEqualToSuperview().offset(-18)
                make.bottom.equalToSuperview().offset(-16)
            }
        } else {
            infoFailLabel.isHidden = true
        
            infoFailLabel.snp.remakeConstraints { make in
                make.left.equalToSuperview().offset(18)
                make.right.lessThanOrEqualToSuperview().offset(-18)
                make.bottom.equalToSuperview().offset(-16)
            }
        }
    }
    
    private func updateContentState(detail: String?, placeholder: String) {
        if let detail = detail, !detail.isEmpty {
            infoDetailLabel.font = .PFSC_M(ofSize: 14)
            infoDetailLabel.textColor = UIColor.mainTextColor
            infoDetailLabel.text = detail
            if detail == "至今" {
                tillNowButton.isSelected = true
                infoDetailLabel.isHidden = true
                tillNowButton.snp.remakeConstraints { make in
                    make.centerY.equalTo(infoTitleLabel)
                    make.left.equalToSuperview().offset(147)
                    make.width.equalTo(50)
                    make.height.equalTo(30)
                }
                
                infoDetailLabel.snp.remakeConstraints { make in
                    make.top.greaterThanOrEqualToSuperview().offset(16)
                    make.bottom.lessThanOrEqualToSuperview().offset(-16)
                    make.centerY.equalToSuperview()
                    make.left.equalToSuperview().offset(147)
                }
                
            } else {
                infoDetailLabel.isHidden = false
                tillNowButton.isSelected = false
                tillNowButton.snp.remakeConstraints { make in
                    make.centerY.equalTo(infoTitleLabel)
                    make.right.equalToSuperview().offset(-18)
                    make.width.equalTo(50)
                    make.height.equalTo(30)
                }
                infoDetailLabel.snp.remakeConstraints { make in
                    make.top.greaterThanOrEqualToSuperview().offset(16)
                    make.bottom.lessThanOrEqualToSuperview().offset(-16)
                    make.centerY.equalToSuperview()
                    make.left.equalToSuperview().offset(147)
                    make.right.lessThanOrEqualTo(tillNowButton.snp.left).offset(-18)
                }
            }
        } else {
            infoDetailLabel.isHidden = false
            tillNowButton.isSelected = false
            infoDetailLabel.text = placeholder
            infoDetailLabel.font = .PFSC_R(ofSize: 14)
            infoDetailLabel.textColor = UIColor(hexString: "#B9C1CC")
            tillNowButton.snp.remakeConstraints { make in
                make.centerY.equalTo(infoTitleLabel)
                make.right.equalToSuperview().offset(-18)
                make.width.equalTo(50)
                make.height.equalTo(30)
            }
            
            infoDetailLabel.snp.remakeConstraints { make in
                make.top.equalToSuperview().offset(16)
                make.bottom.equalToSuperview().offset(-16)
                make.left.equalToSuperview().offset(147)
                make.right.lessThanOrEqualTo(tillNowButton.snp.left).offset(-18)
            }
        }
    }
    
    private func setupUI() {
        updateCellCorner(.mid)
        subContainerView.addSubview(dotIcon)
        subContainerView.addSubview(infoTitleLabel)
        subContainerView.addSubview(infoDetailLabel)
        subContainerView.addSubview(bottomLineView)
        subContainerView.addSubview(infoFailLabel)
        subContainerView.addSubview(tillNowButton)
        
        dotIcon.setContentCompressionResistancePriority(.required, for: .horizontal)
        infoTitleLabel.setContentCompressionResistancePriority(.defaultHigh, for: .horizontal)
        infoDetailLabel.setContentCompressionResistancePriority(.defaultLow, for: .horizontal)
        tillNowButton.setContentCompressionResistancePriority(.required, for: .horizontal)
        
        dotIcon.snp.makeConstraints { make in
            make.centerY.equalToSuperview()
            make.left.equalToSuperview().offset(18)
            make.width.height.equalTo(6)
        }
        
        infoTitleLabel.snp.makeConstraints { make in
            make.centerY.equalToSuperview()
            make.left.equalTo(dotIcon.snp.right).offset(2)
        }
        
        tillNowButton.snp.makeConstraints { make in
            make.centerY.equalTo(infoTitleLabel)
            make.right.equalToSuperview().offset(-18)
            make.width.equalTo(50)
            make.height.equalTo(30)
        }
        
        infoDetailLabel.snp.makeConstraints { make in
            make.top.greaterThanOrEqualToSuperview().offset(16)
            make.bottom.lessThanOrEqualToSuperview().offset(-16)
            make.centerY.equalToSuperview()
            make.left.equalToSuperview().offset(147)
            make.right.lessThanOrEqualTo(tillNowButton.snp.left).offset(-18)
        }
        
        bottomLineView.snp.makeConstraints { make in
            make.bottom.equalToSuperview()
            make.left.equalToSuperview().offset(18)
            make.right.equalToSuperview().offset(-18)
            make.height.equalTo(0.5)
        }
        infoFailLabel.snp.makeConstraints { make in
            make.left.equalToSuperview().offset(18)
            make.right.lessThanOrEqualToSuperview().offset(-18)
            make.bottom.equalToSuperview().offset(-16)
        }
        infoFailLabel.isHidden = true
    }
}
