//
//  YHIncomeInfoSelectCell.swift
//  galaxy
//
//  Created by alexzzw on 2024/12/24.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHIncomeInfoSelectCell: YHResignDocumentCell {

    static let cellReuseIdentifier = "YHIncomeInfoSelectCell"
    
    private lazy var dotIcon: UIImageView = {
        let imageView = UIImageView(image: UIImage(named: "red_dot_6"))
        return imageView
    }()
    
    private lazy var infoTitleLabel: UILabel = {
        let label = UILabel()
        label.font = .PFSC_R(ofSize: 14)
        label.textColor = UIColor.mainTextColor
        label.text = "收入来源公司"
        return label
    }()
    
    private lazy var infoDetailLabel: UILabel = {
        let label = UILabel()
        label.font = .PFSC_M(ofSize: 14)
        label.textColor = UIColor.mainTextColor
        label.text = "请选择"
        label.numberOfLines = 0
        label.lineBreakMode = .byCharWrapping
        return label
    }()
    
    private lazy var bottomLineView: UIView = {
        let view = UIView()
        view.backgroundColor = UIColor(hexString: "#E9ECF0")
        return view
    }()
    
    private lazy var infoFailLabel: UILabel = {
        let label = UILabel()
        label.font = .PFSC_R(ofSize: 12)
        label.textColor = .failColor
        label.text = "请选择"
        return label
    }()
    
    private lazy var rightArrowIcon: UIImageView = {
        let imageView = UIImageView(image: UIImage(named: "form_right_arrow"))
        return imageView
    }()
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        setupUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func setupCellInfo(title: String, detail: String?, placeholder: String = "请选择", showBottomLine: Bool = true, needShowFailButton: Bool, cellType: YHResignRoundCellType = .mid) {
        infoTitleLabel.text = title
        updateContentState(detail: detail, placeholder: placeholder)
        bottomLineView.isHidden = !showBottomLine
        infoFailLabel.text = placeholder
        updateFailLabel(needShowFailButton)
        updateCellCorner(cellType)
    }
}

extension YHIncomeInfoSelectCell {
    private func updateFailLabel(_ needShowFailButton: Bool) {
        if needShowFailButton {
            infoFailLabel.isHidden = false
            
            infoFailLabel.snp.remakeConstraints { make in
                make.top.equalTo(infoTitleLabel.snp.bottom).offset(6)
                make.left.equalToSuperview().offset(18)
                make.right.lessThanOrEqualToSuperview().offset(-18)
                make.bottom.equalToSuperview().offset(-16)
            }
        } else {
            infoFailLabel.isHidden = true
            
            infoFailLabel.snp.remakeConstraints { make in
                make.left.equalToSuperview().offset(18)
                make.right.lessThanOrEqualToSuperview().offset(-18)
                make.bottom.equalToSuperview().offset(-16)
            }
        }
    }
    
    private func updateContentState(detail: String?, placeholder: String) {
        if let detail = detail, !detail.isEmpty {
            infoDetailLabel.font = .PFSC_M(ofSize: 14)
            infoDetailLabel.textColor = UIColor.mainTextColor
            infoDetailLabel.text = detail
        } else {
            infoDetailLabel.text = placeholder
            infoDetailLabel.font = .PFSC_R(ofSize: 14)
            infoDetailLabel.textColor = UIColor(hexString: "#B9C1CC")
        }
    }
    
    private func setupUI() {
        updateCellCorner(.mid)
        subContainerView.addSubview(dotIcon)
        subContainerView.addSubview(infoTitleLabel)
        subContainerView.addSubview(infoDetailLabel)
        subContainerView.addSubview(bottomLineView)
        subContainerView.addSubview(infoFailLabel)
        subContainerView.addSubview(rightArrowIcon)
        
        dotIcon.setContentCompressionResistancePriority(.required, for: .horizontal)
        infoTitleLabel.setContentCompressionResistancePriority(.defaultHigh, for: .horizontal)
        infoDetailLabel.setContentCompressionResistancePriority(.defaultLow, for: .horizontal)
        rightArrowIcon.setContentCompressionResistancePriority(.required, for: .horizontal)
        
        dotIcon.snp.makeConstraints { make in
            make.centerY.equalToSuperview()
            make.left.equalToSuperview().offset(18)
            make.width.height.equalTo(6)
        }
        
        infoTitleLabel.snp.makeConstraints { make in
            make.centerY.equalToSuperview()
            make.left.equalTo(dotIcon.snp.right).offset(2)
        }
        
        rightArrowIcon.snp.makeConstraints { make in
            make.centerY.equalTo(infoTitleLabel)
            make.right.equalToSuperview().offset(-18)
            make.width.height.equalTo(20)
        }
        
        infoDetailLabel.snp.makeConstraints { make in
            make.top.greaterThanOrEqualToSuperview().offset(16)
            make.bottom.lessThanOrEqualToSuperview().offset(-16)
            make.centerY.equalToSuperview()
            make.left.equalToSuperview().offset(147)
            make.right.lessThanOrEqualTo(rightArrowIcon.snp.left).offset(-18)
        }
        
        bottomLineView.snp.makeConstraints { make in
            make.bottom.equalToSuperview()
            make.left.equalToSuperview().offset(18)
            make.right.equalToSuperview().offset(-18)
            make.height.equalTo(0.5)
        }
        infoFailLabel.snp.makeConstraints { make in
            make.left.equalToSuperview().offset(18)
            make.right.lessThanOrEqualToSuperview().offset(-18)
            make.bottom.equalToSuperview().offset(-16)
        }
        infoFailLabel.isHidden = true
    }
}
