//
//  YHGCIncomeRecordViewModel.swift
//  galaxy
//
//  Created by alexzzw on 2024/12/25.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHGCIncomeRecordViewModel: YHBaseViewModel {
    // MARK: - 表单状态

    enum FormState {
        case viewing
        case editing
    }

    var mainModel: YHGCWorkModel = YHGCWorkModel()
    var listModel: [YHWorkItemListModel] = []
    var workId: Int = 0
    private(set) var formState: FormState = .viewing

    // 切换编辑状态
    func toggleEditingState() {
        switch formState {
        case .viewing:
            formState = .editing
        case .editing:
            formState = .viewing
        }
    }

    override init() {
        super.init()
    }

    func requestWorkList(_ orderId: Int, callBackBlock: @escaping (_ success: YHGCWorkModel?, _ error: YHErrorModel?) -> Void) {
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.WorkExperience.gclist
        let params: [String: Any] = ["order_id": orderId]

        _ = YHNetRequest.getRequest(url: strUrl, params: params) { [weak self] json, _ in
            // 1. json字符串 转 对象
            guard let self = self else { return }
            if json.code == 200 {
                guard let dic = json.data?.peel as? [String: Any], let result = YHGCWorkModel.deserialize(from: dic) else {
                    callBackBlock(nil, nil)
                    return
                }
                self.mainModel = result
                self.listModel = result.list ?? []
                callBackBlock(self.mainModel, nil)
            } else {
                let error: YHErrorModel = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg)
                callBackBlock(nil, error)
            }
        } failBlock: { err in
            callBackBlock(nil, err)
        }
    }

    func requestDeleteWorkExperience(_ id: Int, _ orderId: Int, callBackBlock: @escaping (_ success: Bool, _ error: YHErrorModel?) -> Void) {
        let params: [String: Any] = ["id": id, "order_id": orderId]
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.WorkExperience.del
        _ = YHNetRequest.postRequest(url: strUrl, params: params) { json, _ in
            // 1. json字符串 转 对象
            if json.code == 200 {
                callBackBlock(true, nil)
            } else {
                let error: YHErrorModel = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg)
                callBackBlock(false, error)
            }
        } failBlock: { err in
            callBackBlock(false, err)
        }
    }

    func requestWorkTimeRemarkWorkExperience(_ orderId: Int, _ isSubmit: Bool = true, callBackBlock: @escaping (_ success: Bool, _ error: YHErrorModel?) -> Void) {
        let params: [String: Any] = ["order_id": orderId,
                                     "has_company_consent": mainModel.has_company_consent,
                                     "consent_work_id": mainModel.consent_work_id,
                                     "has_center_consent": mainModel.has_center_consent,
                                     "why_work_time_overlap": mainModel.why_work_time_overlap,
                                     "has_work_experience": mainModel.has_work_experience,
                                     "is_submit": isSubmit]
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.WorkExperience.saveAll
        _ = YHNetRequest.postRequest(url: strUrl, params: params) { json, _ in
            // 1. json字符串 转 对象
            if json.code == 200 {
                callBackBlock(true, nil)
            } else {
                let error: YHErrorModel = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg)
                callBackBlock(false, error)
            }
        } failBlock: { err in
            callBackBlock(false, err)
        }
    }
}
