//
//  YHPersonInfoControllerHoldViewController.swift
//  galaxy
//
//  Created by davidhuangA on 2024/1/29.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import JXSegmentedView

class YHGCPreviewControllerHoldViewController: UIViewController {
    
    var productType: Int = 0 // 0-优才  1-高才A 2-高才B 3-高才C

    var canScroll: Bool = false {
        didSet {
            for vc in arrItemVCs {
                vc.vcCanScroll = canScroll
            }
        }
    }
    
    var myDefaultNavItemIndex: Int = 0 {
        didSet {
            self.segmentedView.selectItemAt(index: self.myDefaultNavItemIndex)
        }
    }
    
    lazy var arrItemTitles: [String] = {
        if productType == 1 { // 高才A
            return ["主申请人信息", "家庭成员信息", "收入记录/工作经验", "基本资料"]
        }
        return ["主申请人信息", "家庭成员信息", "学历", "工作经验", "基本资料"]
    }()
    
    var arrItemVCs: [YHPreviewBaseViewController] = []
    var segmentedView: JXSegmentedView = JXSegmentedView(frame: CGRect(x: 0, y: 0, width: KScreenWidth, height: 55))
    lazy var segmentedDataSource: JXSegmentedBaseDataSource = {
        let dataSource = JXSegmentedTitleDataSource()
        dataSource.titles = arrItemTitles
        
        dataSource.titleNormalFont = UIFont.PFSC_R(ofSize: 14)
        dataSource.titleNormalColor = UIColor.init(hex: 0x435163)
        
        dataSource.titleSelectedFont = UIFont.PFSC_M(ofSize: 14)
        dataSource.titleSelectedColor = UIColor.brandMainColor
        
        dataSource.isItemSpacingAverageEnabled = false
        dataSource.itemWidth = JXSegmentedViewAutomaticDimension
        dataSource.itemSpacing = 21.5
        return dataSource
    }()
    
    // 分类title 所对应的VC
    lazy var listContainerView: JXSegmentedListContainerView! = {
        return JXSegmentedListContainerView(dataSource: self, type: .collectionView)
    }()

    override func viewDidLoad() {
        super.viewDidLoad()
        
        if productType == 1 { // 高才A
            
            // 主申请人
            let vc1 = YHGCPreviewMainApplicantInfoViewController()
            arrItemVCs.append(vc1)
            // 家庭成员信息
            let vc2 = YHGCPreviewFamilyMemberViewController()
            arrItemVCs.append(vc2)
            // 收入记录/工作经验
            let orderID = UserDefaults.standard.value(forKey: "orderIdForPreview") as? Int ?? 0
            let vc3 = YHGCPreviewIncomeRecordViewController(orderId: orderID, pageType: .pageA)
            arrItemVCs.append(vc3)
            // 基本资料
            let vc4 = YHGCPreviewBasiceInformationViewController()
            arrItemVCs.append(vc4)
            
        } else { // 高才BC
            
            // 主申请人
            let vc1 = YHGCPreviewMainApplicantInfoViewController()
            arrItemVCs.append(vc1)
            // 家庭成员信息
            let vc2 = YHGCPreviewFamilyMemberViewController()
            arrItemVCs.append(vc2)
            // 学历/专业资格
            let vc3 = YHGCPreviewAcademicAndProfessionalQualificationViewController()
            arrItemVCs.append(vc3)
            // 工作经验
            let orderID = UserDefaults.standard.value(forKey: "orderIdForPreview") as? Int ?? 0
            let vc4 = YHGCPreviewIncomeRecordViewController(orderId: orderID, pageType: .pageBC)
            arrItemVCs.append(vc4)
            // 基本资料
            let vc5 = YHGCPreviewBasiceInformationViewController()
            arrItemVCs.append(vc5)
            
        }
        
        // segmentedViewDataSource一定要通过属性强持有！！！！！！！！！
        segmentedView.dataSource = segmentedDataSource
        segmentedView.delegate = self
        view.addSubview(segmentedView)

        segmentedView.listContainer = listContainerView
        view.addSubview(listContainerView)
        
        // 分类Title
        segmentedView.dataSource = segmentedDataSource
        segmentedView.delegate = self
        
        // 配置指示器
        let indicator = JXSegmentedIndicatorLineView()
        indicator.indicatorWidth = 16
        indicator.indicatorHeight = 2
        indicator.indicatorCornerRadius = 0.0
        indicator.verticalOffset = 4
        indicator.indicatorColor = UIColor.brandMainColor
        segmentedView.indicators = [indicator]
        
        segmentedView.defaultSelectedIndex = self.myDefaultNavItemIndex
    }
    
    override func viewDidLayoutSubviews() {
        super.viewDidLayoutSubviews()

        segmentedView.frame = CGRect(x: 0, y: 0, width: view.bounds.size.width, height: 55)
        listContainerView.frame = CGRect(x: 0, y: 55, width: view.bounds.size.width, height: view.bounds.size.height - 55)
        segmentedView.backgroundColor = .white
    }
}

extension YHGCPreviewControllerHoldViewController: JXSegmentedViewDelegate {
    func segmentedView(_ segmentedView: JXSegmentedView, didSelectedItemAt index: Int) {
        NotificationCenter.default.post(name: Notification.Name(rawValue: "scrollViewDidEndDragging0"), object: nil)
    }

    /// 正在滚动中的回调
    ///
    /// - Parameters:
    ///   - segmentedView: JXSegmentedView
    ///   - leftIndex: 正在滚动中，相对位置处于左边的index
    ///   - rightIndex: 正在滚动中，相对位置处于右边的index
    ///   - percent: 从左往右计算的百分比
    func segmentedView(_ segmentedView: JXSegmentedView, scrollingFrom leftIndex: Int, to rightIndex: Int, percent: CGFloat) {
        NotificationCenter.default.post(name: Notification.Name(rawValue: "scrollViewWillBeginDragging0"), object: nil)
    }
}

extension YHGCPreviewControllerHoldViewController: JXSegmentedListContainerViewDataSource {
    func numberOfLists(in listContainerView: JXSegmentedListContainerView) -> Int {
        if let titleDataSource = segmentedView.dataSource as? JXSegmentedBaseDataSource {
            return titleDataSource.dataSource.count
        }
        return 0
    }

    func listContainerView(_ listContainerView: JXSegmentedListContainerView, initListAt index: Int) -> JXSegmentedListContainerViewListDelegate {
        return arrItemVCs[index] as JXSegmentedListContainerViewListDelegate
    }
}
