//
//  YHMainApplicantInfoViewController.swift
//  galaxy
//
//  Created by davidhuangA on 2024/1/29.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
/*
 *主申请人信息 预览
 */
class YHGCPreviewMainApplicantInfoViewController: YHPreviewBaseViewController {
    private let previewVM: YHGCPreviewViewModel =  YHGCPreviewViewModel()
    override func viewDidLoad() {
        super.viewDidLoad()
        setupUI()
        loadData()
    }
    
    override func viewWillAppear(_ animated: Bool) {
        super.viewWillAppear(animated)
        homeTableView.reloadData()
    }
}

private extension YHGCPreviewMainApplicantInfoViewController {
    func setupUI() {
        self.homeTableView.register(YHPreviewInfoCell.self, forCellReuseIdentifier: YHPreviewInfoCell.cellReuseIdentifier)
        self.homeTableView.reloadData()
    }
    
    func loadData() {
        if let orderID = UserDefaults.standard.value(forKey: "orderIdForPreview") {
            previewVM.getPreviewForMainApplicationInfo(params: ["order_id": orderID]) { success, _ in
                if success == true {
                    
                } else {
                    
                }
                self.homeTableView.reloadData()
            }
        } else {
            printLog("error : orderID 为空")
        }
    }
}

// MARK: - UITableViewDelegate 和 UITableViewDataSource
extension YHGCPreviewMainApplicantInfoViewController {
    override func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        return previewVM.arrDataForMainApplicationInfo.count
    }
    
    override func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        let cell = tableView.dequeueReusableCell(withClass: YHPreviewInfoCell.self)
        cell.selectionStyle = .none
        cell.model = previewVM.arrDataForMainApplicationInfo[indexPath.row]
        return cell
    }
}
