//
//  YHGCPreviewIncomeTypeCell.swift
//  galaxy
//
//  Created by alexzzw on 2024/12/28.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHGCPreviewIncomeTypeCell: YHResignDocumentCell {
    static let cellReuseIdentifier = "YHGCPreviewIncomeTypeCell"
    private var lastDocuments: [String] = []

    private lazy var infoTitleLabel: UILabel = {
        let label = UILabel()
        label.font = .PFSC_R(ofSize: 14)
        label.textColor = UIColor(hexString: "#8993A2")
        return label
    }()
    
    private lazy var infoSubtitleLabel: UILabel = {
        let label = UILabel(text: "--")
        label.isHidden = true
        label.textColor = UIColor.mainTextColor
        label.font = UIFont.PFSC_R(ofSize: 14)
        label.textAlignment = .right
        return label
    }()
    
    private lazy var containerView: YHBaseDynamicCornerRadiusView = {
        let view = YHBaseDynamicCornerRadiusView(cornerRadius: 3, corner: .allCorners)
        view.backgroundColor = .contentBkgColor
        return view
    }()
    
    private lazy var infoContentLabel: UILabel = {
        let label = UILabel()
        label.font = .PFSC_R(ofSize: 12)
        label.textColor = UIColor(hexString: "#6D788A")
        label.numberOfLines = 0
        label.lineBreakMode = .byCharWrapping
        return label
    }()
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        setupUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func setupCellInfo(title: String, documents: [String], subtitle: String? = nil, cellType: YHResignRoundCellType = .mid) {
        infoTitleLabel.text = title
        if let subtitle = subtitle, !subtitle.isEmpty {
            infoSubtitleLabel.text = subtitle
            infoSubtitleLabel.isHidden = false
        } else {
            infoSubtitleLabel.text = nil
            infoSubtitleLabel.isHidden = false
        }
        let content = documents.reduce("") { partialResult, item in
            partialResult.count > 0 ? partialResult + "\n" + item : partialResult + item
        }
        infoContentLabel.text = content
        updateCellCorner(cellType)
        if cellType == .bottom || cellType == .single {
            containerView.snp.remakeConstraints { make in
                make.left.equalTo(infoTitleLabel)
                make.top.equalTo(infoTitleLabel.snp.bottom).offset(8)
                make.right.equalToSuperview().offset(-18)
                make.bottom.equalToSuperview().offset(-16)
            }
        } else {
            containerView.snp.remakeConstraints { make in
                make.left.equalTo(infoTitleLabel)
                make.top.equalTo(infoTitleLabel.snp.bottom).offset(8)
                make.right.equalToSuperview().offset(-18)
                make.bottom.equalToSuperview().offset(-8)
            }
        }
    }
    
    private func setupUI() {
        updateCellCorner(.mid)
        subContainerView.addSubview(infoTitleLabel)
        subContainerView.addSubview(containerView)
        subContainerView.addSubview(infoSubtitleLabel)
        containerView.addSubview(infoContentLabel)
        infoTitleLabel.snp.makeConstraints { make in
            make.top.equalToSuperview().offset(8)
            make.left.equalToSuperview().offset(18)
        }
        
        infoSubtitleLabel.snp.makeConstraints { make in
            make.left.greaterThanOrEqualTo(infoTitleLabel.snp.right).offset(10)
            make.centerY.equalTo(infoTitleLabel)
            make.right.equalToSuperview().offset(-18)
        }
        
        containerView.snp.makeConstraints { make in
            make.left.equalTo(infoTitleLabel)
            make.top.equalTo(infoTitleLabel.snp.bottom).offset(8)
            make.right.equalToSuperview().offset(-18)
            make.bottom.equalToSuperview().offset(-8)
        }
        infoContentLabel.snp.makeConstraints { make in
            make.left.equalToSuperview().offset(12)
            make.top.equalToSuperview().offset(10)
            make.right.equalToSuperview().offset(-12)
            make.bottom.equalToSuperview().offset(-10)
        }
    }
}
