//
//  YHGCPreviewViewModel.swift
//  galaxy
//
//  Created by Dufet on 2024/12/24.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHGCPreviewViewModel: YHBaseViewModel {
    // 工作经验
    var workExpInfoPreviewModel: YHWorkExpInfoPreviewModel?
    var arrDataForWorkExpInfo: [YHPreviewInfoSessionModel] = []
    
    // 工作经验 2024新政
    var workExpInfoPreviewModel2: YHWorkExpInfoPreviewNewModel?
    var arrDataForWorkExpInfoNew: [YHPreviewInfoSessionModel] = []
    
    // 学历/专业资格
    var academicInfoPreviewModel: YHAcademicPreviewModel?
    var arrDataForAcademicInfo: [YHPreviewInfoSessionModel] = []
    
    // 家庭成员信息 预览
    var familyInfoPreviewModel: YHFamilyMemberGroupInfo?
    var arrDataForFamilyInfo: [YHPreviewInfoSessionModel] = [] // 用于展示
    var arrDataForParents: [YHPreviewInfoSessionModel] = []// 父亲
    var arrDataForSpouse: [YHPreviewInfoSessionModel] = []// 配偶
    var arrDataForChildren: [YHPreviewInfoSessionModel] = []// 子女
    var arrDataForBrother: [YHPreviewInfoSessionModel] = []// 兄弟姐妹
    
    // 主申请人信息 预览
    var mainApplicationInfoPreviewModel: YHMainInfoPreviewModel?
    var arrDataForMainApplicationInfo: [YHPreviewInfoSessionModel] = []
    
    // 其他信息 预览
    private var otherInfoPreviewModel: YHPreviewForOtherInfoModel?
    var arrDataForOtherInfo: [YHPreviewInfoSessionModel] = []
    
    // 基本资料 预览
    private var basiceInfoPreviewModel: YHGCBasicInfoFillModel?
    var arrDataForBasicInfo: [YHPreviewInfoSessionModel] = []
}

extension YHGCPreviewViewModel {
    // 工作经验 预览  2024 优才新政
    func getPreviewForWorkExpNewInfo(params: [String: Any], callBackBlock: @escaping (_ success: Bool, _ error: YHErrorModel?) -> Void) {
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.Preview.previewWorkExpInfoNewApi
        _ = YHNetRequest.getRequest(url: strUrl, params: params) {[weak self] json, _ in
            guard let self = self else { return }
            printLog("model 是 ==> \(json)")
            
            if json.code == 200 {
                guard let dic = json.data?.peel as? [String: Any], let resultModel = YHWorkExpInfoPreviewNewModel.deserialize(from: dic) else {
                    let error = YHErrorModel(errorCode: YHErrorCode.dictParseError.rawValue, errorMsg: YHErrorCode.dictParseError.description())
                    callBackBlock(false, error)
                    return
                }
                
                workExpInfoPreviewModel2 = resultModel
                installDataForWorkExp_NewInfo()
                callBackBlock(true, nil)
            } else {
                let error = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg)
                callBackBlock(false, error)
            }
        } failBlock: { err in
            callBackBlock(false, err)
        }
    }
    
    // 高才工作经验 预览
    func getPreviewForGCWorkExpInfo(params: [String: Any], callBackBlock: @escaping (_ success: Bool, _ error: YHErrorModel?) -> Void) {
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.Preview.previewWorkExpInfoApi
        _ = YHNetRequest.getRequest(url: strUrl, params: params) {[weak self] json, _ in
            guard let self = self else { return }
            printLog("model 是 ==> \(json)")
            
            if json.code == 200 {
                guard let dic = json.data?.peel as? [String: Any], let resultModel = YHWorkExpInfoPreviewModel.deserialize(from: dic) else {
                    let error = YHErrorModel(errorCode: YHErrorCode.dictParseError.rawValue, errorMsg: YHErrorCode.dictParseError.description())
                    callBackBlock(false, error)
                    return
                }
                self.workExpInfoPreviewModel = resultModel
                callBackBlock(true, nil)
            } else {
                let error = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg)
                callBackBlock(false, error)
            }
        } failBlock: { err in
            callBackBlock(false, err)
        }
    }
    
    // 工作经验 预览
    func getPreviewForWorkExpInfo(params: [String: Any], callBackBlock: @escaping (_ success: Bool, _ error: YHErrorModel?) -> Void) {
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.Preview.previewWorkExpInfoApi
        _ = YHNetRequest.getRequest(url: strUrl, params: params) {[weak self] json, _ in
            guard let self = self else { return }
            printLog("model 是 ==> \(json)")
            
            if json.code == 200 {
                guard let dic = json.data?.peel as? [String: Any], let resultModel = YHWorkExpInfoPreviewModel.deserialize(from: dic) else {
                    let error = YHErrorModel(errorCode: YHErrorCode.dictParseError.rawValue, errorMsg: YHErrorCode.dictParseError.description())
                    callBackBlock(false, error)
                    return
                }
                workExpInfoPreviewModel = resultModel
                installDataForWorkExpInfo()
                callBackBlock(true, nil)
            } else {
                let error = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg)
                callBackBlock(false, error)
            }
        } failBlock: { err in
            callBackBlock(false, err)
        }
    }
    
    // 获取学历/专业 预览数据
    func getPreviewForAcademicInfo(params: [String: Any], callBackBlock: @escaping (_ success: Bool, _ error: YHErrorModel?) -> Void) {
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.Preview.previewAcademicAndProfessionalQualificationInfoApi
        _ = YHNetRequest.getRequest(url: strUrl, params: params) {[weak self] json, _ in
            guard let self = self else { return }
            printLog("model 是 ==> \(json)")
            
            if json.code == 200 {
                guard let dic = json.data?.peel as? [String: Any], let resultModel = YHAcademicPreviewModel.deserialize(from: dic) else {
                    let error = YHErrorModel(errorCode: YHErrorCode.dictParseError.rawValue, errorMsg: YHErrorCode.dictParseError.description())
                    callBackBlock(false, error)
                    return
                }
                academicInfoPreviewModel = resultModel
                installDataForAcademicInfo()
                callBackBlock(true, nil)
            } else {
                let error = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg)
                callBackBlock(false, error)
            }
        } failBlock: { err in
            callBackBlock(false, err)
        }
    }
    
    // 获取家庭成员 预览数据
    func getPreviewForFamilyInfo(params: [String: Any], callBackBlock: @escaping (_ success: Bool, _ error: YHErrorModel?) -> Void) {
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.Preview.previewFamilyInfoApi
        _ = YHNetRequest.getRequest(url: strUrl, params: params) {[weak self] json, _ in
            YHHUD.hide()
            
            guard let self = self else { return }
            printLog("model 是 ==> \(json)")
            
            if json.code == 200 {
                guard let dic = json.data?.peel as? [String: Any], let resultModel = YHFamilyMemberGroupInfo.deserialize(from: dic) else {
                    let error = YHErrorModel(errorCode: YHErrorCode.dictParseError.rawValue, errorMsg: YHErrorCode.dictParseError.description())
                    callBackBlock(false, error)
                    return
                }
                familyInfoPreviewModel = resultModel
                installDataForFamilyInfo()
                callBackBlock(true, nil)
            } else {
                let error = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg)
                callBackBlock(false, error)
            }
        } failBlock: { err in
            callBackBlock(false, err)
        }
    }
    
    // 获取主申请人 预览数据
    func getPreviewForMainApplicationInfo( params: [String: Any], callBackBlock: @escaping (_ success: Bool, _ error: YHErrorModel?) -> Void) {
        
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.Preview.previewMainApplicationInfoApi
        _ = YHNetRequest.getRequest(url: strUrl, params: params) { [weak self] json, _ in
            // 1. json字符串 转 对象
            guard let self = self else { return }
            
            arrDataForMainApplicationInfo.removeAll()
            if json.code == 200 {
                guard let dic = json.data?.peel as? [String: Any], let result = YHMainInfoPreviewModel.deserialize(from: dic) else {
                    callBackBlock(false, nil)
                    return
                }
                self.mainApplicationInfoPreviewModel = result
                installDataForMainApplicationInfo()
                callBackBlock(true, nil)
            } else {
                let error: YHErrorModel = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg)
                callBackBlock(false, error)
            }
        } failBlock: { err in
            callBackBlock(false, err)
        }
    }
    
    // 获取基本资料预览 数据
    func getPreviewForBasicInfo( params: [String: Any], callBackBlock: @escaping (_ success: Bool, _ error: YHErrorModel?) -> Void) {
        
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.GCBasics.basicInfoApi

        _ = YHNetRequest.getRequest(url: strUrl, params: params) { [weak self] json, _ in
            // 1. json字符串 转 对象
            guard let self = self else { return }
            printLog("model 是 ==> \(json)")

            if json.code == 200 {
                guard let dic = json.data?.peel as? [String: Any], let resultModel = YHGCBasicInfoFillModel.deserialize(from: dic) else {
                    callBackBlock(false, nil)
                    return
                }

                self.basiceInfoPreviewModel = resultModel
                self.installDataForBasicInfo()
                // 根据返回值 组装 真实的数据
                callBackBlock(true, nil)

            } else {
                let error: YHErrorModel = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg)
                callBackBlock(false, error)
            }
        } failBlock: { err in
            callBackBlock(false, err)
        }
    }
    
    // 获取其他信息预览 数据
    func getPreviewForOtherInfo( params: [String: Any], callBackBlock: @escaping (_ success: Bool, _ error: YHErrorModel?) -> Void) {
        
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.Preview.previewOtherInfoApi
        _ = YHNetRequest.getRequest(url: strUrl, params: params) { [weak self] json, _ in
            // 1. json字符串 转 对象
            guard let self = self else { return }
            
            if json.code == 200 {
                guard let dic = json.data?.peel as? [String: Any], let resultModel = YHPreviewForOtherInfoModel.deserialize(from: dic) else {
                    callBackBlock(false, nil)
                    return
                }
                self.otherInfoPreviewModel = resultModel
                installDataForOtherInfo()
                // 根据返回值 组装 真实的数据
                callBackBlock(true, nil)
                
            } else {
                let err: YHErrorModel = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg)
                callBackBlock(false, err)
            }
        } failBlock: { err in
            callBackBlock(false, err)
        }
    }
    
}
private extension YHGCPreviewViewModel {
    // 组装 工作经验 数据  优才新政
    func installDataForWorkExp_NewInfo() {
        guard let model0 = workExpInfoPreviewModel2 else { return}
        arrDataForWorkExpInfoNew.removeAll()
        if let list = model0.list, !list.isEmpty {
            
            for(index, model) in list.enumerated() {
                var arr1: [YHPreviewQuestionAndAnswerModel] = []
                do {
                    // 1.基本信息
                    let tmp1 = YHPreviewQuestionAndAnswerModel(question: "用人单位：", answer: model.company_name)
                    let tmp2 = YHPreviewQuestionAndAnswerModel(question: "公司是否为上市公司：", answer: model.is_ipo_company ? "是" : "否")
                    arr1.append(contentsOf: [tmp1, tmp2])
                    if model.is_ipo_company {
                        let tmp2 = YHPreviewQuestionAndAnswerModel(question: "您目前是否拥有此公司10%以上股权：", answer: model.has_ipo_company_equity ? "是" : "否")
                        arr1.append(tmp2)
                        
                        if model.has_ipo_company_equity {
                            let tmp2 = YHPreviewQuestionAndAnswerModel(question: "公司全年盈利达港币 500 万元或以上（或等值外币）:", answer: model.has_ipo_sales_reached ? "是" : "否")
                            arr1.append(tmp2)
                            
                            if model.has_ipo_sales_reached {
                                let tmp2 = YHPreviewQuestionAndAnswerModel(question: "您的公司所在地：", answer: model.company_location.defaultStringIfEmpty())
                                arr1.append(tmp2)
                            }
                            
                        }
                       
                    } else {
                        let tmp2 = YHPreviewQuestionAndAnswerModel(question: "您是否拥有此公司所有权(50%以上股权)：", answer: model.has_company_equity ? "是" : "否")
                        arr1.append(tmp2)
                        
                        if model.has_company_equity {
                            let tmp2 = YHPreviewQuestionAndAnswerModel(question: "您公司营业收入是否在500W港币或以上：", answer: model.has_sales_reached ? "是" : "否")
                            arr1.append(tmp2)
                        }
                        
                        if model.has_sales_reached {
                            let tmp2 = YHPreviewQuestionAndAnswerModel(question: "您的公司所在地：", answer: model.company_location.defaultStringIfEmpty())
                            arr1.append(tmp2)
                            
                        }
                    }
                    
                    let tmp7 = YHPreviewQuestionAndAnswerModel(question: "入职年月：", answer: model.enter_time)
                    let tmp8 = YHPreviewQuestionAndAnswerModel(question: "离职年月：", answer: model.leave_time)
                    let tmp9 = YHPreviewQuestionAndAnswerModel(question: "工作证明文件：", answer: model.work_certificate)
                    
                    let tempppp0 = YHConstantArrayData.getShowNameBy(indexStr: String(model.professional_level), type: .level)
                    
                    let tmp10 = YHPreviewQuestionAndAnswerModel(question: "职位水平类别：", answer: tempppp0)
                    arr1.append(contentsOf: [tmp7, tmp8, tmp9, tmp10])
                }
                
                let dataModel1 = YHWorkExpDataModel(title: "", data: arr1, uiType: 1)
                
                // 总体输出的 数组arr
                var arrO: [YHWorkExpDataModel]  = [dataModel1]
                
                //
                if !model.position_list.isEmpty {
                    
                    for (index, item) in model.position_list.enumerated() {
                        var arr: [YHPreviewQuestionAndAnswerModel] = []
                        
                        let tmp1 = YHPreviewQuestionAndAnswerModel(question: "职位名称：", answer: item.position_name.defaultStringIfEmpty())
                        let tmp2 = YHPreviewQuestionAndAnswerModel(question: "职责性质：", answer: item.wduty.defaultStringIfEmpty())
                        let tmp3 = YHPreviewQuestionAndAnswerModel(question: "开始就职年月：", answer: item.entry_time.defaultStringIfEmpty())
                        let tmp4 = YHPreviewQuestionAndAnswerModel(question: "结束就职年月：", answer: item.departure_time.defaultStringIfEmpty())
                        let ttt = item.experience_scope + (item.experience_sub_scope.isEmpty ? "" : ("-" + item.experience_sub_scope))
                        let tmp5 = YHPreviewQuestionAndAnswerModel(question: "经验领域：", answer: ttt)
                        let tmp6 = YHPreviewQuestionAndAnswerModel(question: "相关工作是否属国际工作经验：", answer: item.is_international_work_experience ? "是" : "否")
                        let place = item.work_country + "-" + item.work_city
                        let tmp7 = YHPreviewQuestionAndAnswerModel(question: "工作地点：", answer: place)
                        arr.append(contentsOf: [tmp1, tmp2, tmp3, tmp4, tmp5, tmp6, tmp7])
                        let posionName = "职位信息" + String(index + 1)
                        let dataModel = YHWorkExpDataModel(title: posionName, data: arr, uiType: 1)
                        arrO.append(dataModel)
                    }
                }
                
                do {
                    
                    var arr: [YHPreviewQuestionAndAnswerModel] = []
                    let tmp8 = YHPreviewQuestionAndAnswerModel(question: "工作职责：", answer: model.work_duty.defaultStringIfEmpty())
                    let tmp9 = YHPreviewQuestionAndAnswerModel(question: "工作亮点：", answer: model.work_highlights.defaultStringIfEmpty())
                    
                    arr.append(tmp8)
                    arr.append(tmp9)
                    
                    let dataModel = YHWorkExpDataModel(title: "", data: arr, uiType: 2)
                    arrO.append(dataModel)
                }
                
                do {
                    // 简历/工作总结：
                    if !model.attachment_list.isEmpty {
                        var arrT: [Any] = []
                        for (_, item) in model.attachment_list.enumerated() {
                            arrT.append(item)
                        }
                        let dataModel = YHWorkExpDataModel(title: "简历/工作总结：", data: arrT, uiType: 3)
                        arrO.append(dataModel)
                    }
                }
                
                let addationIndex = String(index + 1)
                let mmmm = YHPreviewInfoSessionModel(cellType: .workExp, cellTitle: "主申请人工作经历" + addationIndex, cellData4: arrO)
                arrDataForWorkExpInfoNew.append(mmmm)
            }
        }
        
        if !model0.why_work_time_empty.isEmpty || !model0.why_work_time_overlap.isEmpty {
            var arr: [YHPreviewQuestionAndAnswerModel] = []
            if !model0.why_work_time_overlap.isEmpty {
                let tmp8 = YHPreviewQuestionAndAnswerModel(question: "工作时间重叠原因：", answer: model0.why_work_time_overlap.defaultStringIfEmpty())
                arr.append(tmp8)
            }
            
            if !model0.why_work_time_empty.isEmpty {
                let tmp8 = YHPreviewQuestionAndAnswerModel(question: "工作时间空窗原因：", answer: model0.why_work_time_empty.defaultStringIfEmpty())
                arr.append(tmp8)
            }
            let dataModel = YHWorkExpDataModel(title: "", data: arr, uiType: 4)
            let arrO: [YHWorkExpDataModel]  = [dataModel]
            
            let mmmm = YHPreviewInfoSessionModel(cellType: .workExp, cellTitle: "工作时间说明", cellData4: arrO)
            arrDataForWorkExpInfoNew.append(mmmm)
        }
    }
    
    // 组装 工作经验 数据
    func installDataForWorkExpInfo() {
        guard let model0 = workExpInfoPreviewModel else { return}
        arrDataForWorkExpInfo.removeAll()
        if let list = model0.list, list.isEmpty == false {
            
            for(index, model) in list.enumerated() {
                var arr1: [YHPreviewQuestionAndAnswerModel] = []
                do {
                    // 1.基本信息
                    let tmp1 = YHPreviewQuestionAndAnswerModel(question: "用人单位：", answer: model.company_name)
                    let tmp2 = YHPreviewQuestionAndAnswerModel(question: "用人单位性质：", answer: model.industry)
                    let tmp3 = YHPreviewQuestionAndAnswerModel(question: "用人单位介绍：", answer: model.company_introduce.defaultStringIfEmpty())
                    let tmp4 = YHPreviewQuestionAndAnswerModel(question: "用人单位官网：", answer: model.company_website.defaultStringIfEmpty())
                    var title = "-"
                    if let item = model.location {
                        if item.country.contains("中国") {
                            title = "国内 "
                            if item.area.count > 1 {
                                title = title + item.area[0] + "/" + item.area[1]
                            }
                        } else {
                            title = "国外 " + item.country + "-" + item.foreign
                        }
                    }
                    
                    let tmp5 = YHPreviewQuestionAndAnswerModel(question: "工作地点：", answer: title)
                    let tmp6 = YHPreviewQuestionAndAnswerModel(question: "职位：", answer: model.position)
                    let tmp7 = YHPreviewQuestionAndAnswerModel(question: "入职年月：", answer: model.entry_time)
                    let tmp8 = YHPreviewQuestionAndAnswerModel(question: "离职年月：", answer: model.departure_time)
                    let tmp9 = YHPreviewQuestionAndAnswerModel(question: "工作证明文件：", answer: model.work_certificate)
                    let tmp10 = YHPreviewQuestionAndAnswerModel(question: "职责性质：", answer: model.duty)
                    title = model.international_work_experience == 0 ? "否" : "是"
                    let tmp11 = YHPreviewQuestionAndAnswerModel(question: "相关工作是否属国际工作经验：", answer: title)
                    let tmp12 = YHPreviewQuestionAndAnswerModel(question: "企业人数规模：", answer: String(model.company_member_total))
                    
                    let tempppp = YHConstantArrayData.getShowNameBy(indexStr: String(model.administrative_level), type: .structure)
                    let tmp13 = YHPreviewQuestionAndAnswerModel(question: "行政架构层级：", answer: tempppp)
                    let tmp14 = YHPreviewQuestionAndAnswerModel(question: "下属管理人数：", answer: String(model.company_manage_total))
                    
                    var ttt = ""
                    if model.turnover == "0" {
                        ttt = "0"
                    } else {
                        ttt = String(model.turnover).defaultStringIfEmpty()
                    }
                    let tmp15 = YHPreviewQuestionAndAnswerModel(question: "公司营业额/港元(近一年)：", answer: ttt)
                    
                    let tempppp0 = YHConstantArrayData.getShowNameBy(indexStr: String(model.professional_level), type: .level)
                    let tmp16 = YHPreviewQuestionAndAnswerModel(question: "职业水平类别：", answer: tempppp0)
                    arr1.append(contentsOf: [tmp1, tmp2, tmp3, tmp4, tmp5, tmp6, tmp7, tmp8, tmp9, tmp10, tmp11, tmp12, tmp13, tmp14, tmp15, tmp16])
                }
                
                let dataModel1 = YHWorkExpDataModel(title: "", data: arr1)
                
                var arr2: [YHPreviewQuestionAndAnswerModel] = []
                do {
                    // 2.
                    let tmp1 = YHPreviewQuestionAndAnswerModel(question: "公司业务性质/范畴/所属行业：", answer: model.business_nature.defaultStringIfEmpty())
                    let tmp2 = YHPreviewQuestionAndAnswerModel(question: "工作职责：", answer: model.wduty)
                    let tmp3 = YHPreviewQuestionAndAnswerModel(question: "工作亮点：", answer: model.highlights)
                    
                    arr2.append(contentsOf: [tmp1, tmp2, tmp3])
                }
                let dataModel2 = YHWorkExpDataModel(title: "", data: arr2)
                
                var arr3: [Any] = []
                do {
                    // 3.项目介绍
                    if let items = model.projects, items.isEmpty == false {
                        for(index, item) in items.enumerated() {
                            let tmp1 = YHPreviewQuestionAndAnswerModel(question: "项目名称", answer: item.project_name)
                            let title  = item.project_start_time + "-" + item.project_end_time
                            let tmp2 = YHPreviewQuestionAndAnswerModel(question: "项目时间", answer: title)
                            let tmp3 = YHPreviewQuestionAndAnswerModel(question: "项目业绩/亮点", answer: item.project_highlights)
                            let arrT: [YHPreviewQuestionAndAnswerModel] = [tmp1, tmp2, tmp3]
                            
                            let addationIndex = list.count > 1 ? String(index + 1) : ""
                            let dataModelTemp = YHWorkExpDataModel(title: "项目介绍" + addationIndex, data: arrT)
                            arr3.append(dataModelTemp)
                        }
                    }
                }
                let dataModel3 = YHWorkExpDataModel(title: "", data: arr3)
                
                var arr4: [Any] = []
                do {
                    // 4.简历/工作总结：
                    if let items = model.file, items.isEmpty == false {
                        var arrT: [Any] = []
                        for(_, item) in items.enumerated() {
                            arrT.append(item)
                        }
                        let dataModelTemp = YHWorkExpDataModel(title: "简历/工作总结：", data: arrT)
                        arr4.append(dataModelTemp)
                    }
                }
                
                let dataModel4 = YHWorkExpDataModel(title: "", data: arr4)
                
                let addationIndex = list.count > 1 ? String(index + 1) : ""
                
                let mmmm = YHPreviewInfoSessionModel(cellType: .workExp, cellTitle: "主申请人工作经历" + addationIndex, cellData4: [dataModel1, dataModel2, dataModel3, dataModel4])
                arrDataForWorkExpInfo.append(mmmm)
            }
        }
    }
    
    // 组装 学历/专业资格 数据
    func installDataForAcademicInfo() {
        arrDataForAcademicInfo.removeAll()
        guard let model0 = academicInfoPreviewModel else { return}
        do {
            if let arr0 = model0.edu_list {
                for(index, model) in arr0.enumerated() {
                    // 主申请人学历
                    let tmp0 = YHPreviewQuestionAndAnswerModel(question: "学校全称：", answer: model.college)
                    let tmp1 = YHPreviewQuestionAndAnswerModel(question: "毕业年月：", answer: model.graduate_time)
                    var major = model.professional
                    if model.professional == "其他" {
                        major = model.major_other
                    }
                    let tmp2 = YHPreviewQuestionAndAnswerModel(question: "专业：", answer: major)
                    
                    var degree = "--"
                    if model.has_bachelor_degree == 1 {
                        degree = "学士学位"
                    }
                    if model.has_bachelor_degree == 2 {
                        degree = "无学位"
                    }
                    
                    let tmp3 = YHPreviewQuestionAndAnswerModel(question: "学位：", answer: degree)
//                    let tmp1 = YHPreviewQuestionAndAnswerModel(question: "授课形式：", answer:model.type)
//                    let tmp2 = YHPreviewQuestionAndAnswerModel(question: "入学年月：", answer:model.admission_time)
//                    let tmp6 = YHPreviewQuestionAndAnswerModel(question: "学位类型：", answer: model.degree_type)
                    
                    var schoolCountry = model.school_address?.country ?? ""
                    var address = ""
                    if model.school_address_aboard == 1 {
                        if let foreign = model.school_address?.foreign, !foreign.isEmpty {
                            address = foreign
                        }
                    } else {
                        if let schoolAddress = model.school_address {
                            for (index, text) in schoolAddress.area.enumerated() {
                                let text = schoolAddress.area[index]
                                address += text
                                if index != schoolAddress.area.count-1 {
                                    address += ","
                                }
                            }
                        }
                    }
                    var classAddress = "\(schoolCountry)-\(address)"
                    
                    let tmp4 = YHPreviewQuestionAndAnswerModel(question: "上课地点：", answer: classAddress)
                    let arr = [tmp0, tmp1, tmp2, tmp3, tmp4]
                    
                    let addationIndex = arr0.count > 1 ? String(index + 1) : ""
                    let model2 = YHPreviewInfoSessionModel(cellType: .countryInfoType, cellTitle: "主申请人学历" + addationIndex, cellData0: arr)
                    arrDataForAcademicInfo.append(model2)
                }
            }
        }
        
        do {
            // 主申请人
            let title = model0.qla_correct == 1 ? "是" : "否"
            let tmp0 = YHPreviewQuestionAndAnswerModel(question: "1、您的所有学历及资格证书的姓名及出生日期，是否与身份证完全一致？（例如：身份证上是【张四】，学位证上是【张三】，则为不同", answer: title)
            
//            let title2 = model0.edu_correct == 1 ? "是" : "否"
//            let tmp1 = YHPreviewQuestionAndAnswerModel(question: "2、您配偶的大学毕业证和学位证上的姓名及出生日期，是否与身份证完全一致？", answer: title2)
            let arr = [tmp0]
            let model1 = YHPreviewInfoSessionModel(cellType: .questionAndAnswer, cellTitle: "学历证书姓名及出生日期正确性", cellData0: arr)
            arrDataForAcademicInfo.append(model1)
        }
    }
    
    // 组装 主申请人预览 数据
    func installDataForMainApplicationInfo() {
        guard let model = mainApplicationInfoPreviewModel else { return  }
        
        do {
            // 国家信息
            let tmp0 = YHPreviewQuestionAndAnswerModel(question: "国家/国籍：", answer: model.nationality)
            var arr = [tmp0]
            if model.nationality.contains("中国") {
                let tmp1 = YHPreviewQuestionAndAnswerModel(question: "港澳通行证：", answer: model.is_handled == 0 ? "未办理" : "已办理")
                arr.append(tmp1)
            }
            let model1 = YHPreviewInfoSessionModel(cellType: .countryInfoType, cellTitle: "国籍信息", cellData0: arr)
            arrDataForMainApplicationInfo.append(model1)
        }
        
        do {
            // 基本信息
            let tmp0 = YHPreviewQuestionAndAnswerModel(question: "主申请人：", answer: model.username)
            let tmp1 = YHPreviewQuestionAndAnswerModel(question: "曾用名：", answer: model.used_name.defaultStringIfEmpty())
            let tmp2 = YHPreviewQuestionAndAnswerModel(question: "婚前姓氏：", answer: model.surname.defaultStringIfEmpty())
            let tmp3 = YHPreviewQuestionAndAnswerModel(question: "出生日期：", answer: model.birthday)
            let tmp4 = YHPreviewQuestionAndAnswerModel(question: "出生城市：", answer: model.birth_place_details)
            
            var msg = model.sex// 后台 王辉维护这个字段 前端直接展示
            let tmp5 = YHPreviewQuestionAndAnswerModel(question: "性别：", answer: msg)
            
            msg = model.married// 后台 王辉维护这个字段 前端直接展示
            let tmp6 = YHPreviewQuestionAndAnswerModel(question: "婚姻状况：", answer: msg)
            let tmp9 = YHPreviewQuestionAndAnswerModel(question: "现居住地址：", answer: model.live_address)
            
            var arr = [tmp0, tmp1, tmp2, tmp3, tmp4, tmp5, tmp6, tmp9]
            if model.live_address.contains("中国") == false {
                let tmp10 = YHPreviewQuestionAndAnswerModel(question: "是否在海外居住满1年及以上：", answer: model.is_live_oversea_year == 1 ? "是" : "否")
                arr.append(tmp10)
            } else {
                let tmp10 = YHPreviewQuestionAndAnswerModel(question: "详细地址：", answer: model.live_address_detail.defaultStringIfEmpty())
                arr.append(tmp10)
            }
            
            if let card = model.hk_id, card.has.contains("是") {
                let tmp5 = YHPreviewQuestionAndAnswerModel(question: "是否办理过香港身份证：", answer: "是")
                let tmp6 = YHPreviewQuestionAndAnswerModel(question: "香港身份证号码：", answer: card.number.defaultStringIfEmpty())
                arr.append(tmp5)
                arr.append(tmp6)
            } else {
                let tmp5 = YHPreviewQuestionAndAnswerModel(question: "是否办理过香港身份证：", answer: "否")
                arr.append(tmp5)
            }
            let model2 = YHPreviewInfoSessionModel(cellType: .countryInfoType, cellTitle: "基本信息", cellData0: arr)
            arrDataForMainApplicationInfo.append(model2)
        }
        
        if let model2 = model.certificates {
            // 1.跟随 证件信息
            do {
                // 中国身份证
                var str = model2.cnIdentityCard.number
                let tmp0 = YHPreviewQuestionAndAnswerModel(question: "中国身份证号码：", answer: str.defaultStringIfEmpty())
                
                str = model2.cnIdentityCard.issueAt
                let tmp1 = YHPreviewQuestionAndAnswerModel(question: "签发地：", answer: str.defaultStringIfEmpty())
                
                str = model2.cnIdentityCard.issueDateStartAt
                let tmp2 = YHPreviewQuestionAndAnswerModel(question: "签发日期：", answer: str.defaultStringIfEmpty())
                
                str = model2.cnIdentityCard.issueDateEndAt
                if str.isEmpty {
                    str = ""
                } else {
                    if str == "8888-01-01" {
                        str = "长期"
                    }
                }
                let tmp3 = YHPreviewQuestionAndAnswerModel(question: "届满日期：", answer: str.defaultStringIfEmpty())
                let model0 = YHPersonInfoCellModel1(cellTitle: "中国身份证", cellData: [tmp0, tmp1, tmp2, tmp3])
                
                // 港澳通行证
                str = model2.hkMacaoPass.number
                let tmp4 = YHPreviewQuestionAndAnswerModel(question: "旅行证件号码：", answer: str.defaultStringIfEmpty())
                
                str = model2.hkMacaoPass.issueAt
                let tmp5 = YHPreviewQuestionAndAnswerModel(question: "签发地：", answer: str.defaultStringIfEmpty())
                
                str = model2.hkMacaoPass.issueDateStartAt
                let tmp6 = YHPreviewQuestionAndAnswerModel(question: "签发日期：", answer: str.defaultStringIfEmpty())
                
                str = model2.hkMacaoPass.issueDateEndAt
                if str.isEmpty {
                    str = ""
                } else {
                    if str == "8888-01-01" {
                        str = "长期"
                    }
                }
                let tmp7 = YHPreviewQuestionAndAnswerModel(question: "届满日期：", answer: str.defaultStringIfEmpty())
                let model1 = YHPersonInfoCellModel1(cellTitle: "港澳通行证", cellData: [tmp4, tmp5, tmp6, tmp7])
            
                str = model2.passport.number
                let tmp9 = YHPreviewQuestionAndAnswerModel(question: "证件号码：", answer: str.defaultStringIfEmpty())
                
                str = model2.passport.issueAt
                let tmp10 = YHPreviewQuestionAndAnswerModel(question: "签发地：", answer: str.defaultStringIfEmpty())
                
                str = model2.passport.issueDateStartAt
                let tmp11 = YHPreviewQuestionAndAnswerModel(question: "签发日期：", answer: str.defaultStringIfEmpty())
                
                str = model2.passport.issueDateEndAt
                if str.isEmpty {
                    str = ""
                } else {
                    if str == "8888-01-01" {
                        str = "长期"
                    }
                }
                let tmp12 = YHPreviewQuestionAndAnswerModel(question: "届满日期：", answer: str.defaultStringIfEmpty())
                
                let model2 = YHPersonInfoCellModel1(cellTitle: "护照", cellData: [tmp9, tmp10, tmp11, tmp12])
                
                var arr: [YHPersonInfoCellModel1] = []
                if (model.nationality.contains("中国") && model.live_address.contains("中国")) || ((model.nationality.contains("中国") && model.is_live_oversea_year == 0)) {
                    arr = [model0, model1]
                } else if model.nationality.contains("中国") && model.is_live_oversea_year == 1 {
                    arr = [model0, model2]
                } else {
                    arr = [model2]
                }
                
                let model3 = YHPreviewInfoSessionModel(cellType: .idCardInfoType, cellTitle: "证件信息", cellData1: arr)
                arrDataForMainApplicationInfo.append(model3)
            }
            
            // 2.跟随 证件照
            do {
                var arr: [YHPersonInfoCellModel2] = []
                
                // 证件照片
                let front = model2.cnIdentityCard.imgFront
                let back = model2.cnIdentityCard.imgBack
                let model11 = YHPersonInfoCellModel2(cellTitle: "中国身份证", frontUrl: front, backUrl: back, idType: 1)
                
                let front1 = model2.hkMacaoPass.imgFront
                let back1 = model2.hkMacaoPass.imgBack
                let model22 = YHPersonInfoCellModel2(cellTitle: "港澳通行证", frontUrl: front1, backUrl: back1, idType: 2)
            
                let front2 = model2.passport.imgFront
                let model33 = YHPersonInfoCellModel2(cellTitle: "护照", frontUrl: front2, backUrl: "", idType: 3)
                if (model.nationality.contains("中国") && model.live_address.contains("中国")) || (model.nationality.contains("中国") && model.is_live_oversea_year == 0) {
                    if model.is_handled == 1 {
                        arr = [model11, model22]
                    } else {
                        arr = [model11]
                    }
                } else if model.nationality.contains("中国") && model.is_live_oversea_year == 1 {
                    arr = [model11, model33]
                } else {
                    arr = [model33]
                }
                let model4 = YHPreviewInfoSessionModel(cellType: .idPictureType, cellTitle: "证件照片", cellData2: arr)
                arrDataForMainApplicationInfo.append(model4)
            }
        }
    }
    
    // 组装 基本资料预览 数据
    func installDataForBasicInfo() {
        do {
            // 主申请人
            if let model = basiceInfoPreviewModel?.applicant {
                let answer0 = model.deny == 1 ? "是" : "否"
                let remark0 = answer0 == "是" ? (model.denyContent) : nil
                let tmp0 = YHPreviewQuestionAndAnswerModel(question: "1、是否曾被拒绝签发签证或入境香港，或被遣返、遣送和要求离开香港？", answer: answer0, remark: remark0)
                
                let answer1 = model.crime == 1 ? "是" : "否"
                let remark1 = answer1 == "是" ? model.crimeContent : nil
                let tmp1 = YHPreviewQuestionAndAnswerModel(question: "2、是否曾因任何罪行或违法行为在香港或其他地方被定罪？", answer: answer1, remark: remark1)
                
                let arr = [tmp0, tmp1]
                let model1 = YHPreviewInfoSessionModel(cellType: .questionAndAnswer, cellTitle: "主申请人", cellData0: arr)
                arrDataForBasicInfo.append(model1)
            }
        }
        
        do {
            // 配偶
            if let model = basiceInfoPreviewModel?.spouse {
                let answer0 = model.deny == 1 ? "是" : "否"
                let remark0 = answer0 == "是" ? (model.denyContent) : nil
                let tmp0 = YHPreviewQuestionAndAnswerModel(question: "1、是否曾被拒绝签发签证或入境香港，或被遣返、遣送和要求离开香港？", answer: answer0, remark: remark0)
                
                let answer1 = model.crime == 1 ? "是" : "否"
                let remark1 = answer1 == "是" ? model.crimeContent : nil
                let tmp1 = YHPreviewQuestionAndAnswerModel(question: "2、是否曾因任何罪行或违法行为在香港或其他地方被定罪？", answer: answer1, remark: remark1)
                
                let arr = [tmp0, tmp1]
                let model1 = YHPreviewInfoSessionModel(cellType: .questionAndAnswer, cellTitle: "配偶", cellData0: arr)
                arrDataForBasicInfo.append(model1)
            }
        }
        
        do {
            // 子女 - xxx
            if let arrChild = basiceInfoPreviewModel?.child {
                for (_, model) in arrChild.enumerated() {
                    let answer0 = model.deny == 1 ? "是" : "否"
                    let remark0 = answer0 == "是" ? (model.denyContent) : nil
                    let tmp0 = YHPreviewQuestionAndAnswerModel(question: "1、是否曾被拒绝签发签证或入境香港，或被遣返、遣送和要求离开香港？", answer: answer0, remark: remark0)
                    
                    let answer1 = model.crime == 1 ? "是" : "否"
                    let remark1 = answer1 == "是" ? model.crimeContent : nil
                    let tmp1 = YHPreviewQuestionAndAnswerModel(question: "2、是否曾因任何罪行或违法行为在香港或其他地方被定罪？", answer: answer1, remark: remark1)
                    
                    let arr = [tmp0, tmp1]
                    let model1 = YHPreviewInfoSessionModel(cellType: .questionAndAnswer, cellTitle: "子女信息(\(model.name))", cellData0: arr)
                    arrDataForBasicInfo.append(model1)
                }
            }
        }
    }
    
    // 组装 其他信息预览 数据
    func installDataForOtherInfo() {
        guard let model = otherInfoPreviewModel else {
            return
        }
        
        handleDataForOtherInfo()
        
        do {
            // 语言能力
            if let arr = otherInfoPreviewModel?.language_detail_new_local, arr.count > 0 {
                
                var arrT: [YHPreviewQuestionAndAnswerModel] = []
                for (index, item) in arr.enumerated() {
                    let tmp0 = YHPreviewQuestionAndAnswerModel(question: item.question, answer: item.answer, remark: "")
                    arrT.append(tmp0)
                }
                
                let model1 = YHPreviewInfoSessionModel(cellType: .questionAndAnswer, cellTitle: "语言能力", cellData0: arrT)
                arrDataForOtherInfo.append(model1)
            }
        }
        
        do {
            // 专业技能行业
            if let model = otherInfoPreviewModel?.profession {
                let tmp0 = YHPreviewQuestionAndAnswerModel(question: "1、最能代表你的专业技能的行业是？（单选）", answer: model.optionDes, remark: model.remark)
                let arr = [tmp0]
                let model1 = YHPreviewInfoSessionModel(cellType: .questionAndAnswer, cellTitle: "专业技能行业", cellData0: arr)
                arrDataForOtherInfo.append(model1)
            }
        }
        
        do {
            // 其他问题
            if let model = otherInfoPreviewModel?.question {
                let tmp0 = YHPreviewQuestionAndAnswerModel(question: "1、您是否有行业内的专业资格证书？", answer: model.professional_qualification == 1 ? "是" : "否")
                let tmp1 = YHPreviewQuestionAndAnswerModel(question: "2、您是否在期刊或杂志上发表论文、文章、书籍等（与工作、资质有关的）？", answer: model.paper == 1 ? "是" : "否")
                let tmp2 = YHPreviewQuestionAndAnswerModel(question: "3、您是否有大学奖学金证明、专利证书、获奖证书（工作单位颁发的可以）？", answer: model.scholarship == 1 ? "是" : "否")
                let tmp3 = YHPreviewQuestionAndAnswerModel(question: "4、您是否被媒体采访过，专访您的文章被发表在杂志上或网络上？", answer: model.media_interview == 1 ? "是" : "否")
                let tmp4 = YHPreviewQuestionAndAnswerModel(question: "5、专业奖项：", answer: model.professional_awards)
                let tmp5 = YHPreviewQuestionAndAnswerModel(question: "6、学业奖项：", answer: model.academic_awards)
                let tmp6 = YHPreviewQuestionAndAnswerModel(question: "7、其他资料：", answer: model.other_information)
                let arr = [tmp0, tmp1, tmp2, tmp3, tmp4, tmp5, tmp6]
                let model1 = YHPreviewInfoSessionModel(cellType: .questionAndAnswer, cellTitle: "辅助资料", cellData0: arr)
                arrDataForOtherInfo.append(model1)
            }
        }
    }
}

private extension YHGCPreviewViewModel {
    // 特殊处理 其他信息预览 需要的数据
    func handleDataForOtherInfo() {

        if let language = otherInfoPreviewModel?.language_detail_new {
            if language.count > 0 {
                if let arrCompare = [LanguageDetailModel].deserialize(from: YHOtherInfoFillViewModel.languageJsonData), arrCompare.count > 0 {
                    
                    var arrO: [YHPreviewQuestionModel] = []
                    for(index, item) in language.enumerated() {
                        
                        let firstID: Int = item.first_select
                        var secondID: Int = 0
                        
                        var firstName: String = ""
                        var secondName: String = ""
                        
                        if !item.second_select.isEmpty {
                            let arrTTT = item.second_select.split(separator: ",")
                            if arrTTT.count > 0 {
                                secondID = Int(arrTTT[0]) ?? 0
                            } else {
                                secondID = 0
                            }
                        } else {
                            secondID = 0
                        }
                        
                        var findFirstFlag: Bool = false
                        for(_, t) in arrCompare.enumerated() {
                            if t.id == firstID {
                                firstName = t.name + (t.other_instructions.isEmpty ? "" : ("=" + t.other_instructions))
                                findFirstFlag = true
                                
                                if t.id == 3 {
                                    firstName = firstName + "-" + item.other_instructions
                                }
                                
                                var findSecondFlag: Bool = false
                                for(_, tt) in t.options.enumerated() {
                                    if tt.id == secondID {
                                        secondName = tt.name
                                        findSecondFlag = true
                                    }
                                }
                                
                                if !findSecondFlag {
                                    secondName = "--"
                                }
                            }
                        }
                        
                        if !findFirstFlag {
                            firstName = "--"
                        }
                        
                        var question: YHPreviewQuestionModel = YHPreviewQuestionModel()
                        question.question = firstName
                        question.answer = secondName
                        arrO.append(question)
                    }
                    otherInfoPreviewModel?.language_detail_new_local = arrO
                } else {
                    otherInfoPreviewModel?.language_detail_new_local = []
                }
            } else {
                otherInfoPreviewModel?.language_detail_new_local = []
            }
        } else {
            otherInfoPreviewModel?.language_detail_new_local = []
        }
        
        if let profession = otherInfoPreviewModel?.profession {
            if profession.option > 0 {
                let target = String(profession.option)
                for(_, item) in YHConstantArrayData.arrSkill.enumerated() {
                    
                    if target == item["value"] {
                        profession.optionDes = item["title"] ?? "--"
                        break
                    }
                }
            }
        }
    }
}

private extension YHGCPreviewViewModel {
    func installDataForFamilyInfo() {
        // 父母
//        installDataForParents()
        
        // 配偶
        installDataForSpouse()
        
        // 子女
        installDataForChildren()
        
        // 兄弟姐妹
//        installDataForBrother()
    }
    
    // 父母 数据
    func installDataForParents() {
        do {
            if let model = familyInfoPreviewModel?.father {
                if model.deceased == 0 {
                    // 父亲信息-健在
                    let tmp0 = YHPreviewQuestionAndAnswerModel(question: "父亲姓名：", answer: model.subsetName)
                    let tmp1 = YHPreviewQuestionAndAnswerModel(question: "是否已故：", answer: "否")
                    let tmp2 = YHPreviewQuestionAndAnswerModel(question: "出生日期：", answer: model.birthday)
                    
                    var city = ""
                    if model.birthPlaceAboard == 0 {
                        // 国内
                        if model.birthPlace.area.count > 1 {
                            city = "国内 " + model.birthPlace.area[0] + "/" + model.birthPlace.area[1]
                        } else {
                            city = "国内 --"
                        }
                    } else {
                        // 国外
                        city = "国外 " + model.birthPlace.foreign
                    }
                    let tmp3 = YHPreviewQuestionAndAnswerModel(question: "出生城市：", answer: city)
                    let tmp11 = YHPreviewQuestionAndAnswerModel(question: "婚姻状况：", answer: model.married)
                    
                    let tmp4 = YHPreviewQuestionAndAnswerModel(question: "职业：", answer: model.occupation)
                    var arr = [tmp0, tmp1, tmp2, tmp3, tmp11, tmp4]
                    if model.occupation.contains("在职") {
                        let tmp5 = YHPreviewQuestionAndAnswerModel(question: "职业名称：", answer: model.occupationName)
                        arr.append(tmp5)
                    }
                    let tmp6 = YHPreviewQuestionAndAnswerModel(question: "现居住国家/地区：", answer: model.liveCountry)
                    arr.append(tmp6)
                    
//                    var arr = [tmp0,tmp1,tmp2,tmp3,tmp11,tmp4,tmp5,tmp6]
                    if let card = model.hkIdentityCard, card.isEmpty == false {
                        let tmp5 = YHPreviewQuestionAndAnswerModel(question: "是否办理过香港身份证：", answer: "是")
                        let tmp6 = YHPreviewQuestionAndAnswerModel(question: "香港身份证号码：", answer: model.hkIdentityCard ?? "--")
                        arr.append(tmp5)
                        arr.append(tmp6)
                    } else {
                        let tmp5 = YHPreviewQuestionAndAnswerModel(question: "是否办理过香港身份证：", answer: "否")
                        arr.append(tmp5)
                    }
                    let model1 = YHPreviewInfoSessionModel(cellType: .countryInfoType, cellTitle: "父亲信息", cellData0: arr)
                    arrDataForParents.append(model1)
                    
                } else {
                    // 父亲信息-已故
                    let tmp0 = YHPreviewQuestionAndAnswerModel(question: "父亲姓名：", answer: model.subsetName)
                    let tmp1 = YHPreviewQuestionAndAnswerModel(question: "是否已故：", answer: "是")
                    let tmp2 = YHPreviewQuestionAndAnswerModel(question: "出生日期：", answer: model.birthday)
                    var city = ""
                    if model.birthPlaceAboard == 0 {
                        // 国内
                        if model.birthPlace.area.count > 1 {
                            city = "国内 " + model.birthPlace.area[0] + "/" + model.birthPlace.area[1]
                        } else {
                            city = "国内 --"
                        }
                    } else {
                        // 国外
                        city = "国外 " + model.birthPlace.foreign
                    }
                    let tmp3 = YHPreviewQuestionAndAnswerModel(question: "出生城市：", answer: city)
                    let arr = [tmp0, tmp1, tmp2, tmp3]
                    let model1 = YHPreviewInfoSessionModel(cellType: .countryInfoType, cellTitle: "父亲信息", cellData0: arr)
                    arrDataForParents.append(model1)
                }
            } else {
                printLog("error:父亲数据不存在")
            }
        }
        
        do {
            if let model = familyInfoPreviewModel?.mother {
                if model.deceased == 0 {
                    // 母亲信息-健在
                    let tmp0 = YHPreviewQuestionAndAnswerModel(question: "母亲姓名：", answer: model.subsetName)
                    let tmp1 = YHPreviewQuestionAndAnswerModel(question: "是否已故：", answer: "否")
                    let tmp2 = YHPreviewQuestionAndAnswerModel(question: "出生日期：", answer: model.birthday)
                    var city = ""
                    if model.birthPlaceAboard == 0 {
                        // 国内
                        if model.birthPlace.area.count > 1 {
                            city = "国内 " + model.birthPlace.area[0] + "/" + model.birthPlace.area[1]
                        } else {
                            city = "国内 --"
                        }
                    } else {
                        // 国外
                        city = "国外 " + model.birthPlace.foreign
                    }
                    let tmp3 = YHPreviewQuestionAndAnswerModel(question: "出生城市：", answer: city)
                    
                    let tmp11 = YHPreviewQuestionAndAnswerModel(question: "婚姻状况：", answer: model.married)
                    let tmp4 = YHPreviewQuestionAndAnswerModel(question: "职业：", answer: model.occupation)
                    
                    var arr = [tmp0, tmp1, tmp2, tmp3, tmp11, tmp4]
                    if model.occupation.contains("在职") {
                        let tmp5 = YHPreviewQuestionAndAnswerModel(question: "职业名称：", answer: model.occupationName)
                        arr.append(tmp5)
                    }
                    let tmp6 = YHPreviewQuestionAndAnswerModel(question: "现居住国家/地区：", answer: model.liveCountry)
                    arr.append(tmp6)
                    
//                    var arr = [tmp0,tmp1,tmp2,tmp3,tmp11,tmp4,tmp5,tmp6]
                    if let card = model.hkIdentityCard, card.isEmpty == false {
                        let tmp5 = YHPreviewQuestionAndAnswerModel(question: "是否办理过香港身份证：", answer: "是")
                        let tmp6 = YHPreviewQuestionAndAnswerModel(question: "香港身份证号码：", answer: model.hkIdentityCard ?? "--")
                        arr.append(tmp5)
                        arr.append(tmp6)
                    } else {
                        let tmp5 = YHPreviewQuestionAndAnswerModel(question: "是否办理过香港身份证：", answer: "否")
                        arr.append(tmp5)
                    }
                    
                    let model1 = YHPreviewInfoSessionModel(cellType: .countryInfoType, cellTitle: "母亲信息-健在", cellData0: arr)
                    arrDataForParents.append(model1)
                } else {
                    // 母亲信息-已故
                    let tmp0 = YHPreviewQuestionAndAnswerModel(question: "母亲信息：", answer: model.subsetName)
                    let tmp1 = YHPreviewQuestionAndAnswerModel(question: "是否已故：", answer: "是")
                    let tmp2 = YHPreviewQuestionAndAnswerModel(question: "出生日期：", answer: model.birthday)
                    var city = ""
                    if model.birthPlaceAboard == 0 {
                        // 国内
                        if model.birthPlace.area.count > 1 {
                            city = "国内 " + model.birthPlace.area[0] + "/" + model.birthPlace.area[1]
                        } else {
                            city = "国内 --"
                        }
                    } else {
                        // 国外
                        city = "国外 " + model.birthPlace.foreign
                    }
                    let tmp3 = YHPreviewQuestionAndAnswerModel(question: "出生城市：", answer: city)
                    let arr = [tmp0, tmp1, tmp2, tmp3]
                    let model1 = YHPreviewInfoSessionModel(cellType: .countryInfoType, cellTitle: "母亲信息", cellData0: arr)
                    arrDataForParents.append(model1)
                }
            } else {
                printLog("error:母亲数据不存在")
            }
        }
        arrDataForFamilyInfo = arrDataForParents
    }
    
    func isNeedHiddenHKPassportInfo(familyMember: YHFamilyMember, applicant: YHMyMainApplicantInfoModel?) -> Bool {
        
        // 港澳通信证
        var isHiddenHK = true
        // 国籍
        let nationality = familyMember.nationality
        // 居住国家
        var liveCountry = familyMember.address.country
        // 居住海外是否满一年
        var isLiveOverseaYear = familyMember.isOverSeasOver1Year()
        
        if familyMember.isLiveTother(), let mainApplicantInfo = applicant {
            // 与主申请人同住需要用主申请人居住信息判断
            liveCountry = mainApplicantInfo.applicant_address.country
            isLiveOverseaYear = mainApplicantInfo.isOverSeasOver1Year()

        }
        
        if nationality.contains("中国") { // 中国国籍
            let isLiveInChina = liveCountry.contains("中国".local)
            if isLiveInChina || (!isLiveInChina && !isLiveOverseaYear) {
                // 中国国籍&居住国内、中国国籍&居住国外不满一年 需展示“港澳通行证”询问框
                isHiddenHK = false
            }
        }
        return isHiddenHK
    }
    
    private func installDataForSpouseOp(model: YHFamilyMember, mainApplicant: YHMyMainApplicantInfoModel?) {
        
        var arrTemp: [YHPreviewInfoSessionModel] = []
        do {
            if model.follow == 1 {
                
                do {
                    // 随行信息 - 是
                    var arr = [YHPreviewQuestionAndAnswerModel]()
                    let tmp0 = YHPreviewQuestionAndAnswerModel(question: "是否随行至香港：", answer: "是")
                    arr.append(tmp0)
                    
                    let tmp1 = YHPreviewQuestionAndAnswerModel(question: "国家/国籍：", answer: model.nationality)
                    arr.append(tmp1)
                    
                    if !isNeedHiddenHKPassportInfo(familyMember: model, applicant: mainApplicant) {
                        let tmp2 = YHPreviewQuestionAndAnswerModel(question: "港澳通行证：", answer: model.isHandled == 1 ? "已办理" : "未办理")
                        arr.append(tmp2)

                    }
                    
                    let model1 = YHPreviewInfoSessionModel(cellType: .countryInfoType, cellTitle: "随行信息", cellData0: arr)
                    arrTemp.append(model1)
                }
                
                do {
                    // 配偶信息
                    let tmp0 = YHPreviewQuestionAndAnswerModel(question: "配偶姓名：", answer: model.subsetName)
                    let tmp1 = YHPreviewQuestionAndAnswerModel(question: "曾用名：", answer: model.usedName.defaultStringIfEmpty())
                    let tmp2 = YHPreviewQuestionAndAnswerModel(question: "婚前姓氏：", answer: model.surname.defaultStringIfEmpty())
                    let tmp3 = YHPreviewQuestionAndAnswerModel(question: "出生日期：", answer: model.birthday)
                    var city = ""
                    if model.birthPlaceAboard == 0 {
                        // 国内
                        city = "国内 " + model.birthPlace.details
                        
                    } else {
                        // 国外
                        city = "国外 " + model.birthPlace.foreign
                    }
                    let tmp4 = YHPreviewQuestionAndAnswerModel(question: "出生城市：", answer: city)
                    var arr = [tmp0, tmp1, tmp2, tmp3, tmp4]
            
                    let tmp10 = YHPreviewQuestionAndAnswerModel(question: "是否和主申请人同住：", answer: model.nows == 1 ? "是" : "否")
                    arr.append(tmp10)
                    
                    var liveAbord = false // 海外
                    var address = ""
                    if model.nows == 0 {
                        var title = ""
                        if model.address.country.contains("中国") {
                            // 国内
                            title = "国内 "
                            if model.address.area.count > 1 {
                                title = title + model.address.area[0] + "/" + model.address.area[1]
                            } else {
                                title = "国内 --"
                            }
                            address = model.address.details
                            
                        } else {
                            // 国外
                            title = model.address.country
                            liveAbord = true
                            
                            address = model.address.foreign
                        }
                        let tmp11 = YHPreviewQuestionAndAnswerModel(question: "现居住地址：", answer: title)
                        arr.append(tmp11)
                        
                    }
                    
                    let tmp133 = YHPreviewQuestionAndAnswerModel(question: "详细地址：", answer: address.defaultStringIfEmpty())
                    arr.append(tmp133)
                    
                    var answer = "--"
                    if let isResidence = model.isHavePermanentResidenceStatus() {
                        answer = isResidence ? "是" : "否"
                    }
                    let tmp111 = YHPreviewQuestionAndAnswerModel(question: "是否拥有现时定居国家/地区的永久居留身份", answer: answer)
                    arr.append(tmp111)
                    
                    if liveAbord == true {
                        let title = model.isLiveOverseaYear == 1 ? "是" : "否"
                        let tmp12 = YHPreviewQuestionAndAnswerModel(question: "是否在海外居住满1年及以上：", answer: title)
                        arr.append(tmp12)
                    }
                    
                    let isHKIdCardHandled = model.isHaveHKIdentityCard()
                    let isHKIdCardHandledString = isHKIdCardHandled ? "是" : "否"
                    let tmp14 = YHPreviewQuestionAndAnswerModel(question: "是否办理过香港身份证：", answer: isHKIdCardHandledString)
                    arr.append(tmp14)
                    
                    if let tmp = model.hkIdentityCard, tmp.isEmpty == false {
                        let tmp17 = YHPreviewQuestionAndAnswerModel(question: "香港身份证号码：", answer: tmp)
                        arr.append(tmp17)
                    }
                    
                    let model2 = YHPreviewInfoSessionModel(cellType: .countryInfoType, cellTitle: "配偶信息", cellData0: arr)
                    arrTemp.append(model2)
                }
            } else {
                do {
                    // 随行信息 - 否
                    let tmp0 = YHPreviewQuestionAndAnswerModel(question: "是否随行至香港：", answer: "否")
                    let arr = [tmp0]
                    let model1 = YHPreviewInfoSessionModel(cellType: .countryInfoType, cellTitle: "随行信息", cellData0: arr)
                    arrTemp.append(model1)
                }
                
                do {
                    // 配偶信息-否
                    let tmp0 = YHPreviewQuestionAndAnswerModel(question: "配偶姓名：", answer: model.subsetName)
                    let tmp1 = YHPreviewQuestionAndAnswerModel(question: "曾用名：", answer: model.usedName.defaultStringIfEmpty())
                    let tmp2 = YHPreviewQuestionAndAnswerModel(question: "婚前姓氏：", answer: model.surname.defaultStringIfEmpty())
                    let tmp3 = YHPreviewQuestionAndAnswerModel(question: "出生日期：", answer: model.birthday)
                    var city = ""
                    if model.birthPlaceAboard == 0 {
                        // 国内
                        city = "国内 " + model.birthPlace.details
                        
                    } else {
                        // 国外
                        city = "国外 " + model.birthPlace.foreign
                    }
                    let tmp4 = YHPreviewQuestionAndAnswerModel(question: "出生城市：", answer: city)
                    
                    var arr = [tmp0, tmp1, tmp2, tmp3, tmp4]
                    
                    var answer = "--"
                    if let isResidence = model.isHavePermanentResidenceStatus() {
                        answer = isResidence ? "是" : "否"
                    }
                    let tmp111 = YHPreviewQuestionAndAnswerModel(question: "是否拥有现时定居国家/地区的永久居留身份", answer: answer)
                    arr.append(tmp111)
                    
                    let isHKIdCardHandled = model.isHaveHKIdentityCard()
                    let isHKIdCardHandledString = isHKIdCardHandled ? "是" : "否"
                    let tmp5 = YHPreviewQuestionAndAnswerModel(question: "是否办理过香港身份证：", answer: isHKIdCardHandledString)
                    arr.append(tmp5)
                    
                    if let card = model.hkIdentityCard, card.isEmpty == false {
                        let tmp6 = YHPreviewQuestionAndAnswerModel(question: "香港身份证号码：", answer: model.hkIdentityCard ?? "--")
                        arr.append(tmp6)
                    }
                    let model1 = YHPreviewInfoSessionModel(cellType: .countryInfoType, cellTitle: "配偶信息", cellData0: arr)
                    arrTemp.append(model1)
                }
                
            }
        }
        
        if model.follow == 1 { // 随行 才显示证件信息和证件照片
            
            // 证件信息显示逻辑
            var cerInfoArr = [YHPersonInfoCellModel1]()
            let a = showCerInfoLogic(familyMember: model, mainApplicantInfo: mainApplicant)
            let isNeedShowHK = a.showHK
            let isNeedShowPassport = a.showPassport
            
            if model.nationality.contains("中国") {
                var str = model.certificates.cnIdentityCard.number
                let tmp4 = YHPreviewQuestionAndAnswerModel(question: "中国身份证件号码：", answer: str.defaultStringIfEmpty())
                
                str = model.certificates.cnIdentityCard.issueAt
                let tmp5 = YHPreviewQuestionAndAnswerModel(question: "签发地：", answer: str.defaultStringIfEmpty())
                
                str = model.certificates.cnIdentityCard.issueDateStartAt
                let tmp6 = YHPreviewQuestionAndAnswerModel(question: "签发日期：", answer: str.defaultStringIfEmpty())
                
                str = model.certificates.cnIdentityCard.issueDateEndAt
                if str.isEmpty {
                    str = ""
                } else {
                    if str == "8888-01-01" {
                        str = "长期"
                    }
                }
                let tmp7 = YHPreviewQuestionAndAnswerModel(question: "届满日期：", answer: str.defaultStringIfEmpty())
                let model1 = YHPersonInfoCellModel1(cellTitle: "港澳通行证", cellData: [tmp4, tmp5, tmp6, tmp7])
                cerInfoArr.append(model1)
            }
            
            if isNeedShowHK {
                
                var str = model.certificates.hkMacaoPass.number
                let tmp4 = YHPreviewQuestionAndAnswerModel(question: "旅行证件号码：", answer: str.defaultStringIfEmpty())
                
                str = model.certificates.hkMacaoPass.issueAt
                let tmp5 = YHPreviewQuestionAndAnswerModel(question: "签发地：", answer: str.defaultStringIfEmpty())
                
                str = model.certificates.hkMacaoPass.issueDateStartAt
                let tmp6 = YHPreviewQuestionAndAnswerModel(question: "签发日期：", answer: str.defaultStringIfEmpty())
                
                str = model.certificates.hkMacaoPass.issueDateEndAt
                if str.isEmpty {
                    str = ""
                } else {
                    if str == "8888-01-01" {
                        str = "长期"
                    }
                }
                let tmp7 = YHPreviewQuestionAndAnswerModel(question: "届满日期：", answer: str.defaultStringIfEmpty())
                let model1 = YHPersonInfoCellModel1(cellTitle: "港澳通行证", cellData: [tmp4, tmp5, tmp6, tmp7])
                cerInfoArr.append(model1)
            }
            
            if isNeedShowPassport {
                // 护照及其他旅行证件
                
                var str = model.certificates.passport.number
                let tmp9 = YHPreviewQuestionAndAnswerModel(question: "证件号码：", answer: str.defaultStringIfEmpty())
                
                str = model.certificates.passport.issueAt
                let tmp10 = YHPreviewQuestionAndAnswerModel(question: "签发地：", answer: str.defaultStringIfEmpty())
                
                str = model.certificates.passport.issueDateStartAt
                let tmp11 = YHPreviewQuestionAndAnswerModel(question: "签发日期：", answer: str.defaultStringIfEmpty())
                
                str = model.certificates.passport.issueDateEndAt
                if str.isEmpty {
                    str = ""
                } else {
                    if str == "8888-01-01" {
                        str = "长期"
                    }
                }
                let tmp12 = YHPreviewQuestionAndAnswerModel(question: "届满日期：", answer: str.defaultStringIfEmpty())
                let model2 = YHPersonInfoCellModel1(cellTitle: "护照", cellData: [tmp9, tmp10, tmp11, tmp12])
                cerInfoArr.append(model2)
            }
            let model3 = YHPreviewInfoSessionModel(cellType: .idCardInfoType, cellTitle: "证件信息", cellData1: cerInfoArr)
            arrTemp.append(model3)
            
            // 证件照片显示逻辑
            let cerPhotoArr = showCerPhotoLogic(familyMember: model, mainApplicantInfo: mainApplicant)
            var photoArr = [YHPersonInfoCellModel2]()
            for cerType in cerPhotoArr {
                if cerType == .idCard {
                    let front = model.certificates.cnIdentityCard.imgFront
                    let back = model.certificates.cnIdentityCard.imgBack
                    let model1 = YHPersonInfoCellModel2(cellTitle: "中国身份证", frontUrl: front, backUrl: back, idType: 1)
                    photoArr.append(model1)
                    
                } else if cerType == .hkPassPort {
                    let front = model.certificates.hkMacaoPass.imgFront
                    let back = model.certificates.hkMacaoPass.imgBack
                    let model2 = YHPersonInfoCellModel2(cellTitle: "港澳通行证", frontUrl: front, backUrl: back, idType: 2)
                    photoArr.append(model2)
                    
                } else if cerType == .passPort {
                    let front = model.certificates.passport.imgFront
                    let back = model.certificates.passport.imgBack
                    let model3 = YHPersonInfoCellModel2(cellTitle: "护照", frontUrl: front, backUrl: back, idType: 3)
                    photoArr.append(model3)
                }
            }
            
            let model4 = YHPreviewInfoSessionModel(cellType: .idPictureType, cellTitle: "证件照片", cellData2: photoArr)
            arrTemp.append(model4)
        }
        arrDataForSpouse = arrTemp
    }
    
    // 配偶 数据
    func installDataForSpouse() {
        guard let model = familyInfoPreviewModel?.spouse else {
            printLog("error:配偶数据不存在")
            return
        }
        arrDataForSpouse.removeAll()
        installDataForSpouseOp(model: model, mainApplicant: familyInfoPreviewModel?.applicant)
    }
    
    private func installDataForChildOp(model: YHFamilyMember, mainApplicant: YHMyMainApplicantInfoModel?, childIndex: Int, totalChild: Int = 0) {
        var arrTemp: [YHPreviewInfoSessionModel] = []
        do {
            if model.follow == 1 {
                do {
                    // 随行信息 - 是
                    var arr = [YHPreviewQuestionAndAnswerModel]()
                    let tmp00 = YHPreviewQuestionAndAnswerModel(question: "主申请人或现配偶是否拥有孩子护养权：", answer: model.custody == 1 ? "是" : "否")
                    arr.append(tmp00)
                    
                    let tmp0 = YHPreviewQuestionAndAnswerModel(question: "该子女是否随行至香港：", answer: "是")
                    arr.append(tmp0)

                    let tmp1 = YHPreviewQuestionAndAnswerModel(question: "国家/国籍：", answer: model.nationality)
                    arr.append(tmp1)
                    
                    if !isNeedHiddenHKPassportInfo(familyMember: model, applicant: mainApplicant) {
                        let tmp2 = YHPreviewQuestionAndAnswerModel(question: "港澳通行证：", answer: model.isHandled == 1 ? "已办理" : "未办理")
                        arr.append(tmp2)

                    }
                    
                    var title = ""
                    if totalChild > 1 {
                        title = "(\(childIndex+1))"
                    }
                    let model1 = YHPreviewInfoSessionModel(cellType: .countryInfoType, cellTitle: "随行信息" + title, cellData0: arr)
                    arrTemp.append(model1)
                }
                do {
                    // 子女信息
                    let tmp0 = YHPreviewQuestionAndAnswerModel(question: "子女姓名：", answer: model.subsetName)
                    let tmp1 = YHPreviewQuestionAndAnswerModel(question: "曾用名：", answer: model.usedName.defaultStringIfEmpty())
                    let tmp2 = YHPreviewQuestionAndAnswerModel(question: "婚前姓氏：", answer: model.surname.defaultStringIfEmpty())
                    
                    let sexStr = YHConstantArrayData.getShowNameBy(indexStr: String(model.sex), type: .sex)
                    let tmp3 = YHPreviewQuestionAndAnswerModel(question: "出生日期：", answer: model.birthday)
                    var city = ""
                    if model.birthPlaceAboard == 0 {
                        // 国内
                        city = "国内 " + model.birthPlace.details
                        
                    } else {
                        // 国外
                        city = "国外 " + model.birthPlace.foreign
                    }
                    let tmp4 = YHPreviewQuestionAndAnswerModel(question: "出生城市：", answer: city)
                    
                    let tmp5 = YHPreviewQuestionAndAnswerModel(question: "婚姻状况：", answer: model.married)
                    var arr: [YHPreviewQuestionAndAnswerModel] = [tmp0, tmp1, tmp2, tmp3, tmp4, tmp5]

                    let tmp10 = YHPreviewQuestionAndAnswerModel(question: "是否和主申请人同住：", answer: model.nows == 1 ? "是" : "否")
                    arr.append(tmp10)
                    
                    var liveAbord = false // 海外
                    var address = ""
                    if model.nows == 0 {
                        var title = ""
                        if model.address.country.contains("中国") {
                            // 国内
                            title = "国内 "
                            if model.address.area.count > 1 {
                                title = title + model.address.area[0] + "/" + model.address.area[1]
                            } else {
                                title = "国内 --"
                            }
                            address = model.address.details
                        } else {
                            // 国外
                            title = model.address.country
                            liveAbord = true
                            
                            address = model.address.foreign
                        }
                        let tmp11 = YHPreviewQuestionAndAnswerModel(question: "现居住地址：", answer: title)
                        arr.append(tmp11)
                        
                        let tmp133 = YHPreviewQuestionAndAnswerModel(question: "详细地址：", answer: address.defaultStringIfEmpty())
                        arr.append(tmp133)
                    }
                    
                    var answer = "--"
                    if let isResidence = model.isHavePermanentResidenceStatus() {
                        answer = isResidence ? "是" : "否"
                    }
                    let tmp111 = YHPreviewQuestionAndAnswerModel(question: "是否拥有现时定居国家/地区的永久居留身份", answer: answer)
                    arr.append(tmp111)
                    
                    if liveAbord == true {
                        let title = model.isLiveOverseaYear == 1 ? "是" : "否"
                        let tmp12 = YHPreviewQuestionAndAnswerModel(question: "是否在海外居住满1年及以上：", answer: title)
                        arr.append(tmp12)
                    }
                    
                    if true {
                        let title = model.isPreviousMarriageChild() ? "是" : "否"
                        let tmp12 = YHPreviewQuestionAndAnswerModel(question: "是否为前次婚姻的子女", answer: title)
                        arr.append(tmp12)
                    }
                    
                    let isHKIdCardHandled = model.isHaveHKIdentityCard()
                    let isHKIdCardHandledString = isHKIdCardHandled ? "是" : "否"
                    let tmp16 = YHPreviewQuestionAndAnswerModel(question: "是否办理过香港身份证：", answer: isHKIdCardHandledString)
                    arr.append(tmp16)
                    
                    if let tmp = model.hkIdentityCard, tmp.isEmpty == false {
                        let tmp17 = YHPreviewQuestionAndAnswerModel(question: "香港身份证号码：", answer: tmp)
                        arr.append(tmp17)
                    }
                    
                    var title = ""
                    if totalChild > 1 {
                        title = String(childIndex + 1)
                    }

                    let model2 = YHPreviewInfoSessionModel(cellType: .countryInfoType, cellTitle: "子女信息" + "(\(model.subsetName))", cellData0: arr)
                    arrTemp.append(model2)
                }
                
            } else {
                do {
                    // 随行信息 - 否
                    let tmp0 = YHPreviewQuestionAndAnswerModel(question: "是否随行至香港：", answer: "否")
                    let arr = [tmp0]
                    
                    var title = ""
                    if totalChild > 1 {
                        title = String(childIndex + 1)
                    }
                    let model1 = YHPreviewInfoSessionModel(cellType: .countryInfoType, cellTitle: "随行信息" + title, cellData0: arr)
                    arrTemp.append(model1)
                }
                
                do {
                    // 配偶信息-否
                    let tmp0 = YHPreviewQuestionAndAnswerModel(question: "子女姓名：", answer: model.subsetName)
                    let tmp1 = YHPreviewQuestionAndAnswerModel(question: "曾用名：", answer: model.usedName.defaultStringIfEmpty())
                    let tmp2 = YHPreviewQuestionAndAnswerModel(question: "婚前姓氏：", answer: model.surname.defaultStringIfEmpty())
                    let sexStr = YHConstantArrayData.getShowNameBy(indexStr: String(model.sex), type: .sex)
                    let tmp3 = YHPreviewQuestionAndAnswerModel(question: "出生日期：", answer: model.birthday)
                    var city = ""
                    if model.birthPlaceAboard == 0 {
                        // 国内
                        city = "国内 " + model.birthPlace.details
                        
                    } else {
                        // 国外
                        city = "国外 " + model.birthPlace.foreign
                    }
                    let tmp4 = YHPreviewQuestionAndAnswerModel(question: "出生城市：", answer: city)
                    let tmp44 = YHPreviewQuestionAndAnswerModel(question: "婚姻状况：", answer: model.married.defaultStringIfEmpty())
                    var arr = [tmp0, tmp1, tmp2, tmp3, tmp4, tmp44]
                    
                    var liveAbord = false // 海外
                    var address = ""
                    if model.nows == 0 {
                        var title = ""
                        if model.address.country.contains("中国") {
                            // 国内
                            title = "国内 "
                            if model.address.area.count > 1 {
                                title = title + model.address.area[0] + "/" + model.address.area[1]
                            } else {
                                title = "国内 --"
                            }
                            address = model.address.details
                        } else {
                            // 国外
                            title = model.address.country
                            liveAbord = true
                            
                            address = model.address.foreign
                        }
                        let tmp11 = YHPreviewQuestionAndAnswerModel(question: "现居住地址：", answer: title)
                        arr.append(tmp11)
                        
                        let tmp133 = YHPreviewQuestionAndAnswerModel(question: "详细地址：", answer: address.defaultStringIfEmpty())
                        arr.append(tmp133)
                    }
                    
                    var answer = "--"
                    if let isResidence = model.isHavePermanentResidenceStatus() {
                        answer = isResidence ? "是" : "否"
                    }
                    let tmp111 = YHPreviewQuestionAndAnswerModel(question: "是否拥有现时定居国家/地区的永久居留身份", answer: answer)
                    arr.append(tmp111)
                    
                    if liveAbord == true {
                        let title = model.isLiveOverseaYear == 1 ? "是" : "否"
                        let tmp12 = YHPreviewQuestionAndAnswerModel(question: "是否在海外居住满1年及以上：", answer: title)
                        arr.append(tmp12)
                    }
                    
                    let isHKIdCardHandled = model.isHaveHKIdentityCard()
                    let isHKIdCardHandledString = isHKIdCardHandled ? "是" : "否"
                    let tmp5 = YHPreviewQuestionAndAnswerModel(question: "是否办理过香港身份证：", answer: isHKIdCardHandledString)
                    arr.append(tmp5)
                    
                    if let card = model.hkIdentityCard, card.isEmpty == false {
                        let tmp6 = YHPreviewQuestionAndAnswerModel(question: "香港身份证号码：", answer: model.hkIdentityCard ?? "--")
                        arr.append(tmp6)
                    }
                    
                    var title = ""
                    if totalChild > 1 {
                        title = String(childIndex + 1)
                    }
                    let model1 = YHPreviewInfoSessionModel(cellType: .countryInfoType, cellTitle: "子女信息" + "(\(model.subsetName))", cellData0: arr)
                    arrTemp.append(model1)
                }
            }
        }
        
        if model.follow == 1 { // 随行 才显示证件信息和证件照片
            // 证件信息显示逻辑
            var cerInfoArr = [YHPersonInfoCellModel1]()
            let a = showCerInfoLogic(familyMember: model, mainApplicantInfo: mainApplicant)
            let isNeedShowHK = a.showHK
            let isNeedShowPassport = a.showPassport
            
            if model.nationality.contains("中国") {
                var str = model.certificates.cnIdentityCard.number
                let tmp4 = YHPreviewQuestionAndAnswerModel(question: "中国身份证件号码：", answer: str.defaultStringIfEmpty())
                
                str = model.certificates.cnIdentityCard.issueAt
                let tmp5 = YHPreviewQuestionAndAnswerModel(question: "签发地：", answer: str.defaultStringIfEmpty())
                
                str = model.certificates.cnIdentityCard.issueDateStartAt
                let tmp6 = YHPreviewQuestionAndAnswerModel(question: "签发日期：", answer: str.defaultStringIfEmpty())
                
                str = model.certificates.cnIdentityCard.issueDateEndAt
                if str.isEmpty {
                    str = ""
                } else {
                    if str == "8888-01-01" {
                        str = "长期"
                    }
                }
                let tmp7 = YHPreviewQuestionAndAnswerModel(question: "届满日期：", answer: str.defaultStringIfEmpty())
                let model1 = YHPersonInfoCellModel1(cellTitle: "港澳通行证", cellData: [tmp4, tmp5, tmp6, tmp7])
                cerInfoArr.append(model1)
            }
            
            if isNeedShowHK {
                
                var str = model.certificates.hkMacaoPass.number
                let tmp4 = YHPreviewQuestionAndAnswerModel(question: "旅行证件号码：", answer: str.defaultStringIfEmpty())
                
                str = model.certificates.hkMacaoPass.issueAt
                let tmp5 = YHPreviewQuestionAndAnswerModel(question: "签发地：", answer: str.defaultStringIfEmpty())
                
                str = model.certificates.hkMacaoPass.issueDateStartAt
                let tmp6 = YHPreviewQuestionAndAnswerModel(question: "签发日期：", answer: str.defaultStringIfEmpty())
                
                str = model.certificates.hkMacaoPass.issueDateEndAt
                if str.isEmpty {
                    str = ""
                } else {
                    if str == "8888-01-01" {
                        str = "长期"
                    }
                }
                let tmp7 = YHPreviewQuestionAndAnswerModel(question: "届满日期：", answer: str.defaultStringIfEmpty())
                let model1 = YHPersonInfoCellModel1(cellTitle: "港澳通行证", cellData: [tmp4, tmp5, tmp6, tmp7])
                cerInfoArr.append(model1)
            }
            
            if isNeedShowPassport {
                // 护照及其他旅行证件
                
                var str = model.certificates.passport.number
                let tmp9 = YHPreviewQuestionAndAnswerModel(question: "证件号码：", answer: str.defaultStringIfEmpty())
                
                str = model.certificates.passport.issueAt
                let tmp10 = YHPreviewQuestionAndAnswerModel(question: "签发地：", answer: str.defaultStringIfEmpty())
                
                str = model.certificates.passport.issueDateStartAt
                let tmp11 = YHPreviewQuestionAndAnswerModel(question: "签发日期：", answer: str.defaultStringIfEmpty())
                
                str = model.certificates.passport.issueDateEndAt
                if str.isEmpty {
                    str = ""
                } else {
                    if str == "8888-01-01" {
                        str = "长期"
                    }
                }
                let tmp12 = YHPreviewQuestionAndAnswerModel(question: "届满日期：", answer: str.defaultStringIfEmpty())
                let model2 = YHPersonInfoCellModel1(cellTitle: "护照", cellData: [tmp9, tmp10, tmp11, tmp12])
                cerInfoArr.append(model2)
            }
            let model3 = YHPreviewInfoSessionModel(cellType: .idCardInfoType, cellTitle: "证件信息", cellData1: cerInfoArr)
            arrTemp.append(model3)
            
            // 证件照片显示逻辑
            let cerPhotoArr = showCerPhotoLogic(familyMember: model, mainApplicantInfo: mainApplicant)
            var photoArr = [YHPersonInfoCellModel2]()
            for cerType in cerPhotoArr {
                if cerType == .idCard {
                    let front = model.certificates.cnIdentityCard.imgFront
                    let back = model.certificates.cnIdentityCard.imgBack
                    let model1 = YHPersonInfoCellModel2(cellTitle: "中国身份证", frontUrl: front, backUrl: back, idType: 1)
                    photoArr.append(model1)
                    
                } else if cerType == .hkPassPort {
                    let front = model.certificates.hkMacaoPass.imgFront
                    let back = model.certificates.hkMacaoPass.imgBack
                    let model2 = YHPersonInfoCellModel2(cellTitle: "港澳通行证", frontUrl: front, backUrl: back, idType: 2)
                    photoArr.append(model2)
                    
                } else if cerType == .passPort {
                    let front = model.certificates.passport.imgFront
                    let back = model.certificates.passport.imgBack
                    let model3 = YHPersonInfoCellModel2(cellTitle: "护照", frontUrl: front, backUrl: back, idType: 3)
                    photoArr.append(model3)
                }
            }
            
            let model4 = YHPreviewInfoSessionModel(cellType: .idPictureType, cellTitle: "证件照片", cellData2: photoArr)
            arrTemp.append(model4)
        }
        arrDataForChildren.append(contentsOf: arrTemp)

    }
    
    // 子女 数据
    func installDataForChildren() {
        guard let model1 = familyInfoPreviewModel?.child else {
            return
        }
        arrDataForChildren.removeAll()
        for(index, model) in model1.enumerated() {
            installDataForChildOp(model: model, mainApplicant: familyInfoPreviewModel?.applicant, childIndex: index, totalChild: model1.count)
        }
    }
    
    // 兄弟姐妹 数据
    func installDataForBrother() {
        
        guard let model1 = familyInfoPreviewModel?.brother else {
            return
        }
        
        do {
            // 兄弟姐妹信息
            
            for model in model1 {
                let tmp0 = YHPreviewQuestionAndAnswerModel(question: "姓名：", answer: model.subsetName)
                let tmp1 = YHPreviewQuestionAndAnswerModel(question: "婚姻状况：", answer: model.married)
                let tmp2 = YHPreviewQuestionAndAnswerModel(question: "出生日期：", answer: model.birthday)
                var city = ""
                if model.birthPlaceAboard == 0 {
                    // 国内
                    if model.birthPlace.area.count > 1 {
                        city = "国内 " + model.birthPlace.area[0] + "/" + model.birthPlace.area[1]
                    } else {
                        city = "国内 --"
                    }
                } else {
                    // 国外
                    city = "国外 " + model.birthPlace.foreign
                }
                let tmp3 = YHPreviewQuestionAndAnswerModel(question: "出生城市：", answer: city)
                let tmp4 = YHPreviewQuestionAndAnswerModel(question: "职业：", answer: model.occupation)
                
                var arr = [tmp0, tmp1, tmp2, tmp3, tmp4]
                if model.occupation.contains("在职") {
                    let tmp5 = YHPreviewQuestionAndAnswerModel(question: "职业名称：", answer: model.occupationName)
                    arr.append(tmp5)
                }
                
                let tmp6 = YHPreviewQuestionAndAnswerModel(question: "现居住国家/地区：", answer: model.liveCountry)
                arr.append(tmp6)
                
                if let str = model.hkIdentityCard, str.isEmpty == false {
                    let tmp7 = YHPreviewQuestionAndAnswerModel(question: "是否办理过香港身份证：", answer: "是")
                    let tmp8 = YHPreviewQuestionAndAnswerModel(question: "香港身份证号码：", answer: model.hkIdentityCard ?? "--")
                    arr.append(tmp7)
                    arr.append(tmp8)
                    
                } else {
                    let tmp7 = YHPreviewQuestionAndAnswerModel(question: "是否办理过香港身份证：", answer: "否")
                    arr.append(tmp7)
                }
                let model1 = YHPreviewInfoSessionModel(cellType: .countryInfoType, cellTitle: "兄弟姐妹信息", cellData0: arr)
                arrDataForBrother.append(model1)
            }
        }
    }
    
    // swiftlint:disable:next large_tuple
    func showCerInfoLogic(familyMember: YHFamilyMember?, mainApplicantInfo: YHMyMainApplicantInfoModel?) -> (showHK: Bool, isHKMust: Bool, showPassport: Bool, isPassportMust: Bool) {
        
        guard let familyMember = familyMember else { return (false, false, false, false) }
                
        // 是否显示港澳通行证
        var showHK = false
        // 港澳通行证是否必填
        var isHKMust = false
        
        // 是否显示护照
        var showPassport = false
        // 护照是否必填
        var isPassportMust = false
        
        // 国籍
        let nationality = familyMember.nationality
        // 居住国外是否满一年
        var is_live_oversea_year = familyMember.isOverSeasOver1Year()
        // 居住国家
        var liveCountry = familyMember.address.country
        
        if familyMember.isLiveTother(), let mainApplicant = mainApplicantInfo { // 与主申请人同住用主申请人的居住信息判断
            liveCountry = mainApplicant.applicant_address.country
            is_live_oversea_year = mainApplicant.isOverSeasOver1Year()
        }
        
        if nationality.contains("中国") { // 中国国籍
            let isLiveInChina = liveCountry.contains("中国".local)
            if isLiveInChina { // 居住国内
                if familyMember.isHandled == 0 { // 没办理过港澳通行证
                    // 证件信息：港澳通行证非必填(无身份证、护照)
                    showHK = true
                    isHKMust = false
                    
                } else { // 办理过港澳通行证
                    // 证件信息：港澳通行证必填(无身份证、护照)
                    showHK = true
                    isHKMust = true
                }
                
            } else { // 居住国外
                if !is_live_oversea_year { // 居住国外不满一年
                    if familyMember.isHandled == 0 { // 没办理过港澳通行证
                        // 证件信息：港澳通行证非必填(无身份证、护照)
                        showHK = true
                        isHKMust = false
                        
                    } else { // 办理过港澳通行证
                        // 证件信息：港澳通行证必填(无身份证、护照)
                        showHK = true
                        isHKMust = true
                    }
                    
                } else { // 居住国外满一年
                    // 证件信息：护照必填(无身份证)
                    showPassport = true
                    isPassportMust = true
                }
            }
        } else { // 外国国籍
            //  证件信息：仅护照且必填(无身份证)
            showPassport = true
            isPassportMust = true
        }
        return (showHK, isHKMust, showPassport, isPassportMust)
    }
    
    func showCerPhotoLogic(familyMember: YHFamilyMember?, mainApplicantInfo: YHMyMainApplicantInfoModel?) -> [YHCerPhotoInfoType] {
        
        guard let familyMember = familyMember else { return [.none] }

        // 国籍
        let nationality = familyMember.nationality
        // 居住国外是否满一年
        var is_live_oversea_year = familyMember.isOverSeasOver1Year()
        // 居住国家
        var liveCountry = familyMember.address.country
        
        if familyMember.isLiveTother(), let mainApplicant = mainApplicantInfo { // 与主申请人同住用主申请人的居住信息判断
            liveCountry = mainApplicant.applicant_address.country
            is_live_oversea_year = mainApplicant.isOverSeasOver1Year()
        }
        
        if nationality.contains("中国") { // 中国国籍
            let isLiveInChina = liveCountry.contains("中国".local)
            if isLiveInChina { // 居住国内
                if familyMember.isHandled == 0 { // 没办理过港澳通行证
                    // 证件上传：身份证
                    return [.idCard]
                    
                } else { // 办理过港澳通行证
                    // 证件上传：身份证+港澳通
                    return [.idCard, .hkPassPort]
                }
                
            } else { // 居住国外
                if !is_live_oversea_year { // 居住国外不满一年
                    if familyMember.isHandled == 0 { // 没办理过港澳通行证
                        // 证件上传：身份证
                        return [.idCard]
                        
                    } else { // 办理过港澳通行证
                        // 证件上传：身份证+港澳通
                        return [.idCard, .hkPassPort]
                    }
                    
                } else { // 居住国外满一年
                    // 证件上传：护照+身份证
                    return [.passPort, .idCard]
                }
            }
        } else { // 外国国籍
            //  证件信息：仅护照且必填(无身份证)
            return [.passPort]
        }
    }
}
