//
//  YHGCWorkItemListViewModel.swift
//  galaxy
//
//  Created by EDY on 2024/12/20.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHGCWorkItemListViewModel: YHBaseViewModel {
    var mainModel: YHGCWorkModel = YHGCWorkModel()
    var listModel: [YHWorkItemListModel]?
    var workId: Int = 0
    override init() {
        super.init()
    }
    
    func getBaseDataSource(_ isShowPrompt: Bool) -> YHSectionWorkExperienceModel {
        var has_work_experience = 2
        if mainModel.has_work_experience == 1 {
            has_work_experience = 1
        } else if mainModel.has_work_experience == 2 {
            has_work_experience = 0
        }
        let item = YHWorkExperienceModel(id: .id1, isNeed: true, title: "主申请人是否有工作经验", isUserKeyBoard: false, prompts: "", message: "\(has_work_experience)", leftButtonString: "是", rightButtonString: "否", isShowPrompts: isShowPrompt, alertMessage: "请选择")
        let section = YHSectionWorkExperienceModel(title: "工作经验", models: [item])
        return section
    }
    
    func getDocDataSource(_ isShowPrompt: Bool) -> YHSectionWorkExperienceModel {
        var has_company_consent = 2
        if mainModel.has_company_consent == 1 {
            has_company_consent = 1
        } else if mainModel.has_company_consent == 2 {
            has_company_consent = 0
        }
        let item = YHWorkExperienceModel(id: .id2, isNeed: true, title: "在职公司是否可以提供赴港同意书？", isUserKeyBoard: false, prompts: "", message: "\(has_company_consent)", leftButtonString: "是", rightButtonString: "否", isShowPrompts: isShowPrompt, alertMessage: "请选择")
        var has_center_consent = 2
        if mainModel.has_center_consent == 1 {
            has_center_consent = 1
        } else if mainModel.has_center_consent == 2 {
            has_center_consent = 0
        }
        let item1 = YHWorkExperienceModel(id: .id3, isNeed: true, title: "人才中心是否可以提供赴港同意书？", isUserKeyBoard: false, prompts: "", message: "\(has_center_consent)", leftButtonString: "是", rightButtonString: "否", isShowPrompts: isShowPrompt, alertMessage: "请选择")
        var company = ""
        let array = mainModel.list ?? []
        for item in array {
            if mainModel.consent_work_id == item.id {
                company = item.company_name ?? ""
            }
        }
        if company == "" && array.count == 1 {
            let item = array.first
            company = item?.company_name ?? ""
            mainModel.consent_work_id = item?.id ?? 0
        }
        let item2 = YHWorkExperienceModel(id: .id4, isNeed: true, title: "可提供的在职公司", isUserKeyBoard: false, prompts: "请选择", message: company, type: .myCompany, isShowPrompts: isShowPrompt, alertMessage: "请选择")
        if mainModel.has_work_experience == 1 {
            if has_company_consent == 2 {
                let section = YHSectionWorkExperienceModel(title: "赴港同意书提供", models: [item])
                return section
            } else if has_company_consent == 1 {
                let section = YHSectionWorkExperienceModel(title: "赴港同意书提供", models: [item, item2])
                return section
            } else if has_company_consent == 0 {
                let section = YHSectionWorkExperienceModel(title: "赴港同意书提供", models: [item, item1])
                return section
            } else {
                let section = YHSectionWorkExperienceModel(title: "赴港同意书提供", models: [item])
                return section
            }
        } else {
            let section = YHSectionWorkExperienceModel(title: "赴港同意书提供", models: [item1])
            return section
        }
    }
    
    func requestWorkList(_ orderId: String, callBackBlock: @escaping (_ success: [YHWorkItemListModel]?, _ error: YHErrorModel?) -> Void) {
//        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.WorkExperience.list + "?order_id=\(orderId)"
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.WorkExperience.gclist
        let params: [String: Any] = ["order_id": orderId]
        
        _ = YHNetRequest.getRequest(url: strUrl, params: params) { [weak self] json, _ in
            // 1. json字符串 转 对象
            guard let self = self else { return }
            if json.code == 200 {
                guard let dic = json.data?.peel as? [String: Any], let result = YHGCWorkModel.deserialize(from: dic) else {
                    callBackBlock([], nil)
                    return
                }
                self.mainModel = result
                self.listModel = result.list
                callBackBlock(self.listModel, nil)
            } else {
                let error: YHErrorModel = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg)
                callBackBlock([], error)
            }
        } failBlock: { err in
            callBackBlock([], err)
        }
    }
    
    func requestDeleteWorkExperience(_ id: Int, _ orderId: String, callBackBlock: @escaping (_ success: Bool?, _ error: YHErrorModel?) -> Void) {
        let params: [String: Any] = ["id": id, "order_id": orderId]
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.WorkExperience.del
        _ = YHNetRequest.postRequest(url: strUrl, params: params) { [weak self] json, _ in
            // 1. json字符串 转 对象
            guard let self = self else { return }
            if json.code == 200 {
                callBackBlock(true, nil)
            } else {
                let error: YHErrorModel = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg)
                callBackBlock(false, error)
            }
        } failBlock: { err in
            callBackBlock(false, err)
        }
    }
    
    func requestWorkTimeRemarkWorkExperience(_ isSubmit: Bool = true, _ orderId: String, _ isSaveAll: Int = 0, callBackBlock: @escaping (_ success: Bool?, _ error: YHErrorModel?) -> Void) {
        let params: [String: Any] = ["order_id": orderId,
                                      "has_company_consent": self.mainModel.has_company_consent,
                                      "consent_work_id": self.mainModel.consent_work_id,
                                      "has_center_consent": self.mainModel.has_center_consent,
                                      "why_work_time_overlap": self.mainModel.why_work_time_overlap,
                                      "has_work_experience": self.mainModel.has_work_experience,
                                      "is_submit": isSubmit]
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.WorkExperience.saveAll
        _ = YHNetRequest.postRequest(url: strUrl, params: params) { [weak self] json, _ in
            // 1. json字符串 转 对象
            guard let self = self else { return }
            if json.code == 200 {
                callBackBlock(true, nil)
            } else {
                let error: YHErrorModel = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg)
                callBackBlock(false, error)
            }
        } failBlock: { err in
            callBackBlock(false, err)
        }
    }
    
    // 创建新的是否可用
    func requestCreateNewWork(_ orderId: Int, callBackBlock: @escaping (_ success: Int, _ error: YHErrorModel?) -> Void) {
//        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.WorkExperience.list + "?order_id=\(orderId)"
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.WorkExperience.createNewWork
        let params: [String: Any] = ["order_id": orderId]
        
        _ = YHNetRequest.postRequest(url: strUrl, params: params) { [weak self] json, _ in
            // 1. json字符串 转 对象
            guard let self = self else { return }
            if json.code == 200 {
                guard let dic = json.data?.peel as? [String: Any], let result = YHWorkExperienceDetailModel.deserialize(from: dic) else {
                    callBackBlock(0, nil)
                    return
                }
                self.workId = result.work_id
                callBackBlock(result.work_id, nil)
            } else {
                let error: YHErrorModel = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg)
                callBackBlock(0, error)
            }
        } failBlock: { err in
            callBackBlock(0, err)
        }
    }
    
    func updateModel(_ model: YHWorkExperienceModel) {
        switch model.id {
        case .id1:
            let value = model.value?.first?.int ?? 0
            if value == 0 {
                mainModel.has_work_experience = 2
                mainModel.has_company_consent = 2
                mainModel.has_center_consent = 1
            } else if value == 1 {
                mainModel.has_work_experience = 1
            }
        case .id2:
            let value = model.value?.first?.int ?? 0
            if value == 0 {
                mainModel.has_company_consent = 2
            } else if value == 1 {
                mainModel.has_company_consent = 1
            }
        case .id3:
            let value = model.value?.first?.int ?? 0
            if value == 0 {
                mainModel.has_center_consent = 2
            } else if value == 1 {
                mainModel.has_center_consent = 1
            }
        case .id4:
            let array = mainModel.list ?? []
            for item in array {
                if model.message == item.company_name {
                    mainModel.consent_work_id = item.id ?? 0
                }
            }
        default:
            break
        }
    }
    
}
