//
//  YHLivePlayerViewController+Api.swift
//  galaxy
//
//  Created by alexzzw on 2024/11/27.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import Foundation

extension YHLivePlayerViewController {
    
    func requestData(id: Int, callback: @escaping (_ liveDetail: YHLiveDetailModel?, _ error: YHErrorModel?) -> Void) {
        viewModel.getLiveDetail(id: id) { liveDetail, error in
            callback(liveDetail, error)
        }
    }
    
    func joinLiveRoom(id: Int, callback: @escaping (_ success: Bool, _ error: YHErrorModel?) -> Void) {
        viewModel.joinLiveRoom(id: id) { success, error in
            callback(success, error)
        }
    }
    
    func leaveLiveRoom(id: Int, callback: @escaping (_ success: Bool, _ error: YHErrorModel?) -> Void) {
        viewModel.leaveLiveRoom(id: id) { success, error in
            callback(success, error)
        }
    }
}
