//
//  YHLiveDetailModel.swift
//  galaxy
//
//  Created by alexzzw on 2024/11/27.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import Foundation
import SmartCodable

class YHLiveDetailModel: SmartCodable {
    var account: String = ""
    var avatar: String = ""
    var hxNickname: String = ""
    var hxUid: String = ""
    var access_num: String = ""
    var tips: String = ""
    // 0:未知状态 1:直播中 2:未直播 3:结束直播
    var status: Int = 0
    // 1:正常 2:播放中 3:禁推---(当status==1才监测，3代表离开了)
    var stream_status: Int = 0
    var roomId: String = ""
    var pullUrl: String = ""
    var goods: [YHLiveGoodsItem] = []
    var token: String = ""
    var rtmp_channel: String = ""
    var app_id: String = ""
    
    // 直播封面
    var live_image: String = ""
    // 直播主题
    var live_title: String = ""
    // h5直播地址
    var live_h5_url: String = ""
    // 预计开始时间
    var start_time: String = ""
    // 拉流地址360p
    var pull_sd1_url: String = ""
    // 拉流地址720p
    var pull_hd_url: String = ""
    // 实际开始时间
    var actual_start_time: String = ""
    // 实际结束时间
    var actual_end_time: String = ""
    var user_id: Int = 0
    
    func getLiveState() -> YHLiveState {
        switch status {
        case 0:
            return .unknown
        case 1:
            if stream_status == 3 {
                return .stop
            }
            return .onLive
        case 2:
            return .start
        case 3:
            return .end
        default:
            return .unknown
        }
    }

    required init() {
    }
}

class YHLiveGoodsItem: SmartCodable {
    var id: Int = 0
    var name: String = ""
    var image: String = ""
    var description: String = ""
    var price: String = ""
    var linePrice: String = ""
    var sn: String = ""
    var banner: String = ""
    var flag: Int = 0

    required init() {
    }
}
