//
//  YHInputBottomBar.swift
//  galaxy
//
//  Created by alexzzw on 2024/11/26.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHInputBottomBar: UIView {
    static let inputActionHeight: CGFloat = 54
    private let inputViewHeight: CGFloat = 38

    var giftButtonClickEvent: (() -> Void)?
    var textViewTappedEvent: (() -> Void)?

    private lazy var inputBarView: UIView = {
        let view = UIView()
        view.backgroundColor = UIColor.black.withAlphaComponent(0.3)
        view.layer.cornerRadius = inputViewHeight / 2.0
        view.clipsToBounds = true
        let tap = UITapGestureRecognizer(target: self, action: #selector(didTappedTextView))
        view.addGestureRecognizer(tap)
        return view
    }()

    private lazy var editTipsLabel: UILabel = {
        let label = UILabel()
        label.text = "说点什么..."
        label.font = .PFSC_R(ofSize: 13)
        label.textColor = UIColor.white.withAlphaComponent(0.6)
        return label
    }()

    private lazy var giftButton: UIButton = {
        let button = UIButton(type: .custom)
        button.setBackgroundImage(UIImage(named: "live_room_msg_gift"), for: .normal)
        button.setTitle("0", for: .normal)
        button.setTitleColor(UIColor.white, for: .normal)
        button.titleLabel?.font = .PFSC_M(ofSize: 10)
        button.addTarget(self, action: #selector(giftButtonTapped), for: .touchUpInside)
        button.titleEdgeInsets = UIEdgeInsets(top: 5, left: 0, bottom: -5, right: 0)
        return button
    }()

    override init(frame: CGRect) {
        super.init(frame: frame)
        setupUI()
    }

    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }

    private func setupUI() {
        addSubview(inputBarView)
        addSubview(editTipsLabel)
        addSubview(giftButton)
        inputBarView.snp.makeConstraints { make in
            make.top.equalToSuperview().offset(8)
            make.left.equalToSuperview().offset(16)
            make.height.equalTo(inputViewHeight)
        }
        giftButton.snp.makeConstraints { make in
            make.left.equalTo(inputBarView.snp.right).offset(16)
            make.right.equalToSuperview().offset(-16)
            make.centerY.equalTo(inputBarView)
            make.width.height.equalTo(38)
        }
        editTipsLabel.snp.makeConstraints { make in
            make.left.equalTo(inputBarView.snp.left).offset(16)
            make.centerY.equalTo(inputBarView)
        }
    }

    func updateGiftCount(_ count: Int) {
        guard count > 0 else {
            inputBarView.snp.remakeConstraints { make in
                make.top.equalToSuperview().offset(8)
                make.left.equalToSuperview().offset(16)
                make.height.equalTo(inputViewHeight)
                make.right.equalToSuperview().offset(-16)
            }
            giftButton.snp.remakeConstraints { make in
                make.right.equalToSuperview().offset(-16)
                make.centerY.equalTo(inputBarView)
                make.width.height.equalTo(38)
            }
            giftButton.isHidden = true
            return
        }
        giftButton.isHidden = false
        inputBarView.snp.remakeConstraints { make in
            make.top.equalToSuperview().offset(8)
            make.left.equalToSuperview().offset(16)
            make.height.equalTo(inputViewHeight)
        }
        giftButton.snp.remakeConstraints { make in
            make.left.equalTo(inputBarView.snp.right).offset(16)
            make.right.equalToSuperview().offset(-16)
            make.centerY.equalTo(inputBarView)
            make.width.height.equalTo(38)
        }
        if count > 99 {
            giftButton.setTitle("99+", for: .normal)
        } else {
            giftButton.setTitle("\(count)", for: .normal)
        }
    }
}

extension YHInputBottomBar {
    @objc private func giftButtonTapped() {
        giftButtonClickEvent?()
    }

    @objc private func didTappedTextView() {
        textViewTappedEvent?()
    }
}
