//
//  YHRecommendedLiveHeader.swift
//  galaxy
//
//  Created by alexzzw on 2024/12/29.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHRecommendedLiveHeader: UIView {
    var moreButtonEvent: (() -> Void)?
    
    private lazy var tagView: UIView = {
        let view = UIView(frame: CGRect(x: 0, y: 0, width: 2, height: 12))
        view.backgroundColor = UIColor.brandMainColor
        return view
    }()
    
    private lazy var tagLabel: UILabel = {
        let label = UILabel()
        label.font = .PFSC_R(ofSize: 14)
        label.textColor = .white
        label.text = "推荐直播"
        return label
    }()
    
    private lazy var moreButton: UIButton = {
        let button = UIButton(type: .custom)
        button.frame = CGRect(x: 0, y: 0, width: 42, height: 16)
        button.setTitle("更多", for: .normal)
        button.setTitleColor(UIColor.white.withAlphaComponent(0.5), for: .normal)
        button.titleLabel?.font = UIFont.PFSC_R(ofSize: 12)
        button.setImage(UIImage(named: "arrow_right_white_16"), for: .normal)
        button.addTarget(self, action: #selector(moreButtonClicked), for: .touchUpInside)
        return button
    }()
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        setupUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    private func setupUI() {
        addSubview(tagView)
        addSubview(tagLabel)
        addSubview(moreButton)
        tagView.snp.makeConstraints { make in
            make.left.equalToSuperview().offset(20)
            make.centerY.equalToSuperview()
            make.width.equalTo(2)
            make.height.equalTo(12)
        }
        tagLabel.snp.makeConstraints { make in
            make.left.equalTo(tagView.snp.right).offset(8)
            make.centerY.equalToSuperview()
            make.right.lessThanOrEqualTo(moreButton.snp.left).offset(-10)
        }
        moreButton.snp.makeConstraints { make in
            make.right.equalToSuperview().offset(-20)
            make.centerY.equalToSuperview()
            make.width.equalTo(42)
            make.height.equalTo(20)
        }
        moreButton.iconInRight(with: 0)
    }
    
    @objc private func moreButtonClicked() {
        moreButtonEvent?()
    }

}
