//
//  YHCountryMessageView.swift
//  galaxy
//
//  Created by EDY on 2025/2/12.
//  Copyright © 2025 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHCountryMessageView: UIView {

    typealias PhoneBlock = (_ count: Int) -> Void
    typealias Block = () -> Void
    var block: Block?
    var messageButton: UIButton!
    var titleButton: UIButton!
    var allowButton: UIButton!
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        setView()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func setView() {
        titleButton = {
            let button = UIButton(type: .custom)
            button.titleLabel?.font = UIFont.PFSC_M(ofSize: 16)
            button.setTitle("国家/地区", for: .normal)
            button.setTitleColor(UIColor.mainTextColor, for: .normal)
            button.addTarget(self, action: #selector(messageClick), for: .touchUpInside)
            button.contentHorizontalAlignment = .left
            return button
        }()
        addSubview(titleButton)
        titleButton.snp.makeConstraints { make in
            make.top.bottom.equalToSuperview()
            make.left.equalToSuperview()
            make.width.equalTo(85)
            make.height.equalTo(20)
        }
        
        messageButton = {
            let button = UIButton(type: .custom)
            button.titleLabel?.font = UIFont.PFSC_M(ofSize: 16)
            button.setTitle("中国大陆", for: .normal)
            button.setTitleColor(UIColor.mainTextColor, for: .normal)
            button.addTarget(self, action: #selector(messageClick), for: .touchUpInside)
            button.contentHorizontalAlignment = .left
            return button
        }()
        addSubview(messageButton)
        messageButton.snp.makeConstraints { make in
            make.top.bottom.equalToSuperview()
            make.left.equalTo(105)
            make.right.equalToSuperview()
            make.height.equalTo(20)
        }
        
        allowButton = {
            let button = UIButton(type: .custom)
            button.setBackgroundImage(UIImage(named: "form_right_arrow"), for: .normal)
            button.addTarget(self, action: #selector(messageClick), for: .touchUpInside)
            return button
        }()
        addSubview(allowButton)
        allowButton.snp.makeConstraints { make in
            make.centerY.right.equalToSuperview()
            make.width.height.equalTo(16)
        }
       
        let lineone = UIView()
        lineone.backgroundColor = UIColor(hex: 0xf0f3f7, alpha: 0.8)
        addSubview(lineone)
        lineone.snp.makeConstraints { make in
            make.left.equalTo(89)
            make.height.equalTo(20)
            make.width.equalTo(0.5)
            make.centerY.equalToSuperview()
        }
        
        let line = UIView()
        line.backgroundColor = UIColor(hex: 0xf0f3f7, alpha: 0.8)
        addSubview(line)
        line.snp.makeConstraints { make in
            make.bottom.left.right.equalToSuperview()
            make.height.equalTo(0.5)
        }
    }
    
    @objc func messageClick() {
        if let block = block {
            block()
        }
    }
}
