//
//  YHPhoneMessageView.swift
//  galaxy
//
//  Created by EDY on 2024/1/6.
//  Copyright © 2024 www.davidhuang.com. All rights reserved.
//

import UIKit

class YHPhoneMessageView: UIView {
    typealias PhoneBlock = (_ count: Int) -> Void
    typealias Block = () -> Void
    var block: Block?
    var phoneBlock: PhoneBlock?
    var messageButton: UILabel!
    var titleButton: UIButton!
    var phoneTextField: UITextField!
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        setView()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func setView() {
        titleButton = {
            let button = UIButton(type: .custom)
            button.titleLabel?.font = UIFont.PFSC_M(ofSize: 16)
            button.setTitle("手机号", for: .normal)
            button.setTitleColor(UIColor.mainTextColor, for: .normal)
            button.addTarget(self, action: #selector(messageClick), for: .touchUpInside)
            button.contentHorizontalAlignment = .left
            return button
        }()
        addSubview(titleButton)
        titleButton.snp.makeConstraints { make in
            make.top.bottom.equalToSuperview()
            make.left.equalToSuperview()
            make.width.equalTo(85)
            make.height.equalTo(20)
        }
        
        messageButton = {
            let button = UILabel()
            button.font = UIFont.PFSC_R(ofSize: 16)
            button.text = "+86"
            button.textColor = UIColor(hex: 0x8993a2)
            return button
        }()
        addSubview(messageButton)
        messageButton.snp.makeConstraints { make in
            make.left.equalTo(105)
            make.height.equalTo(20)
            make.centerY.equalToSuperview()
        }
        
        phoneTextField = {
            let text = UITextField()
            text.placeholder = "请输入您的手机号"
            text.font = UIFont.PFSC_R(ofSize: 18)
            text.textColor = UIColor.mainTextColor
            text.textAlignment = .left
            text.keyboardType = .phonePad
            text.clearButtonMode = .always
            text.delegate = self
            text.addTarget(self, action: #selector(textFeildChange), for: .allEvents)
            return text
        }()
        addSubview(phoneTextField)
        phoneTextField.snp.makeConstraints { make in
            make.top.bottom.equalToSuperview()
            make.left.equalTo(messageButton.snp.right).offset(16)
            make.height.equalTo(20)
        }
        let lineone = UIView()
        lineone.backgroundColor = UIColor(hex: 0xf0f3f7, alpha: 0.8)
        addSubview(lineone)
        lineone.snp.makeConstraints { make in
            make.left.equalTo(89)
            make.height.equalTo(20)
            make.width.equalTo(0.5)
            make.centerY.equalToSuperview()
        }
        
        let line = UIView()
        line.backgroundColor = UIColor(hex: 0xf0f3f7, alpha: 0.8)
        addSubview(line)
        line.snp.makeConstraints { make in
            make.bottom.left.right.equalToSuperview()
            make.height.equalTo(0.5)
        }
        
    }
    
    @objc func messageClick() {
        if let block = block {
            block()
        }
    }
    
    @objc func textFeildChange() {
        if let block = phoneBlock {
            block(phoneTextField.text?.count ?? 0)
        }
    }
}

extension YHPhoneMessageView: UITextFieldDelegate {
    func textFieldDidEndEditing(_ textField: UITextField) {
        
    }
    
    func textField(_ textField: UITextField, shouldChangeCharactersIn range: NSRange, replacementString string: String) -> Bool {
        let newText = (textField.text! as NSString).replacingCharacters(in: range, with: string)
        if newText.count > 12 {
            return false
        }
        return true
    }
}
