//
//  YHTestViewController.swift
//  galaxy
//
//  Created by davidhuangA on 2024/5/17.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHTestViewController: YHBaseViewController {
    
    var gradientLayer: CAGradientLayer = {
        let gradientLayer = CAGradientLayer()
        gradientLayer.colors = [UIColor(hex: 0xFFF9E3, alpha: 1.0).cgColor, UIColor(hex: 0xFFE895, alpha: 1.0).cgColor]
        gradientLayer.startPoint = CGPoint(x: 0.5, y: 0)
        gradientLayer.endPoint = CGPoint(x: 0.5, y: 1)
        gradientLayer.locations = [NSNumber(value: 0.2)]
        gradientLayer.frame = CGRect(x: 0, y: 0, width: 200, height: 60)
        return gradientLayer
    }()
    
    lazy var numLabel: UILabel = {
        let label = UILabel()
        label.textColor = UIColor.black
        label.textAlignment = .center
        label.font = UIFont.PFSC_B(ofSize: 80)
        label.text = "90"
        return label
    }()
    
    override func viewDidLoad() {
        super.viewDidLoad()
        
        let width  = numLabel.requiredWidth
        gradientLayer.frame = CGRect(x: 0, y: 0, width: width, height: 80)
        
        self.numLabel.layer.frame = gradientLayer.bounds
        gradientLayer.mask = self.numLabel.layer
        
        let testView = UIView()
        view.addSubview(testView)
        testView.snp.makeConstraints { make in
            make.centerX.equalToSuperview()
            make.centerY.equalToSuperview()
            make.width.equalTo(width)
            make.height.equalTo(80)
        }
        testView.layer.insertSublayer(gradientLayer, at: 0)
    }
}
