//
//  YHMemberCenterInfo.swift
//  galaxy
//
//  Created by alexzzw on 2025/2/20.
//  Copyright © 2025 https://www.galaxy-immi.com. All rights reserved.
//

import SmartCodable
import UIKit

class YHMemberCenterInfo: SmartCodable {
    var answerConsult: YHMemberGiftModel = YHMemberGiftModel()
    var brandStrategy: YHMemberGiftModel = YHMemberGiftModel()
    var carTransfer: YHMemberGiftModel = YHMemberGiftModel()
    var currentLevel: Int = 0

    var dedicatedAdviser: YHMemberGiftModel = YHMemberGiftModel()
    var exchangeCount: Int = 0
    var exchangedCount: Int = 0
    var experienceCenter: YHMemberGiftModel = YHMemberGiftModel()

    var growthValue: Int = 0
    var highEndPrivilege: YHMemberGiftModel = YHMemberGiftModel()
    var highTeaBox: YHMemberGiftModel = YHMemberGiftModel()
    var hkCarTransfer: YHMemberGiftModel = YHMemberGiftModel()

    var hongkongSchoolPlanning: YHMemberGiftModel = YHMemberGiftModel()
    var internationalDrivingLicense: YHMemberGiftModel = YHMemberGiftModel()
    var luxuryTea: YHMemberGiftModel = YHMemberGiftModel()
    var maxGrowth: Int = 0

    var offlineSalon: YHMemberGiftModel = YHMemberGiftModel()
    var specialIntegralConsumption: YHMemberGiftModel = YHMemberGiftModel()

    enum CodingKeys: String, CodingKey {
        case answerConsult = "answer_consult"
        case brandStrategy = "brand_strategy"
        case carTransfer = "car_transfer"
        case currentLevel = "current_level"

        case dedicatedAdviser = "dedicated_adviser"
        case exchangeCount = "exchange_count"
        case exchangedCount = "exchanged_count"
        case experienceCenter = "experience_center"

        case growthValue = "growth_value"
        case highEndPrivilege = "high_end_privilege"
        case highTeaBox = "high_tea_box"
        case hkCarTransfer = "hk_car_transfer"

        case hongkongSchoolPlanning = "hongkong_school_planning"
        case internationalDrivingLicense = "international_driving_license"
        case luxuryTea = "luxury_tea"
        case maxGrowth = "max_growth"

        case offlineSalon = "offline_salon"
        case specialIntegralConsumption = "special_integral_consumption"
    }

    required init() {
    }
}

// MARK: - YHMemberAnswerConsult

class YHMemberGiftModel: SmartCodable {
    var giftId: String = ""
    var minLevel: Int = 0
    var name: String = ""
    var num: Int = 0

    enum CodingKeys: String, CodingKey {
        case giftId = "gift_id"
        case minLevel = "min_level"
        case name
        case num
    }

    required init() {
    }
}
