//
//  YHMembershipLevel.swift
//  galaxy
//
//  Created by alexzzw on 2025/2/14.
//  Copyright © 2025 https://www.galaxy-immi.com. All rights reserved.
//

import Foundation

enum YHMembershipLevel: Int, CaseIterable {
    case normal = 10
    case gold = 20
    case platinum = 30
    case diamond = 40

    // 名称
    var description: String {
        switch self {
        case .normal:
            return "普通会员"
        case .gold:
            return "黄金会员"
        case .platinum:
            return "铂金会员"
        case .diamond:
            return "钻石会员"
        }
    }
    
    // 可享特权数目
    var privilegeCount: Int {
        switch self {
        case .normal:
            return 5
        case .gold:
            return 7
        case .platinum:
            return 8
        case .diamond:
            return 13
        }
    }
    
    // 埋点key
    var logKey: String {
        switch self {
        case .normal:
            return "General_Member_Membership_Privileges_Page"
        case .gold:
            return "Gold_Member_Membership_Privileges_Page"
        case .platinum:
            return "Platinum_Member_Membership_Privileges_Page"
        case .diamond:
            return "Diamond_Member_Membership_Privileges_Page"
        }
    }

    // 示例：获取会员等级对应的权益
    func benefits() -> [String] {
        switch self {
        case .normal:
            return ["基础权益", "普通折扣"]
        case .gold:
            return ["基础权益", "普通折扣", "专属客服"]
        case .platinum:
            return ["基础权益", "高级折扣", "专属客服", "优先服务"]
        case .diamond:
            return ["基础权益", "高级折扣", "专属客服", "优先服务", "VIP活动"]
        }
    }

    func bgIconTitle() -> String {
        switch self {
        case .normal:
            return "member_center_bg_normal"
        case .gold:
            return "member_center_bg_gold"
        case .platinum:
            return "member_center_bg_platinum"
        case .diamond:
            return "member_center_bg_diamond"
        }
    }

    func cardIconTitle() -> String {
        switch self {
        case .normal:
            return "member_center_card_normal"
        case .gold:
            return "member_center_card_gold"
        case .platinum:
            return "member_center_card_platinum"
        case .diamond:
            return "member_center_card_diamond"
        }
    }
}
