//
//  YHHeadImageViewController.swift
//  galaxy
//
//  Created by EDY on 2024/7/4.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHHeadImageViewController: YHBaseViewController {
    typealias CancelClippedHandlerBlock = () -> Void
    typealias SuccessClippedHandlerBlock = (_ image: UIImage) -> Void
    // MARK: Public
    public var cancelClippedHandler: CancelClippedHandlerBlock?
    public var successClippedHandler: SuccessClippedHandlerBlock?
    
    public func setBaseImg(_ baseImg: UIImage, resultImgSize: CGSize, type: YHClipperType) {
        self.baseImg = baseImg
        self.resultImgSize = resultImgSize
        clipperView = YHClipperView(frame: CGRect(x: 0, y: (isIphoneX() ? 88:64), width: KScreenWidth, height: KScreenHeight - k_Height_safeAreaInsetsBottom() - 54 - (isIphoneX() ? 88:64)))
        clipperView?.resultImgSize = resultImgSize
        clipperView?.baseImg = baseImg
        clipperView?.type = type
        self.view.addSubview(clipperView!)
        self.view.sendSubviewToBack(clipperView!)
    }

    private var baseImg: UIImage!
    private var resultImgSize: CGSize!
    // MARK: Private
    private var clipperView: YHClipperView?
    private var cannalButton: UIButton!
    private var sureButton: UIButton!
    
    override func viewDidLoad() {
        super.viewDidLoad()
        view.backgroundColor = .black
        // Do any additional setup after loading the view.
        setView()
        gk_navigationBar.isHidden = true
    }
    
    func setView() {
        let bottomView = {
            let bottom = UIView()
            bottom.backgroundColor = .black
            return bottom
        }()
        view.addSubview(bottomView)
        bottomView.snp.makeConstraints { make in
            make.left.right.bottom.equalToSuperview()
            make.height.equalTo(k_Height_safeAreaInsetsBottom() + 64)
        }
        
        sureButton = {
            let button = UIButton(type: .custom)
            button.titleLabel?.font = UIFont.PFSC_M(ofSize: 15)
            button.backgroundColor = UIColor.brandMainColor
            button.contentHorizontalAlignment = .center
            button.setTitle("确认", for: .normal)
            button.setTitleColor( UIColor(hex: 0xffffff), for: .normal)
            button.layer.cornerRadius = kCornerRadius3
            button.clipsToBounds = true
            button.addTarget(self, action: #selector(sureBtnClick), for: .touchUpInside)
            return button
        }()
        view.addSubview(sureButton)
        sureButton.snp.makeConstraints { make in
            make.right.equalTo(-16)
            make.bottom.equalTo(-10 - k_Height_safeAreaInsetsBottom())
            make.height.equalTo(44)
            make.width.equalTo(93)
        }
        
        cannalButton = {
            let button = UIButton(type: .custom)
            button.titleLabel?.font = UIFont.PFSC_M(ofSize: 15)
            button.contentHorizontalAlignment = .left
            button.setTitle("取消", for: .normal)
            button.setTitleColor( UIColor(hex: 0xffffff), for: .normal)
            button.addTarget(self, action: #selector(cannalBtnClick), for: .touchUpInside)
            return button
        }()
        view.addSubview(cannalButton)
        cannalButton.snp.makeConstraints { make in
            make.centerY.equalTo(sureButton.snp.centerY)
            make.left.equalTo(30)
            make.height.equalTo(44)
            make.width.equalTo(60)
        }
    }
    
    override func navigationShouldPop() -> Bool {
        return false
    }
    
    @objc private func cannalBtnClick() {
        if cancelClippedHandler != nil {
            cancelClippedHandler!()
        }
        clipperView?.isHidden = true
        self.navigationController?.popViewController()
    }
    
    @objc private func sureBtnClick() {
        guard let clippedImg = self.clipperView?.clipImg() else { return }
        if successClippedHandler != nil {
            successClippedHandler!(clippedImg)
        }
        clipperView?.isHidden = true
        self.navigationController?.popViewController()
    }
    
    override func viewWillAppear(_ animated: Bool) {
        super.viewWillAppear(animated)
        navigationController?.isNavigationBarHidden = false
    }

}
