//
//  YHAboutUsAdvantageCell.swift
//  galaxy
//
//  Created by edy on 2024/1/6.
//  Copyright © 2024 www.davidhuang.com. All rights reserved.
//

import UIKit

class YHAboutUsAdvantageCell: UICollectionViewCell {
    
    static let cellReuseIdentifier = "YHAboutUsAdvantageCell"
    
    var advantateItem: AboutAdvantageItem? {
        didSet {
            
            if let advantateItem = advantateItem {
                iconImgView.image = UIImage(named: advantateItem.iconName)
                titleLabel.text = advantateItem.title
                detailLabel.text = advantateItem.detail
            }
        }
    }

    lazy var iconImgView: UIImageView = {
        let icon = UIImageView(image: UIImage(named: "mine_manager"))
        return icon
    }()
    
    lazy var titleLabel: UILabel = {
        let label = UILabel()
        label.textColor = UIColor.mainTextColor
        label.textAlignment = .center
        label.font = UIFont.PFSC_B(ofSize: 14)
        return label
    }()
    
    lazy var detailLabel: UILabel = {
        let label = UILabel()
        label.textColor = UIColor.mainTextColor50
        label.numberOfLines = 0
        label.textAlignment = .center
        label.font = UIFont.PFSC_R(ofSize: 11)
        return label
    }()
    
    required init?(coder: NSCoder) {
        super.init(coder: coder)
    }
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        setupUI()
    }
    
    func setupUI() {
        
        contentView.backgroundColor = UIColor.init(hex: 0xF8FAFB)
        contentView.layer.cornerRadius = 4
        contentView.clipsToBounds = true
        
        contentView.addSubview(iconImgView)
        contentView.addSubview(titleLabel)
        contentView.addSubview(detailLabel)
        
        iconImgView.snp.makeConstraints { make in
            make.top.equalTo(contentView).offset(20)
            make.centerX.equalTo(contentView)
            make.width.height.equalTo(43)
        }
        
        titleLabel.snp.makeConstraints { make in
            make.centerX.equalTo(contentView)
            make.height.equalTo(18)
            make.top.equalTo(iconImgView.snp.bottom).offset(12)
        }
        
        detailLabel.snp.makeConstraints { make in
            make.left.equalTo(contentView).offset(15)
            make.right.equalTo(contentView).offset(-15)
            make.top.equalTo(titleLabel.snp.bottom).offset(6)
            make.bottom.equalTo(contentView).offset(-5)
        }
    }
}
