//
//  YHMembershipGrowthGuideView.swift
//  galaxy
//
//  Created by alexzzw on 2025/2/24.
//  Copyright © 2025 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHMembershipGrowthGuideView: UIView {
    var closeButtonEvent: (() -> Void)?
    
    private lazy var topTitleLabel: UILabel = {
        let label = UILabel()
        label.text = "会员及成长值说明"
        label.font = .PFSC_B(ofSize: 17)
        label.textColor = .mainTextColor
        label.textAlignment = .center
        return label
    }()
    
    private lazy var closeButton: UIButton = {
        let button = UIButton(type: .custom)
        button.setImage(UIImage(named: "service_card_close"), for: .normal)
        button.addTarget(self, action: #selector(closeButtonClicked), for: .touchUpInside)
        return button
    }()
    
    private lazy var topLineView: UIView = {
        let view = UIView()
        view.backgroundColor = UIColor(hexString: "#E9ECF0")
        return view
    }()

    lazy var blackMaskView: UIView = {
        let view = UIView()
        view.backgroundColor = UIColor(hex: 0x0F1214, alpha: 0.5)
        return view
    }()

    lazy var whiteContentView: UIView = {
        let view = UIView()
        view.backgroundColor = .white
        return view
    }()

    lazy var myScrollView: UIScrollView = {
        let view = UIScrollView()
        view.backgroundColor = .clear
        view.showsVerticalScrollIndicator = false
        view.showsHorizontalScrollIndicator = false
        view.isScrollEnabled = true
        view.isUserInteractionEnabled = true
        return view
    }()

    lazy var bkgImageV: UIImageView = {
        let imageV = UIImageView()
        imageV.image = UIImage(named: "membership_growth_guide")
        imageV.contentMode = .scaleAspectFit
        imageV.clipsToBounds = true
        return imageV
    }()

    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }

    override init(frame: CGRect) {
        super.init(frame: frame)
        setupUI()
    }
}

extension YHMembershipGrowthGuideView {
    static func sheetView() -> YHMembershipGrowthGuideView {
        let view = YHMembershipGrowthGuideView(frame: UIScreen.main.bounds)
        return view
    }

    func show() {
        UIApplication.shared.yhKeyWindow()?.addSubview(self)

        UIView.animate(withDuration: 0.5) {
            let whiteHeight = KScreenHeight - 120
            self.whiteContentView.frame = CGRect(x: 0, y: KScreenHeight - whiteHeight, width: KScreenWidth, height: whiteHeight)
        }
    }

    @objc func dismiss() {
        removeFromSuperview()
    }
}

private extension YHMembershipGrowthGuideView {
    @objc private func closeButtonClicked() {
        dismiss()
        closeButtonEvent?()
    }
    
    func setupUI() {
        addSubview(blackMaskView)
        addSubview(whiteContentView)

        let corner = UIRectCorner(rawValue: UIRectCorner.topLeft.rawValue | UIRectCorner.topRight.rawValue)
        let path = UIBezierPath(roundedRect: bounds, byRoundingCorners: corner, cornerRadii: CGSize(width: kCornerRadius6, height: kCornerRadius6))
        let layer = CAShapeLayer()
        layer.frame = whiteContentView.bounds
        layer.path = path.cgPath
        whiteContentView.layer.mask = layer
        whiteContentView.clipsToBounds = true

        blackMaskView.snp.makeConstraints { make in
            make.edges.equalToSuperview()
        }

        let whiteHeight = KScreenHeight - 120
        whiteContentView.frame = CGRect(x: 0, y: KScreenHeight, width: KScreenWidth, height: whiteHeight)
        whiteContentView.addSubview(topTitleLabel)
        whiteContentView.addSubview(closeButton)
        whiteContentView.addSubview(topLineView)
        
        topTitleLabel.snp.makeConstraints { make in
            make.centerX.equalToSuperview()
            make.top.equalToSuperview().offset(16)
        }
        
        closeButton.snp.makeConstraints { make in
            make.centerY.equalTo(topTitleLabel)
            make.right.equalToSuperview().offset(-20)
            make.width.height.equalTo(24)
        }
        
        topLineView.snp.makeConstraints { make in
            make.top.equalToSuperview().offset(52)
            make.left.equalToSuperview().offset(20)
            make.right.equalToSuperview().offset(-20)
            make.height.equalTo(1)
        }
        
        whiteContentView.addSubview(myScrollView)
        myScrollView.snp.makeConstraints { make in
            make.top.equalToSuperview().offset(73)
            make.left.equalToSuperview()
            make.width.equalTo(KScreenWidth)
            make.height.equalTo(whiteHeight - 73)
        }

        if let _ = UIImage(named: "membership_growth_guide") {
            let radio = 558.0 / 333.0
            let margin = (375.0 - 333.0) / 2.0
            myScrollView.addSubview(bkgImageV)
            bkgImageV.snp.makeConstraints { make in
                make.top.equalToSuperview()
                make.left.equalToSuperview().offset(margin)
                make.width.equalTo((KScreenWidth - 2 * margin))
                make.height.equalTo((KScreenWidth - 2 * margin) * radio)
            }
            myScrollView.contentSize = CGSize(width: KScreenWidth, height: (KScreenWidth - 2 * margin) * radio + 34)
        }
    }
}
