//
//  YHMyFunctionGroup2Cell.swift
//  galaxy
//
//  Created by Dufet on 2025/2/13.
//  Copyright © 2025 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHMyFunctionGroup2Cell: UITableViewCell {
    
    static let cellReuseIdentifier = "YHMyFunctionGroup2Cell"
    static let itemHeight = 74.0
    
    var clickItem: ((PersonalModuleItem) -> Void)?

    func updateGroup(_ group: YHFunctionGroupInfo) {
        groupArr = group.arr
    }

    var groupArr: [PersonalModuleItem] = [] {
        didSet {
            let countPerRow = 2
            let rowHeight = Self.itemHeight
            var listHeight = rowHeight
            if groupArr.count%countPerRow == 0 {
                listHeight = rowHeight * Double(groupArr.count/countPerRow)
            } else {
                listHeight = rowHeight * Double(groupArr.count/countPerRow + 1)
            }
            collectionView.snp.updateConstraints { make in
                make.height.equalTo(listHeight)
            }
            collectionView.reloadData()
            self.setNeedsLayout()
            self.layoutIfNeeded()
        }
    }

    lazy var collectionView: UICollectionView = {
        
        let flowLayout = UICollectionViewFlowLayout()
        flowLayout.minimumInteritemSpacing = 10.0
        flowLayout.minimumLineSpacing = 0.0
        flowLayout.scrollDirection = .vertical
        
        let collectView = UICollectionView(frame: .zero, collectionViewLayout: flowLayout)
        collectView.backgroundColor = .clear
        collectView.delegate = self
        collectView.dataSource = self
        collectView.register(YHMyFunctionGroupItem2Cell.self, forCellWithReuseIdentifier: YHMyFunctionGroupItem2Cell.cellReuseIdentifier)
        collectView.contentInset = .zero
        collectView.showsVerticalScrollIndicator = false
        collectView.contentInsetAdjustmentBehavior = .never
        return collectView
    }()
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        setupUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func setupUI() {
        
        self.selectionStyle = .none
        self.backgroundColor = .clear
        contentView.backgroundColor = .clear
        contentView.addSubview(collectionView)
        
        collectionView.snp.makeConstraints { make in
            make.top.equalTo(16)
            make.bottom.equalTo(-16)
            make.left.right.equalToSuperview()
            make.height.equalTo(Self.itemHeight)
        }
    }
}

extension YHMyFunctionGroup2Cell: UICollectionViewDelegate, UICollectionViewDataSource, UICollectionViewDelegateFlowLayout {
    
    // 返回单元格数量
    func collectionView(_ collectionView: UICollectionView, numberOfItemsInSection section: Int) -> Int {
        
        return groupArr.count
    }
    
    // 返回每个单元格的大小
    func collectionView(_ collectionView: UICollectionView, layout collectionViewLayout: UICollectionViewLayout, sizeForItemAt indexPath: IndexPath) -> CGSize {
        
        let width = floor((KScreenWidth-20.0*2.0-10.0)/2.0)
        return CGSize(width: width, height: Self.itemHeight)
    }
    
    // 返回自定义单元格
    func collectionView(_ collectionView: UICollectionView, cellForItemAt indexPath: IndexPath) -> UICollectionViewCell {
        guard let cell = collectionView.dequeueReusableCell(withReuseIdentifier: YHMyFunctionGroupItem2Cell.cellReuseIdentifier, for: indexPath) as? YHMyFunctionGroupItem2Cell else { return UICollectionViewCell()}
        if 0 <= indexPath.item && indexPath.item < groupArr.count {
            let item: PersonalModuleItem = groupArr[indexPath.item]
            cell.updateItem(item)
        }
        return cell
    }
    
    func collectionView(_ collectionView: UICollectionView, didSelectItemAt indexPath: IndexPath) {
        if 0 <= indexPath.item && indexPath.item < groupArr.count {
            let item: PersonalModuleItem = groupArr[indexPath.item]
            if let click = clickItem {
                click(item)
            }
        }
    }
}
