//
//  YHVipLevelRightHeaderView.swift
//  galaxy
//
//  Created by Dufet on 2025/2/24.
//  Copyright © 2025 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHVipLevelRightsModel {
    var type: YHUserVipLevel = .none
    var title: String = ""
    var num: Int = 0
    var isLock: Bool = false
    
    init(type: YHUserVipLevel, title: String, num: Int, isLock: Bool) {
        self.type = type
        self.title = title
        self.num = num
        self.isLock = isLock
    }
}

class YHVipLevelRightHeaderView: UIView, UIScrollViewDelegate {
    
    var level: YHMembershipLevel = .normal {
        didSet {
            var max = 0
            if level == .normal {
                max = 0
            } else if level == .gold {
                max = 1
            } else if level == .platinum {
                max = 2
            } else if level == .diamond {
                max = 3
            }
            for index in 0...3 {
                guard let itemV = self.scrollView.viewWithTag(self.baseTag+index) as? YHVipLevelRightHeaderItemView else { return }
                itemV.lockImgV.isHidden = index <= max
            }
        }
    }
    let baseTag = 9527
    var arr: [YHVipLevelRightsModel] = [
        YHVipLevelRightsModel(type: .none, title: "普通会员", num: 5, isLock: false),
        YHVipLevelRightsModel(type: .gold, title: "黄金会员", num: 7, isLock: true),
        YHVipLevelRightsModel(type: .platinum, title: "铂金会员", num: 8, isLock: true),
        YHVipLevelRightsModel(type: .diamond, title: "钻石会员", num: 13, isLock: true)
    ]
    
    var offSetXChange: ((CGFloat) -> Void)?
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        createUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    lazy var scrollView: UIScrollView = {
        let v = UIScrollView()
//        v.isPagingEnabled = true
        v.bounces = false
        v.contentInsetAdjustmentBehavior = .never
        v.showsHorizontalScrollIndicator = false
        v.delegate = self
        return v
    }()
    
    lazy var levelView: UIView = {
        let v = UIView()
        let label = UILabel()
        label.text = "等级特权"
        label.textColor = .mainTextColor
        label.textAlignment = .center
        label.font = .PFSC_M(ofSize: 14)
        v.addSubview(label)
        label.snp.makeConstraints { make in
            make.centerY.equalToSuperview()
            make.centerX.equalToSuperview()
            make.height.equalTo(20)
        }
        return v
    }()
    
    lazy var topLineView: UIView = {
        let v = UIView()
        v.backgroundColor = .init(hex: 0xE9ECF0)
        return v
    }()
    
    func createUI() {
        
        self.addSubview(levelView)
        self.addSubview(scrollView)
        self.addSubview(topLineView)
        
        topLineView.snp.makeConstraints { make in
            make.left.right.top.equalToSuperview()
            make.height.equalTo(0.5)
        }
        levelView.snp.makeConstraints { make in
            make.left.top.bottom.equalToSuperview()
            make.width.equalTo(KScreenWidth/3.0)
        }

        scrollView.snp.makeConstraints { make in
            make.left.equalTo(levelView.snp.right)
            make.right.top.bottom.equalToSuperview()
        }

        let colorArr: [UIColor] = [.init(hex: 0x979EAF),
                                  .init(hex: 0xEFAF54),
                                  .init(hex: 0x8183AB),
                                  .init(hex: 0x15266B) ]
        
        var lastView: UIView?
        for (index, item) in arr.enumerated() {
            let v1 = UIView()
            v1.backgroundColor = colorArr[index]
            scrollView.addSubview(v1)
            v1.snp.makeConstraints { make in
                make.top.bottom.equalToSuperview()
                make.width.equalTo(KScreenWidth/3.0)
                make.height.equalTo(48)
                if let lastV = lastView {
                    make.left.equalTo(lastV.snp.right)
                } else {
                    make.left.equalToSuperview()
                }
                if index == arr.count-1 {
                    make.right.equalToSuperview()
                }
            }
            lastView = v1
            
            let item1V = YHVipLevelRightHeaderItemView(frame: .zero)
            item1V.tag = self.baseTag+index
            item1V.titleLabel.text = item.title
            item1V.numLabel.text = "\(item.num)项"
            v1.addSubview(item1V)
            item1V.snp.makeConstraints { make in
                make.centerY.equalToSuperview()
                make.centerX.equalToSuperview()
                make.height.equalTo(56)
            }
        }
        self.level = .normal
    }
    
    func scrollViewDidScroll(_ scrollView: UIScrollView) {
        offSetXChange?(scrollView.contentOffset.x)
    }
}

class YHVipLevelRightHeaderItemView: UIView {
    
    lazy var titleLabel: UILabel = {
        let label = UILabel()
        label.text = ""
        label.textColor = .white
        label.textAlignment = .center
        label.font = .PFSC_M(ofSize: 14)
        return label
    }()
    
    lazy var numLabel: UILabel = {
        let label = UILabel()
        label.text = ""
        label.textColor = .init(hex: 0xFFFFFF, alpha: 0.6)
        label.textAlignment = .center
        label.font = .PFSC_R(ofSize: 14)
        return label
    }()
    
    lazy var lockImgV: UIImageView = {
        let v = UIImageView(image: UIImage(named: "mine_vip_lock"))
        return v
    }()

    override init(frame: CGRect) {
        super.init(frame: frame)
        createUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func createUI() {
        
        self.addSubview(titleLabel)
        self.addSubview(numLabel)
        self.addSubview(lockImgV)
        
        titleLabel.snp.makeConstraints { make in
            make.left.equalToSuperview()
            make.centerY.equalToSuperview()
            make.width.equalTo(57)
        }
        
        lockImgV.snp.makeConstraints { make in
            make.left.equalTo(titleLabel.snp.right).offset(2)
            make.centerY.equalToSuperview()
            make.width.height.equalTo(16)
        }
        
        numLabel.snp.makeConstraints { make in
            make.left.equalTo(lockImgV.snp.right).offset(2)
            make.right.equalToSuperview()
            make.centerY.equalToSuperview()
        }
    }

}
