//
//  YHVipLevelRightTitleCell.swift
//  galaxy
//
//  Created by Dufet on 2025/2/24.
//  Copyright © 2025 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHVipLevelRightTitleCell: UITableViewCell {

    static let cellReuseIdentifier = "YHVipLevelRightTitleCell"
    
    lazy var titleLabel: UILabel = {
        let label = UILabel()
        label.text = ""
        label.textColor = .mainTextColor
        label.textAlignment = .center
        label.font = .PFSC_R(ofSize: 12)
        return label
    }()
    
    lazy var lineView: UIView = {
        let v = UIView()
        v.backgroundColor = .init(hex: 0xE9ECF0)
        return v
    }()

    required init?(coder: NSCoder) {
        super.init(coder: coder)
    }
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        setupUI()
    }

    func setupUI() {
        
        self.backgroundColor = .clear
        self.selectionStyle = .none
        
        self.addSubview(titleLabel)
        self.addSubview(lineView)
        
        titleLabel.snp.makeConstraints { make in
            make.edges.equalToSuperview()
        }
        
        lineView.snp.makeConstraints { make in
            make.top.bottom.right.equalToSuperview()
            make.width.equalTo(0.5)
        }
    }
    
    func updateModel(_ model: YHVipLevelRightInfoModel) {
        
        titleLabel.text = model.title
        
        if model.type == .baseRightSection {
            titleLabel.textColor = .brandMainColor
            titleLabel.font = .PFSC_B(ofSize: 14)
            
        } else if model.type == .hightRightSection {
            titleLabel.textColor = .init(hex: 0xEDA43D)
            titleLabel.font = .PFSC_B(ofSize: 14)
            
        } else if model.type == .text {
            titleLabel.textColor = .mainTextColor
            titleLabel.font = .PFSC_R(ofSize: 12)
            
        } else if model.type == .own {
            titleLabel.textColor = .mainTextColor
            titleLabel.font = .PFSC_R(ofSize: 12)
        }
    }
}
