//
//  YHMakePlanBottomView.swift
//  galaxy
//
//  Created by EDY on 2025/3/28.
//  Copyright © 2025 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import AttributedString

class YHMakePlanBottomView: UIView {
    
    // MARK: - UI Elements
    private lazy var priceLabel: UILabel = {
       let label = UILabel()
        let a: ASAttributedString = .init("¥", .font(UIFont.PFSC_M(ofSize: 20)), .foreground(UIColor.mainTextColor))
        let b: ASAttributedString = .init("58999.00", .font(UIFont.PFSC_M(ofSize: 28)), .foreground(UIColor.mainTextColor))
        label.attributed.text = a + b
       return label
    }()
    
    lazy var priceButton: UIButton = {
        let label = UIButton()
        label.setImage(UIImage(named: "make_plan_up"), for: .normal)
        label.addTarget(self, action: #selector(handleAction), for: .touchUpInside)
        return label
    }()
    
    private lazy var actionButton: YHImageTextButton = {
        let button = YHImageTextButton(title: "去办理", image: UIImage(named: "make_plan_next"))
        button.setTitleColor(UIColor(hex: 0xffffff), for: .normal)
        button.titleLabel?.font = UIFont.PFSC_M(ofSize: 16)
        button.layer.cornerRadius = 2
        button.backgroundColor = UIColor.mainTextColor
        button.addTarget(self, action: #selector(nextAction), for: .touchUpInside)
        return button
    }()
    
    // MARK: - Properties
    
    var price: String = "" {
        didSet {
            let a: ASAttributedString = .init("¥", .font(UIFont(name: "D-DIN-PRO-Bold", size: 20) ?? UIFont()), .foreground(UIColor.mainTextColor))
            let b: ASAttributedString = .init("\(price.formattedPrice())", .font(UIFont(name: "D-DIN-PRO-Bold", size: 28) ?? UIFont()), .foreground(UIColor.mainTextColor))
            priceLabel.attributed.text = a + b
        }
    }
    
    var actionHandler: (() -> Void)?
    var nextHandler: (() -> Void)?

    // MARK: - Initialization
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        setupUI()
        setupConstraints()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    // MARK: - Setup
    
    private func setupUI() {
        backgroundColor = .white
        addSubview(priceLabel)
        addSubview(priceButton)
        addSubview(actionButton)
    }
    
    private func setupConstraints() {
        priceLabel.snp.makeConstraints { make in
            make.top.equalToSuperview().offset(20)
            make.left.equalToSuperview().offset(16)
            make.height.equalTo(28)
        }
        
        priceButton.snp.makeConstraints { make in
            make.left.equalTo(priceLabel.snp.right)
            make.width.height.equalTo(16)
            make.centerY.equalTo(priceLabel.snp.centerY)
        }
        
        actionButton.snp.makeConstraints { make in
            make.top.equalToSuperview().offset(9)
            make.right.equalToSuperview().offset(-16)
            make.width.equalTo(120)
            make.height.equalTo(46)
        }
        
        priceButton.YH_clickEdgeInsets = UIEdgeInsets(top: 10, left: 100, bottom: 10, right: 10)
    }
    
    // MARK: - Action
    
    @objc private func handleAction() {
        actionHandler?()
    }
    
    @objc private func nextAction() {
        nextHandler?()
    }
    // MARK: - Configuration
    
    func configure(price: String, actionText: String? = nil, actionHandler: (() -> Void)? = nil, nextHandler: (() -> Void)? = nil) {
        self.price = price
        if let actionText = actionText {
            actionButton.setTitle(actionText, for: .normal)
        }
        self.actionHandler = actionHandler
        self.nextHandler = nextHandler
    }
}
