//
//  YHMakePlanHeadView.swift
//  galaxy
//
//  Created by EDY on 2025/3/27.
//  Copyright © 2025 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHMakePlanHeadView: UIView {
    typealias Block = (Int) -> Void
    var block: Block?
    
    private lazy var centerImageView: UIImageView = {
        let view = UIImageView()
        view.image = UIImage(named: "plan_head_bg")
        return view
    }()

    private lazy var centerView: YHMakePlanStateHeadView = {
        let view = YHMakePlanStateHeadView()
        view.backgroundColor = .white
        view.layer.cornerRadius = 4
        return view
    }()
    
    private lazy var logoImageView: UIImageView = {
        let view = UIImageView()
        view.image = UIImage(named: "plan_head_logo")
        return view
    }()
    
    lazy var custtomView: YHMakePlanCusttomHeadView = {
        let view = YHMakePlanCusttomHeadView()
        view.backgroundColor = .clear
        view.block = { tag in
            self.block?(tag)
        }
        return view
    }()
    
    var dataSource: YHMakePlanScoreModel? {
        didSet {
            centerView.dataSource = dataSource
        }
    }
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        setUpView()
    }

    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }

    func update(type: YHGCApplicationType, name: String) {
       
    }

    private func setUpView() {
        addSubview(centerImageView)
        addSubview(centerView)
        addSubview(logoImageView)
        addSubview(custtomView)

        centerImageView.snp.makeConstraints { make in
            make.left.right.top.equalToSuperview()
            make.height.equalTo(333.fix)
        }

        logoImageView.snp.makeConstraints { make in
            make.centerX.equalToSuperview()
            make.height.equalTo(109)
            make.width.equalTo(272)
            make.top.equalTo(96)
        }
        
        centerView.snp.makeConstraints { make in
            make.left.equalTo(16)
            make.right.equalTo(-16)
            make.height.equalTo(133)
            make.top.equalTo(logoImageView.snp.bottom).offset(24)
        }
        
        custtomView.snp.makeConstraints { make in
            make.bottom.left.right.equalToSuperview()
            make.height.equalTo(44)
        }
    }
}
