//
//  YHPlanAnalyzeInfoCell.swift
//  galaxy
//
//  Created by Dufet on 2025/3/26.
//  Copyright © 2025 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import AttributedString

class YHPlanAnalyzeInfoView: UIView {
    
    var desc: String = "" {
        didSet {
            if desc.isEmpty {
                descLabel.text = "—"
            } else {
                descLabel.text = desc
            }
        }
    }
    lazy var titleLabel: UILabel = {
        let lable = UILabel()
        lable.textColor = UIColor.mainTextColor
        lable.textAlignment = .left
        lable.font = UIFont.PFSC_M(ofSize: 15)
        lable.text = "当前情况"
        return lable
    }()
    
    lazy var descLabel: UILabel = {
        let lable = UILabel()
        lable.textColor = UIColor.init(hex: 0x6A7586)
        lable.textAlignment = .left
        lable.font = UIFont.PFSC_R(ofSize: 13)
        lable.numberOfLines = 0
        return lable
    }()
    
    lazy var lineView: UIView = {
        let v = UIView()
        v.backgroundColor = .init(hex: 0xF1E8E0)
        v.backgroundColor = .init(hex: 0xE9ECF0)
        return v
    }()
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        createUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func createUI() {
        backgroundColor = .clear
        self.addSubview(lineView)
        self.addSubview(titleLabel)
        self.addSubview(descLabel)
        
        titleLabel.snp.makeConstraints { make in
            make.left.equalTo(0)
            make.right.equalTo(-0)
            make.top.equalTo(0)
            make.height.equalTo(20)
        }
        
        lineView.snp.makeConstraints { make in
            make.height.equalTo(6)
            make.width.equalTo(60)
            make.left.equalTo(titleLabel)
            make.bottom.equalTo(titleLabel).offset(-2)
        }
        
        descLabel.snp.makeConstraints { make in
            make.left.equalTo(0)
            make.right.equalTo(-0)
            make.top.equalTo(titleLabel.snp.bottom).offset(4)
            make.bottom.equalToSuperview()
        }
    }
}

class YHPlanAnalyzeInfoCell: UITableViewCell {

    static let cellReuseIdentifier = "YHPlanAnalyzeInfoCell"

    var clickBlock: ((YHPlanProductModel) -> Void)?

    var model = YHPlanAnalyzeModel() {
        didSet {
            titleLabel.text = "\(model.getTitle())分析"
            
            let aa: ASAttributedString = .init("\(model.score)", .font(UIFont(name: "DINAlternate-Bold", size: 24)!), .foreground(UIColor.mainTextColor))
            let bb: ASAttributedString = .init("/5.0", .font(UIFont(name: "DINAlternate-Bold", size: 14)!), .foreground(UIColor.init(hex: 0x8993A2)))
            scoreLabel.attributed.text = aa+bb
            
            currentStateVeiw.desc = model.current_state
            requireVeiw.desc = model.hong_kong_policy
            suggestVeiw.desc = model.suggest
            products = model.solution_plan
            
        }
    }
    
    var products: [YHPlanProductModel] = [] {
        didSet {
            let isShowList = products.count > 0
            productListView.isHidden = !isShowList
            productListView.snp.remakeConstraints { make in
                make.left.equalTo(16)
                make.top.equalTo(suggestVeiw.snp.bottom).offset(isShowList ? 16 : 0)
                if !isShowList {
                    make.height.equalTo(0)
                }
                make.right.equalTo(-16)
                make.bottom.equalTo(-16)
            }
            productListView.products = products
            productListView.titleLabel.text = "增购以下产品可提升\(model.getTitle())联系"
            self.setNeedsLayout()
            self.layoutIfNeeded()
        }
    }
    
    lazy var whiteContentView: UIView = {
        let v = UIView()
        v.backgroundColor = .white
        v.layer.cornerRadius = 6.0
        v.clipsToBounds = true
        return v
    }()
    
    lazy var titleLabel: UILabel = {
        let lable = UILabel()
        lable.textColor = UIColor.mainTextColor
        lable.textAlignment = .left
        lable.font = UIFont.PFSC_B(ofSize: 18)
        lable.text = "分析"
        return lable
    }()
    
    lazy var scoreLabel: UILabel = {
        let lable = UILabel()
        lable.textAlignment = .right
        lable.font = UIFont.PFSC_M(ofSize: 15)
        let aa: ASAttributedString = .init("0.0", .font(UIFont(name: "DINAlternate-Bold", size: 24)!), .foreground(UIColor.mainTextColor))
        let bb: ASAttributedString = .init("/5.0", .font(UIFont(name: "DINAlternate-Bold", size: 14)!), .foreground(UIColor.init(hex: 0x8993A2)))
        lable.attributed.text = aa+bb
        return lable
    }()
    
    lazy var lineView: UIView = {
        let v = UIView()
        v.backgroundColor = UIColor.init(hex: 0xE9ECF0)
        return v
    }()
    
    lazy var currentStateVeiw: YHPlanAnalyzeInfoView = {
        let v = YHPlanAnalyzeInfoView(frame: .zero)
        v.titleLabel.text = "当前情况"
        return v
    }()
    
    lazy var requireVeiw: YHPlanAnalyzeInfoView = {
        let v = YHPlanAnalyzeInfoView(frame: .zero)
        v.titleLabel.text = "港府要求"
        return v
    }()
    
    lazy var suggestVeiw: YHPlanAnalyzeInfoView = {
        let v = YHPlanAnalyzeInfoView(frame: .zero)
        v.titleLabel.textColor = .init(hex: 0xAE6C32)
        v.lineView.backgroundColor = .init(hex: 0xF1E8E0)
        v.titleLabel.text = "银河建议"
        return v
    }()
    
    lazy var productListView: YHPlanProductListView = {
        let v = YHPlanProductListView(frame: .zero)
        v.clickBlock = { [weak self] model in
            guard let self = self else { return }
            self.clickBlock?(model)
        }
        v.isHidden = true
        return v
    }()
    
    required init?(coder: NSCoder) {
        super.init(coder: coder)
    }
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        setupUI()
    }
    
    func setupUI() {
        selectionStyle = .none
        backgroundColor = .clear
        contentView.backgroundColor = .clear
        contentView.addSubview(whiteContentView)
        whiteContentView.addSubview(titleLabel)
        whiteContentView.addSubview(scoreLabel)
        whiteContentView.addSubview(lineView)
        whiteContentView.addSubview(currentStateVeiw)
        whiteContentView.addSubview(requireVeiw)
        whiteContentView.addSubview(suggestVeiw)
        whiteContentView.addSubview(productListView)
        
        whiteContentView.snp.makeConstraints { make in
            make.left.equalTo(16)
            make.right.equalTo(-16)
            make.top.equalTo(0)
            make.bottom.equalTo(-16)
        }
        
        titleLabel.snp.makeConstraints { make in
            make.left.equalTo(16)
            make.top.equalTo(20)
            make.height.equalTo(25)
        }
        
        scoreLabel.snp.makeConstraints { make in
            make.right.equalTo(-16)
            make.top.equalTo(20)
            make.height.equalTo(25)
        }
        
        lineView.snp.makeConstraints { make in
            make.top.equalTo(titleLabel.snp.bottom).offset(12)
            make.left.equalTo(16)
            make.right.equalTo(-16)
            make.height.equalTo(0.5)
        }
        
        currentStateVeiw.snp.makeConstraints { make in
            make.left.equalTo(16)
            make.top.equalTo(lineView.snp.bottom).offset(16)
            make.right.equalTo(-16)
        }
        
        requireVeiw.snp.makeConstraints { make in
            make.left.equalTo(16)
            make.top.equalTo(currentStateVeiw.snp.bottom).offset(16)
            make.right.equalTo(-16)
        }
        
        suggestVeiw.snp.makeConstraints { make in
            make.left.equalTo(16)
            make.top.equalTo(requireVeiw.snp.bottom).offset(16)
            make.right.equalTo(-16)
        }
        
        productListView.snp.makeConstraints { make in
            make.left.equalTo(16)
            make.top.equalTo(suggestVeiw.snp.bottom).offset(0)
            make.height.equalTo(0)
            make.right.equalTo(-16)
            make.bottom.equalTo(-16)
        }
    }
}
