//
//  YHPlanCustomerCaseListLayout.swift
//  galaxy
//
//  Created by Dufet on 2025/3/26.
//  Copyright © 2025 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHPlanCustomerCaseListLayout: UICollectionViewLayout {
    
    // MARK: - 配置属性
    let cellWidth = floor((KScreenWidth-16.0*2.0-10.0)/2.0)
    let cellPadding = 10.0
    let cellGap = 10.0
    private var contentHeight: CGFloat = 0
    
    // MARK: - 缓存布局属性
    private var cachedAttributes = [UICollectionViewLayoutAttributes]()
    
    // MARK: - 布局计算
    override func prepare() {
        super.prepare()
        
        guard let collectionView = collectionView else { return }
        
        // 重置缓存和内容高度
        cachedAttributes.removeAll()
        contentHeight = 0.0
        var yOffset1: CGFloat = 0.0
        var yOffset2: CGFloat = 0.0
        
        // 计算每个item的布局属性
        for item in 0..<collectionView.numberOfItems(inSection: 0) {
            
            let indexPath = IndexPath(item: item, section: 0)
            
            // 获取item高度（通过委托）
            let height: CGFloat
            if let delegate = collectionView.delegate as? YHPlanCustomerCaseListLayoutDelegate {
                height = delegate.collectionView(collectionView, layout: self, sizeForItemAt: indexPath).height
            } else {
                height = 240 // 默认高度
            }
            
            // 计算frame
            let x = item % 2 == 0 ? 0.0 : cellWidth + cellPadding
            let y = item % 2 == 0 ? yOffset1 : yOffset2
            let frame = CGRect(x: x, y: y, width: cellWidth, height: height)
            
            // 创建布局属性
            let attributes = UICollectionViewLayoutAttributes(forCellWith: indexPath)
            attributes.frame = frame
            cachedAttributes.append(attributes)
            
            // 更新内容高度和yOffset
            if item % 2 == 0 {
                yOffset1 = y + height
            } else {
                yOffset2 = y + height
            }
        }
        contentHeight = max(yOffset1, yOffset2)
    }
    
    // MARK: - 布局属性提供
    override var collectionViewContentSize: CGSize {
        return CGSize(width: (KScreenWidth-16.0*2.0-10.0), height: contentHeight)
    }
    
    override func layoutAttributesForElements(in rect: CGRect) -> [UICollectionViewLayoutAttributes]? {
        return cachedAttributes.filter { $0.frame.intersects(rect) }
    }
    
    override func layoutAttributesForItem(at indexPath: IndexPath) -> UICollectionViewLayoutAttributes? {
        return cachedAttributes[indexPath.item]
    }
    
    // MARK: - 支持动态高度变化
    override func shouldInvalidateLayout(forBoundsChange newBounds: CGRect) -> Bool {
        guard let collectionView = collectionView else { return false }
        return !newBounds.size.equalTo(collectionView.bounds.size)
    }
}

// MARK: - 高度计算协议
protocol YHPlanCustomerCaseListLayoutDelegate: AnyObject {
    
    func collectionView(_ collectionView: UICollectionView, layout collectionViewLayout: UICollectionViewLayout, sizeForItemAt indexPath: IndexPath) -> CGSize
    
}
