//
//  YHPlanViewModel.swift
//  galaxy
//
//  Created by Dufet on 2025/3/25.
//  Copyright © 2025 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHPlanViewModel: YHBaseViewModel {

    var planListModel: YHPlanListModel = YHPlanListModel()
    
    func requetResignPlanInfo(callBackBlock: @escaping (_ success: Bool, _ error: YHErrorModel?) -> Void) {
        
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.ResignPlan.planlistApi
        
        _ = YHNetRequest.getRequest(url: strUrl) { [weak self] json, _ in
            guard let self = self else { return }
            
            // 1. json字符串 转 对象
            if json.code == 200 {
                guard let dic = json.data?.peel as? [String: Any], let result = YHPlanListModel.deserialize(from: dic) else {
                    callBackBlock(false, nil)
                    return
                }
                self.planListModel = result
                callBackBlock(true, nil)
            } else {
//                self.activityTravelModel = nil
                let error: YHErrorModel = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg)
                callBackBlock(false, error)
            }
        } failBlock: { err in
//            self.activityTravelModel = nil
            callBackBlock(false, err)
        }
    }
    
    func requetPDFUrl(_ sourceUrl: String, callBackBlock: @escaping ((String) -> Void)) {
        
        let strUrl = YHBaseUrlManager.shared.curOssURL() + "htmlToPdf/create"
        let params: [String: Any] = ["url": sourceUrl]
        _ = YHNetRequest.postRequest(url: strUrl, params: params) { [weak self] json, _ in
            
            // 1. json字符串 转 对象
            if json.code == 200 {
                guard let dic = json.data?.peel as? [String: Any], let url = dic["pdf_url"] as? String else {
                    callBackBlock("")
                    return
                }
                callBackBlock(url)
                
            } else {
                let error: YHErrorModel = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg)
                callBackBlock("")
            }
        } failBlock: { _ in
            callBackBlock("")
        }
    }
    
}
