//
//  YHAnalytics.swift
//  galaxy
//
//  Created by EDY on 2024/1/15.
//  Copyright © 2024 www.davidhuang.com. All rights reserved.
//

import UIKit
import SensorsAnalyticsSDK

class YHAnalytics {
    
    // 分析初始化
    static func analyticsStart(launchOptions: [UIApplication.LaunchOptionsKey: Any]?) {
        
#if DEBUG
        let options = SAConfigOptions.init(serverURL: YhConstant.SensorsAnalytics.urlForTest, launchOptions: launchOptions)
        // 开启log
        options.enableLog = false
        SensorsAnalyticsSDK.sharedInstance()?.set(["evn": "test"])
#elseif TESTENV
        let options = SAConfigOptions.init(serverURL: YhConstant.SensorsAnalytics.urlForTest, launchOptions: launchOptions)
        // 开启log
        options.enableLog = true
        SensorsAnalyticsSDK.sharedInstance()?.set(["evn": "test"])
        
#elseif UATENV
        let options = SAConfigOptions.init(serverURL: YhConstant.SensorsAnalytics.urlForRelease, launchOptions: launchOptions)
        // 开启log
        options.enableLog = false
        SensorsAnalyticsSDK.sharedInstance()?.set(["evn": "uat"])
#else
        let options = SAConfigOptions.init(serverURL: YhConstant.SensorsAnalytics.urlForRelease, launchOptions: launchOptions)
        // 开启log
        options.enableLog = false
        SensorsAnalyticsSDK.sharedInstance()?.set(["evn": "production"])
#endif
        /**
         * 其他配置，如开启可视化全埋点
         */
        
        // 开启全埋点
        options.autoTrackEventType = [.eventTypeAppStart, .eventTypeAppEnd, .eventTypeAppClick, .eventTypeAppViewScreen]
        options.enableVisualizedAutoTrack = true
        options.enableVisualizedProperties = true
        options.enableTrackPageLeave = true
        options.enableAutoTrackChildViewScreen = true
        options.enableJavaScriptBridge = true
        options.enableHeatMap = true
        options.enableSaveDeepLinkInfo = true
        // 初始化SDK
        SensorsAnalyticsSDK.start(configOptions: options)
        
        SensorsAnalyticsSDK.sharedInstance()?.set(["platform_type": "银河港生活APP"])
        SensorsAnalyticsSDK.sharedInstance()?.set(["system_mark": "APP_IOS"])
        
    }
    
    // 处理数据的Url
    static func handleSchemeUrl(_ url: URL) -> Bool? {
        return SensorsAnalyticsSDK.sharedInstance()?.handleSchemeUrl(url)
    }
    
    // 立即上报
    static func flush() {
        SensorsAnalyticsSDK.sharedInstance()?.flush()
    }
}

// 统计事件，统计时长
extension YHAnalytics {
    // 统计事件名
    static func track(_ event: String, properties: [AnyHashable: Any]? = [:]) {
        SensorsAnalyticsSDK.sharedInstance()?.track(event, withProperties: properties)
    }
    
    // 统计时长 开始
    static func timeStrat(_ event: String) {
        SensorsAnalyticsSDK.sharedInstance()?.trackTimerStart(event)
    }
    
    // 统计时长 暂停
    static func timePause(_ event: String) {
        SensorsAnalyticsSDK.sharedInstance()?.trackTimerPause(event)
    }
    
    // 统计时长 继续
    static func timeResume(_ event: String) {
        SensorsAnalyticsSDK.sharedInstance()?.trackTimerResume(event)
    }
    
    // 统计时长 结束
    static func timeEnd(_ event: String, properties: [AnyHashable: Any]? = [:]) {
        SensorsAnalyticsSDK.sharedInstance()?.trackTimerEnd(event, withProperties: properties)
    }
    
    static func login(_ id: String) {
//        SensorsAnalyticsSDK.sharedInstance()?.login(id, withProperties: ["iOS":UIDevice.appVersion()])
//        SensorsAnalyticsSDK.sharedInstance()?.login(id, withProperties: ["iOS":UIDevice.appVersion()])
        
        SensorsAnalyticsSDK.sharedInstance()?.login(id)
        
        SensorsAnalyticsSDK.sharedInstance()?.flush()
    }
    
    static func loginout() {
        SensorsAnalyticsSDK.sharedInstance()?.logout()
        
        SensorsAnalyticsSDK.sharedInstance()?.flush()
    }
    
    static func appInstall() {
        SensorsAnalyticsSDK.sharedInstance()?.trackAppInstall()
    }
}
