//
//  Array+Extension.swift
//  galaxy
//
//  Created by davidhuangA on 2023/12/28.
//  Copyright © 2023 www.davidhuang.com. All rights reserved.
//

import Foundation

// 字符串是否为空(空的标准是nil或[])
func isEmptyArray(_ array: [Any]?) -> Bool {
    if let array = array, array.count > 0 {
        return false
    }
    return true
}

extension Array {
    /// 数组转json字符串
    func yh_toJSONString() -> String? {
        if !JSONSerialization.isValidJSONObject(self) {
            return nil
        }
        
        do {
            let data = try JSONSerialization.data(withJSONObject: self, options: [])
            let json = String(data: data, encoding: String.Encoding.utf8)
            return json
        } catch {
            return nil
        }
    }
}
