//
//  UILable-Extension.swift
//  BaiSiSMApp
//
//  Created by davidhuang on 2022/11/16.
//  Copyright © 2022 www.davidhuang.com. All rights reserved.
//

import UIKit

extension UILabel {
    public class func createBsTagLabel() -> UILabel {
        let temp = UILabel()
        temp.textColor = UIColor(hexString: "#333333", transparency: 0.45)
        temp.textAlignment = .center
        temp.font = UIFont.PFSC_M(ofSize: 10)
        temp.backgroundColor = UIColor(hexString: "#333333", transparency: 0.04)
        temp.layer.cornerRadius = 2
        temp.clipsToBounds = true
        return temp
    }
    
    public class func label(text: String, font: UIFont, color: UIColor, numberOfLines: Int = 0, alignment: NSTextAlignment = .left) -> UILabel {
        let label = UILabel()
        label.text = text
        label.font = font
        label.textColor = color
        label.numberOfLines = numberOfLines
        label.textAlignment = alignment
        return label
    }
    
    convenience init(text: String, font: UIFont, color: UIColor, numberOfLines: Int = 0, alignment: NSTextAlignment = .left) {
        self.init()
        self.text = text
        self.font = font
        self.textColor = color
        self.numberOfLines = numberOfLines
        self.textAlignment = alignment
    }
    
    var requiredWidth: CGFloat {
        let label = UILabel(frame: CGRect(x: 0, y: 0, width: CGFloat.greatestFiniteMagnitude, height: frame.height))
        label.numberOfLines = 0
        label.lineBreakMode = NSLineBreakMode.byWordWrapping
        label.font = font
        label.text = text
        label.attributedText = attributedText
        label.sizeToFit()
        return label.frame.width
    }
    
    var requiredHeight: CGFloat {
        let label = UILabel(frame: CGRect(x: 0, y: 0, width: frame.width, height: CGFloat.greatestFiniteMagnitude))
        label.numberOfLines = 0
        label.lineBreakMode = NSLineBreakMode.byWordWrapping
        label.font = font
        label.text = text
        label.attributedText = attributedText
        label.sizeToFit()
        return label.frame.height
    }
}
