//
//  UIView+Extension.swift
//  Example
//
//  Created by QuintGao on 2022/3/21.
//  Copyright © 2022 QuintGao. All rights reserved.
//

import Foundation
import QuartzCore

extension UIView {
    
    // 注销view的控件
    func resignAllFirstResponders() {
        // 递归遍历视图控制器中的所有视图
        func resignFirstResponderForView(_ view: UIView) {
            if view.isFirstResponder {
                view.resignFirstResponder()
            }
            
            // 遍历子视图
            for subview in view.subviews {
                resignFirstResponderForView(subview)
            }
        }
        // 从根视图开始递归
        resignFirstResponderForView(self)
    }
    
    // 添加银河渐变色 //从左到右
    func addYinHeGradualLayer() {
        let gradientLayer = CAGradientLayer()
        gradientLayer.colors = UIColor.arrBrandGradaterColors.map(\.cgColor)
        gradientLayer.locations = [0, 1.0]
        gradientLayer.startPoint = CGPoint(x: 0.12, y: 0.25)
        gradientLayer.endPoint = CGPoint(x: 0.38, y: 0.25)
        gradientLayer.frame = bounds
        gradientLayer.zPosition = -1
        layer.addSublayer(gradientLayer)
    }
    
    func image(with colors: [Any]) -> UIImage? {
        addYinHeGradualLayer()
        return convertToImage()
    }
    
    func convertToImage() -> UIImage? {
        let size = self.bounds.size
        if size.width <= 0 || size.height <= 0 { return nil }
        UIGraphicsBeginImageContextWithOptions(size, false, UIScreen.main.scale)
        guard let context = UIGraphicsGetCurrentContext() else { return nil }
        self.layer.render(in: context)
        let image = UIGraphicsGetImageFromCurrentImageContext()
        UIGraphicsEndImageContext()
        return image
    }
    
    // 画虚线
    func drawBorderDottedLine(width: CGFloat, length: CGFloat, space: CGFloat, cornerRadius: CGFloat, color: UIColor) {
          self.layer.cornerRadius = cornerRadius
          let borderLayer =  CAShapeLayer()
          borderLayer.bounds = self.bounds
          
          borderLayer.position = CGPoint(x: self.bounds.midX, y: self.bounds.midY)
          borderLayer.path = UIBezierPath(roundedRect: borderLayer.bounds, cornerRadius: cornerRadius).cgPath
          borderLayer.lineWidth = width
          // 虚线边框---小边框的长度
          borderLayer.lineDashPattern = [length, space]  as [NSNumber]?
          // 前边是虚线的长度，后边是虚线之间空隙的长度
          borderLayer.lineDashPhase = 0.1
          // 实线边框
          
          borderLayer.fillColor = UIColor.clear.cgColor
          borderLayer.strokeColor = color.cgColor
          self.layer.addSublayer(borderLayer)
    }
    
    // 任意切圆角 eg:UIRectCorner(rawValue: (UIRectCorner.topRight.rawValue) | (UIRectCorner.bottomRight.rawValue)
    @discardableResult
    public func createCorner(_ cornerRadii: CGSize, _ roundingCorners: UIRectCorner) -> CAShapeLayer {
        let path = UIBezierPath(roundedRect: bounds, byRoundingCorners: roundingCorners, cornerRadii: cornerRadii)
        let layer = CAShapeLayer()
        layer.frame = bounds
        layer.path = path.cgPath
        self.layer.mask = layer
        return layer
    }
    
    @discardableResult
    public func createRoundedCornersAndBorder(corners: UIRectCorner, radii: CGSize, lineWidth: CGFloat?, lineColor: CGColor?) -> [CAShapeLayer] {
        var shapeLayers: [CAShapeLayer] = []
        let path = UIBezierPath(roundedRect: bounds, byRoundingCorners: corners, cornerRadii: radii)
        let shape = CAShapeLayer()
        shape.path = path.cgPath
        layer.mask = shape
        shapeLayers.append(shape)
        if let lineWidth = lineWidth, let lineColor = lineColor {
            let bordLayer = CAShapeLayer()
            bordLayer.lineWidth = lineWidth
            bordLayer.strokeColor = lineColor
            bordLayer.fillColor = UIColor.clear.cgColor
            bordLayer.path = path.cgPath
            layer.insertSublayer(bordLayer, at: 0)
            shapeLayers.append(bordLayer)
        }
        return shapeLayers
    }

}
