//
//  YHHUDProgressView.swift
//  PKHUD Demo
//
//  Created by ahao on 2018/4/19.
//  Copyright © 2018年 NSExceptional. All rights reserved.
//

import UIKit
import PKHUD

class YHHUDProgressView: YHHUDSquareBaseView, PKHUDAnimating {

    public init(title: String? = nil) {
        super.init(image: UIImage(named: "float_icon_loading"), title: title)
    }
    
    public required init?(coder aDecoder: NSCoder) {
        super.init(coder: aDecoder)
    }
    
    public func startAnimation() {
        imageView.layer.add(PKHUDAnimation.discreteRotation, forKey: "progressAnimation")
    }
    
    public func stopAnimation() {
        imageView.layer.removeAnimation(forKey: "progressAnimation")
    }

}
