//
//  YHVisaRenewalGuideIndentCell.swift
//  galaxy
//
//  Created by alexzzw on 2024/10/10.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHVisaRenewalGuideIndentCell: UITableViewCell {

    static let cellReuseIdentifier = "YHVisaRenewalGuideIndentCell"
    private let infoTitleLabelHorizontalOffset: CGFloat = 5
    private let infoTitleLabelToDetail: CGFloat = 4
    
    private lazy var subContainerView: YHBaseDynamicCornerRadiusView = {
        let view = YHBaseDynamicCornerRadiusView(cornerRadius: 2, corner: .allCorners)
        view.backgroundColor = UIColor(hex: 0xF4F6FA)
        return view
    }()
    
    private lazy var infoTitleLabel: UILabel = {
        let label = UILabel()
        label.textAlignment = .center
        label.font = .PFSC_M(ofSize: 13)
        label.textColor = .brandMainColor
        return label
    }()
    
    private lazy var infoDetailLabel: UILabel = {
        let label = UILabel()
        label.font = .PFSC_R(ofSize: 13)
        label.textColor = .mainTextColor70
        label.numberOfLines = 0
        label.lineBreakMode = .byCharWrapping
        return label
    }()
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        setupUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func setupCellInfo(title: String, detail: String) {
        infoTitleLabel.text = title
        infoTitleLabel.sizeToFit()
        subContainerView.sizeToFit()
        let paragraphStyle = NSMutableParagraphStyle()
        // 设置首行缩进量，单位为points
        paragraphStyle.firstLineHeadIndent = infoTitleLabel.bounds.size.width + infoTitleLabelHorizontalOffset * 2 + infoTitleLabelToDetail
        paragraphStyle.headIndent = 0
        paragraphStyle.lineHeightMultiple = 1.07
        let attributedText = NSAttributedString(
            string: detail,
            attributes: [NSAttributedString.Key.paragraphStyle: paragraphStyle]
        )
        infoDetailLabel.attributedText = attributedText
    }

}

extension YHVisaRenewalGuideIndentCell {
    private func setupUI() {
        selectionStyle = .none
        backgroundColor = .clear
        contentView.addSubview(subContainerView)
        subContainerView.addSubview(infoTitleLabel)
        contentView.addSubview(infoDetailLabel)
        subContainerView.snp.makeConstraints { make in
            make.top.equalToSuperview().offset(12)
            make.left.equalToSuperview().offset(20)
        }
        
        infoTitleLabel.snp.makeConstraints { make in
            make.left.equalToSuperview().offset(infoTitleLabelHorizontalOffset)
            make.right.equalToSuperview().offset(-infoTitleLabelHorizontalOffset)
            make.top.bottom.equalToSuperview()
        }
        
        infoDetailLabel.snp.makeConstraints { make in
            make.top.equalTo(subContainerView)
            make.left.equalTo(subContainerView)
            make.right.lessThanOrEqualToSuperview().offset(-20)
            make.bottom.equalToSuperview()
        }
    }
}
