//
//  YHGCEducationCerUploadCell.swift
//  galaxy
//
//  Created by Dufet on 2024/11/13.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import AttributedString

class YHGCEducationCerUploadCell: UITableViewCell {

    static let cellReuseIdentifier = "YHGCEducationCerUploadCell"
    
    lazy var titleLabel: UILabel = {
        let label = UILabel()
        let aa: ASAttributedString = .init("学历证件(选填)", .font(UIFont.PFSC_M(ofSize: 17)), .foreground(UIColor.mainTextColor))
        label.attributed.text = aa
        return label
    }()
    
    private lazy var topLine: UIView = {
        let view = UIView()
        view.backgroundColor = UIColor.init(hex: 0xE9ECF0)
        return view
    }()
    
    lazy var tipsLabel: UILabel = {
        let label = UILabel()
        label.numberOfLines = 0
        let aa: ASAttributedString = .init("备注：为了进一步确认您的具体信息，如有相关", .font(UIFont.PFSC_R(ofSize: 13)), .foreground(UIColor.init(hex: 0x8993A2)))
        let bb: ASAttributedString = .init("学士学位证明文件", .font(UIFont.PFSC_R(ofSize: 13)), .foreground(UIColor.brandMainColor))
        let cc: ASAttributedString = .init("，请优先在列表上传。", .font(UIFont.PFSC_R(ofSize: 13)), .foreground(UIColor.init(hex: 0x8993A2)))
        label.attributed.text = aa + bb + cc
        return label
    }()
    
    lazy var uploadContentView: UIView = {
        let view = UIView()
        return view
    }()
    
    lazy var uploadTitleLabel: UILabel = {
        let label = UILabel()
        let aa: ASAttributedString = .init("上传学历证件", .font(UIFont.PFSC_M(ofSize: 14)), .foreground(UIColor.mainTextColor))
        label.attributed.text = aa
        return label
    }()
    
    lazy var uploadLabel: UILabel = {
        let label = UILabel()
        label.textAlignment = .right
        let aa: ASAttributedString = .init("去上传", .font(UIFont.PFSC_M(ofSize: 14)), .foreground(UIColor.brandMainColor))
        label.attributed.text = aa
        return label
    }()
    
    lazy var arrowImgV: UIImageView = {
        let imgV = UIImageView(image: UIImage(named: "blue_right_arrow"))
        return imgV
    }()
    
    required init?(coder: NSCoder) {
        super.init(coder: coder)
    }
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        setupUI()
    }
    
    func setupUI() {
        
        self.selectionStyle = .none
        contentView.backgroundColor = .white
        contentView.addSubview(titleLabel)
        contentView.addSubview(topLine)
        contentView.addSubview(tipsLabel)
        contentView.addSubview(uploadContentView)
        uploadContentView.addSubview(uploadTitleLabel)
        uploadContentView.addSubview(uploadLabel)
        uploadContentView.addSubview(arrowImgV)
        
        titleLabel.snp.makeConstraints { make in
            make.left.equalTo(18)
            make.top.equalTo(23)
            make.height.equalTo(24)
        }
        
        topLine.snp.makeConstraints { make in
            make.top.equalTo(titleLabel.snp.bottom).offset(16)
            make.left.right.equalToSuperview()
            make.height.equalTo(0.5)
        }
        
        tipsLabel.snp.makeConstraints { make in
            make.left.equalTo(18)
            make.right.equalTo(-18)
            make.top.equalTo(topLine.snp.bottom).offset(16)
        }
        
        uploadContentView.snp.makeConstraints { make in
            make.left.equalTo(18)
            make.right.equalTo(-18)
            make.top.equalTo(tipsLabel.snp.bottom).offset(12)
            make.height.equalTo(52)
            make.bottom.equalTo(-4)
        }
        
        uploadTitleLabel.snp.makeConstraints { make in
            make.centerY.equalToSuperview()
            make.left.equalToSuperview()
            make.height.equalTo(20)
        }
        
        arrowImgV.snp.makeConstraints { make in
            make.width.height.equalTo(20)
            make.centerY.equalToSuperview()
            make.right.equalTo(-20)
        }
        
        uploadLabel.snp.makeConstraints { make in
            make.centerY.equalToSuperview()
            make.right.equalTo(arrowImgV.snp.left)
            make.height.equalTo(20)
        }
    }
}
