//
//  YHHomeLifeCategoryDetailModel.swift
//  galaxy
//
//  Created by edy on 2024/7/23.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import SmartCodable

class YHHomeLifeCategoryDetailModel: SmartCodable {
    var products: [YHProductModel] = []
    var imageURLDefault: String = ""
    var imageURLDefaultDownload: String = ""

    enum CodingKeys: String, CodingKey {
        case products
        case imageURLDefault = "imageUrlDefault"
        case imageURLDefaultDownload = "imageUrlDefaultDownload"
    }

    required init() {
        
    }
}

// MARK: - Product
class YHProductModel: SmartCodable {
    var id: String = ""
    var name: String = ""
    var description: String = ""
    var image: String = ""
    var banner: [String] = []
    var details: [YHDetailModel] = []

    required init() {
        
    }
}

// MARK: - Detail
class YHDetailModel: SmartCodable {
    var name: String = ""
    var image: String = ""
   
    required init() {
        
    }
}
