//
//  YHAdopterExampleTableViewCell.swift
//  galaxy
//
//  Created by EDY on 2024/8/20.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHAdopterExampleTableViewCell: UITableViewCell {
    typealias ExampleBlock = () -> Void
    var exampleBlock: ExampleBlock?
    var titleLabel: UILabel!
    var templateView: YHCertificateSampleTemplateView!

    required init?(coder: NSCoder) {
        super.init(coder: coder)
    }
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        selectionStyle = .none
        setupUI()
    }
    
    func setupUI() {
        contentView.backgroundColor = .clear
        backgroundColor = .clear
        
        titleLabel = {
            let label = UILabel()
            label.font = UIFont.PFSC_M(ofSize: 17)
            label.textColor = UIColor.mainTextColor
            label.text = "中国身份证示例模板"
            return label
        }()
        contentView.addSubview(titleLabel)
        titleLabel.snp.makeConstraints { make in
            make.left.equalTo(20)
            make.right.equalTo(-20)
            make.top.equalTo(16)
            make.height.equalTo(24)
        }
        
        templateView = {
            let view = YHCertificateSampleTemplateView()
            return view
        }()
        contentView.addSubview(templateView)
        templateView.snp.makeConstraints { make in
            make.left.equalTo(20)
            make.right.equalTo(-20)
            make.top.equalTo(56)
            make.height.equalTo(62)
        }
        
        let tapGesture = UITapGestureRecognizer(target: self, action: #selector(tapAction))
                // 给视图添加手势识别器
        templateView.addGestureRecognizer(tapGesture)
    }
    
    @objc func tapAction(gesture: UITapGestureRecognizer) {
        if let block = exampleBlock {
            block()
        }
    }
}
