//
//  YHPreviewInfoWorkExpView.swift
//  galaxy
//
//  Created by davidhuangA on 2024/3/5.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHPreviewInfoWorkExpView: UIView {
    var dataModel: YHPreviewInfoSessionModel? {
        didSet {
            updateUI()
        }
    }
}

private extension  YHPreviewInfoWorkExpView {
    func updateUI() {
        guard let model = dataModel, let mmodel = model.cellData4, !mmodel.isEmpty else { return }
        if model.cellType == .workExp {
            removeSubviews()
            
            // 1.title
            let sessionView = YHPreviewInfoSingleLineTitleView()
            sessionView.updateTitle(title: model.cellTitle)
            addSubview(sessionView)
            sessionView.snp.makeConstraints { make in
                make.top.equalToSuperview()
                make.right.equalToSuperview().offset(-0)
                make.left.equalToSuperview().offset(0)
                make.height.equalTo(YHPreviewInfoSingleLineTitleView.viewH)
            }
            
            var lastTagView: UIView = sessionView
            for(_, item) in mmodel.enumerated() {
                if !item.title.isEmpty, !item.title.contains("简历/工作总结") {
                    let label = UILabel()
                    label.text = item.title
                    label.textColor = UIColor.mainTextColor
                    label.font = UIFont.PFSC_M(ofSize: 14)
                    
                    addSubview(label)
                    label.snp.makeConstraints { make in
                        make.top.equalTo(lastTagView.snp.bottom)
                        make.height.equalTo(20)
                        make.right.equalToSuperview().offset(-18)
                        make.left.equalToSuperview().offset(18)
                    }
                    lastTagView = label
                }
                
                if !item.data.isEmpty {
                    if item.uiType == 1 {
                        let item: YHPreviewInfoSessionModel = YHPreviewInfoSessionModel(cellType: .countryInfoType, cellTitle: "", cellData0: item.data as? [YHPreviewQuestionAndAnswerModel])
                        let view = YHPreviewInfoNameAndSubNameItemsView(frame: .zero)
                        view.dataModel = item
                        addSubview(view)
                        view.snp.makeConstraints { make in
                            make.top.equalTo(lastTagView.snp.bottom)
                            make.left.right.equalToSuperview()
                        }
                        lastTagView = view
                    } else if item.uiType == 2 {
                        let item: YHPreviewInfoSessionModel = YHPreviewInfoSessionModel(cellType: .countryInfoType, cellTitle: "", cellData0: item.data as? [YHPreviewQuestionAndAnswerModel])
                        let view = YHPreviewInfoQuestionAndAnswerItemsView(frame: .zero)
                        view.dataModel = item
                        addSubview(view)
                        view.snp.makeConstraints { make in
                            make.top.equalTo(lastTagView.snp.bottom)
                            make.left.right.equalToSuperview()
                        }
                        lastTagView = view
                    } else if item.uiType == 4 {
                        
                        let item: YHPreviewInfoSessionModel = YHPreviewInfoSessionModel(cellType: .countryInfoType, cellTitle: "", cellData0: item.data as? [YHPreviewQuestionAndAnswerModel])
                        let view = YHPreviewInfoQuestionAndAnswerItemsView2(frame: .zero)
                        view.dataModel = item
                        addSubview(view)
                        view.snp.makeConstraints { make in
                            make.top.equalTo(lastTagView.snp.bottom)
                            make.left.right.equalToSuperview()
                        }
                        lastTagView = view
                        
                    } else if item.uiType == 3 {
                        // 简历/工作总结
                        if !item.data.isEmpty {
                            let tagView: UIView = UIView()
                            tagView.backgroundColor = UIColor.separatorColor
                            addSubview(tagView)
                            tagView.snp.makeConstraints { make in
                                make.top.equalTo(lastTagView.snp.bottom)
                                make.left.equalToSuperview().offset(kMargin)
                                make.right.equalToSuperview().offset(-kMargin)
                                make.height.equalTo(1)
                            }
                            
                            lastTagView = tagView
                            let view: YHPreviewInfoWorkSummaryView = YHPreviewInfoWorkSummaryView(frame: .zero)
                            view.dataModel = item
                            addSubview(view)
                            view.snp.makeConstraints { make in
                                make.top.equalTo(lastTagView.snp.bottom).offset(kMargin)
                                make.left.equalToSuperview()
                                make.right.equalToSuperview()
                            }
                            lastTagView = view
                        }
                    } else {
                        printLog("error:  暂时没有处理的  UI 类型")
                    }
                }
            }
            
            let tagView: UIView = UIView()
            tagView.backgroundColor = .clear
            addSubview(tagView)
            tagView.snp.makeConstraints { make in
                make.top.equalTo(lastTagView.snp.bottom)
                make.left.right.equalToSuperview()
                make.height.equalTo(0.5)
                make.bottom.equalToSuperview()
            }
        } else {
            printLog("当前 view 不支持 .workExp的类型")
        }
    }
}
