//
//  YHInformationPerfectListVC.swift
//  galaxy
//
//  Created by davidhuangA on 2024/1/25.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

/*
 *信息完善列表
 */
class YHInformationPerfectListVC: YHBaseViewController {
    var orderId: Int?
    private var firstCheckFlag: Bool = false
    
    private lazy var serviceCenterMainReqVM: YHServiceCenterMainViewModel = {
        let tmp = YHServiceCenterMainViewModel()
        return tmp
        
    }()
    
    private var hasSubmitFlag: Bool = false {
        didSet {
            submitBtn.isHidden = hasSubmitFlag
            submitHoldView.isHidden = !hasSubmitFlag
            
            if hasSubmitFlag {
                headerTitleDesLable.text = "您已提交信息表"
                myDeslable.text = "您已提交个人信息表，我的方案详情和个人信息表可点击底部按钮进行查看"
            } else {
                var name = ""
                if let applicant = serviceCenterMainReqVM.informationFillStepModel {
                    if applicant.applicantName.isEmpty {
                        name = "尊敬的客户"
                    } else {
                        name = applicant.applicantName
                        if applicant.sex == 1 {
                            name += "先生"
                        } else if applicant.sex == 2 {
                            name += "女士"
                        } else {
                            
                        }
                    }
                }
                headerTitleDesLable.text = "您好," + name
                myDeslable.text = "此表由主申请人填写，我们将会根据您的个人信息制作资料清单，请按顺序填写，提交后1-2个工作日内联系您哦~"
            }
        }
    }
    
    private lazy var headerTitleDesLable: UILabel = {
        let titleLable = UILabel(text: "您好,-")
        titleLable.font = UIFont.PFSC_B(ofSize: 21)
        titleLable.textColor = UIColor.mainTextColor
        titleLable.lineBreakMode = .byTruncatingMiddle
        return titleLable
    }()
    
    private lazy var topBkg: UIView = {
        let imagV = UIImageView()
        imagV.image = UIImage(named: "service_center_head_bkg2")
        imagV.contentMode = .scaleAspectFill
        return imagV
        
    }()
    
    var homeTableView: UITableView = {
        let tableView = UITableView(frame: .zero, style: .plain)
        tableView.backgroundColor = .clear
        tableView.separatorStyle = .none
        tableView.showsHorizontalScrollIndicator = false
        tableView.showsVerticalScrollIndicator = false
        tableView.register(YHInformationPerfectCell.self, forCellReuseIdentifier: YHInformationPerfectCell.cellReuseIdentifier)
        return tableView
    }()
    
    var myHeadView: UIView = {
        let view = UIView()
        return view
    }()
    
    var myBottomView: UIView = {
        let view = UIView()
        view.backgroundColor = .white
        return view
    }()
    
    var submitHoldView: UIView = {
        let view = UIView()
        view.backgroundColor = .clear
        return view
    }()
    
    var myDeslable: UILabel!
    // 提交按钮
    var submitBtn: UIButton!
    // 提交按钮2
    var submitBtn2: UIButton!
    // 我的方案
    var mySchemeBtn: UIButton!
    // 信息预览
    var preInforBtn: UIButton!
    
    override func viewDidLoad() {
        super.viewDidLoad()
        setupUI()
    }
    
    override func viewWillAppear(_ animated: Bool) {
        super.viewWillAppear(animated)
        loadData()
    }
    
    override func backItemClick(_ sender: Any) {
        if self.serviceCenterMainReqVM.informationFillStepModel?.step == 6, !(self.serviceCenterMainReqVM.informationFillStepModel?.policy_switch ?? false) {
            YHSubmitAllInfoCheckView.showCheckView(tipMsg: "你已填完所有信息，是否马上提交?") { agree in
                if agree == true {
                    printLog("点击了 确认 按钮")
                    self.submitAllInfo()
                } else {
                    printLog("点击了 取消 按钮")
                    self.navigationController?.popViewController()
                }
            }
        } else {
            self.navigationController?.popViewController()
        }
    }
    
    /// 是否可以返回，包括点击返回和手势返回，默认YES
//    @objc func navigationShouldPop() -> Bool
    override func navigationShouldPop() -> Bool {
        
        // 6-全部填完， 7-已提交
        if self.serviceCenterMainReqVM.informationFillStepModel?.step == 6, !(self.serviceCenterMainReqVM.informationFillStepModel?.policy_switch ?? false) {
            YHSubmitAllInfoCheckView.showCheckView(tipMsg: "你已填完所有信息，是否马上提交?") { agree in
                if agree == true {
                    printLog("点击了 确认 按钮")
                    self.submitAllInfo()
                    
                } else {
                    printLog("点击了 取消 按钮")
                    self.navigationController?.popViewController()
                }
            }
            return false
            
        }
        
        return true
    }
    
}

extension YHInformationPerfectListVC {
    func checkSubmitTips() {
        
        if firstCheckFlag {
            return
        }
        
        firstCheckFlag = true
        
        if self.serviceCenterMainReqVM.informationFillStepModel?.step == 6 {
            YHSubmitAllInfoCheckView.showCheckView(tipMsg: "你已填完所有信息，是否马上提交?") { agree in
                if agree == true {
                    printLog("点击了 确认 按钮")
                    self.submitAllInfo()
                    
                } else {
                    printLog("点击了 取消 按钮")                }
            }
        }
    }
    
    func submitSweetNotify() {
        let params = ["option": 1, "order_id": orderId]
        serviceCenterMainReqVM.submitSweetNotifyOp(params: params as [String: Any]) { success, error in
            if success == true {
                YHInformationFillTipsAlertView.hideCheckView()
            } else {
                YHHUD.flash(message: error?.errorMsg ?? "发生错误,请重试")
            }
            self.loadData()
        }
    }
    
    func submitGCSweetNotify() {
        let params = ["option": 1, "order_id": orderId]
        serviceCenterMainReqVM.submitSweetNotifyOp(params: params as [String: Any]) { success, error in
            if success == true {
                YHGCInformationFillTipsAlertView.hideCheckView()
            } else {
                YHHUD.flash(message: error?.errorMsg ?? "发生错误,请重试")
            }
            self.loadData()
        }
    }
    
    func showTipsAlert() {
        YHInformationFillTipsAlertView.showCheckView { agree in
            if agree == true {
                printLog("点击了 确认 按钮")
                self.submitSweetNotify()
            } else {
                printLog("点击了 取消 按钮")
            }
        }
    }
    
    func showGCTipsAlert() {
        YHGCInformationFillTipsAlertView.showCheckView { agree in
            if agree == true {
                printLog("点击了 确认 按钮")
                self.submitGCSweetNotify()
            } else {
                printLog("点击了 取消 按钮")
            }
        }
    }
    
    func loadData() {
        guard let orderId = orderId else { return}
        self.serviceCenterMainReqVM.getPersonInfoFillStep(params: ["orderId": orderId]) { success, _ in
            if success {
                if self.serviceCenterMainReqVM.myInfoFillStep == 7 {
                    self.hasSubmitFlag = true
                    
                    self.submitBtn.isHidden = true
                    self.submitHoldView.isHidden = false
                    
                    self.submitBtn2.isHidden = true
                    self.preInforBtn.isHidden = false
                } else {
                    
                    let retValue = self.serviceCenterMainReqVM.informationFillStepModel?.policy_switch ?? false
                    
                    if retValue {
                        self.hasSubmitFlag = true
                        
                        self.submitBtn.isHidden = true
                        self.submitHoldView.isHidden = false
                        
                        self.submitBtn2.isHidden = false
                        self.preInforBtn.isHidden = true
                        
                        if self.serviceCenterMainReqVM.informationFillStepModel?.step == 6 {
                            // 提交按钮可点击
                            self.submitBtn2.layer.opacity = 1
                            self.submitBtn2.isEnabled = true
                            
                        } else {
                            // 提交按钮不点击
                            self.submitBtn2.layer.opacity = 0.4
                            self.submitBtn2.isEnabled = false
                        }
                    } else {
                        self.hasSubmitFlag = false
                        
                        self.submitBtn.isHidden = false
                        self.submitHoldView.isHidden = true
                        
                        if self.serviceCenterMainReqVM.informationFillStepModel?.step == 6 {
                            self.submitBtn.layer.opacity = 1
                            self.submitBtn.isEnabled = true
                        } else {
                            self.submitBtn.layer.opacity = 0.4
                            self.submitBtn.isEnabled = false
                        }
                    }
                    
                }
            }
            self.homeTableView.reloadData()
        }
    }
    
    // 我的方案
    @objc func goMySchemeVC() {
        if serviceCenterMainReqVM.application_type == 0 { // 优才
            YHMyNewSchemeViewController.shared.goToSchemePage()

        } else if serviceCenterMainReqVM.application_type == 1 || serviceCenterMainReqVM.application_type == 2 || serviceCenterMainReqVM.application_type == 3 { // 高才ABC
            let vc = YHGCMineSchemeViewController(orderId: orderId ?? 0)
            navigationController?.pushViewController(vc)
        }
    }
    
    @objc func goInfoListVC( ) {
        // 个人信息表预览
        goInfoListVCOp()
    }
    
    private func goInfoListVCOp(index: Int = 0) {
        
        if serviceCenterMainReqVM.application_type == 0 { // 优才
            let vc = YHPreviewMainViewController()
            vc.orderId = orderId
            vc.myDefaultIndex = index
            navigationController?.pushViewController(vc)
            
        } else if serviceCenterMainReqVM.application_type == 1 || serviceCenterMainReqVM.application_type == 2 || serviceCenterMainReqVM.application_type == 3 { // 高才ABC
            
            var selectIndex = 0
            if index == 0 || index == 1 {
                selectIndex = 0
            } else {
                selectIndex = index-1
            }
        
            let vc = YHGCPreviewMainViewController()
            vc.productType = serviceCenterMainReqVM.application_type
            vc.orderId = orderId
            vc.myDefaultIndex = selectIndex
            navigationController?.pushViewController(vc)
        }
        
    }
    
    @objc func clickSubmitBtn() {
        YHSubmitAllInfoCheckView.showCheckView(tipMsg: "您即将提交客户信息，为保障流程顺畅与服务质量，请确认信息无误后提交。") { agree in
            if agree == true {
                printLog("点击了 确认 按钮")
                
                self.submitAllInfo()
                
            } else {
                printLog("点击了 取消 按钮")
            }
        }
    }
    
    @objc func submitAllInfo() {
        guard let orderId = orderId else {
            printLog("error: orderId 为空")
            return
        }
        
        YHHUD.show(.progress(message: "数据提交中...."))
        serviceCenterMainReqVM.submitAllInfoOp(params: ["orderId": orderId]) { [weak self] success, error in
            YHHUD.hide()
            if success == true {
                let model =  self?.serviceCenterMainReqVM.allInfoScoreModel
                YHSubmitAllInfoSuccessAlertView.showCheckView(model: model) { agree in
                    
                    // 1、刷新当前界面
                    self?.loadData()
                    
                    // 2、跳转其他界面
                    if agree == true {
                        self?.goMySchemeVC()
                    }
                }
                // 1、刷新当前界面
                self?.loadData()
            } else {
                let msg = error?.errorMsg ?? "操作失败"
                YHHUD.flash(message: msg)
            }
        }
    }
    
    func setupUI() {
        gk_navTitle = "信息完善"
        gk_navBarAlpha = 1.0
        gk_navLineHidden = true
        
        view.addSubview(topBkg)
        topBkg.snp.makeConstraints { make in
            make.top.left.right.equalToSuperview()
            make.height.equalTo(259)
        }
        
        view.addSubview(myBottomView)
        myBottomView.snp.makeConstraints { make in
            make.bottom.equalToSuperview()
            make.left.right.equalToSuperview()
            make.height.equalTo(98)
        }
        
        submitBtn = UIButton(type: .custom)
        submitBtn.layer.opacity = 0.4
        submitBtn.setTitle("提交信息", for: .normal)
        submitBtn.setTitleColor(UIColor.white, for: .normal)
        submitBtn.isEnabled = false
        
        submitBtn.layer.cornerRadius = kCornerRadius3
        submitBtn.clipsToBounds = true
        myBottomView.addSubview(submitBtn)
        
        submitBtn.addTarget(self, action: #selector(clickSubmitBtn), for: .touchUpInside)
        submitBtn.snp.makeConstraints { make in
            make.top.equalTo(8)
            make.left.equalTo(kMargin)
            make.right.equalTo(-kMargin)
            make.height.equalTo(48)
        }
        submitBtn.layoutIfNeeded()
        submitBtn.addYinHeGradualLayer()
        
        submitBtn.isHidden = hasSubmitFlag
        submitHoldView.isHidden = !hasSubmitFlag
        
        myBottomView.addSubview(submitHoldView)
        submitHoldView.snp.makeConstraints { make in
            make.top.equalTo(8)
            make.left.equalTo(kMargin)
            make.right.equalTo(-kMargin)
            make.height.equalTo(48)
        }
        
        // 我的方案
        let mySchemeBtn = {
            let button = UIButton(type: .custom)
            button.backgroundColor =  UIColor(hex: 0xffffff)
            button.titleLabel?.font = UIFont.PFSC_M(ofSize: 16)
            button.contentHorizontalAlignment = .center
            button.setTitle("我的方案", for: .normal)
            button.setTitleColor(UIColor.brandMainColor, for: .normal)
            button.layer.cornerRadius = kCornerRadius3
            button.layer.borderWidth = 1
            button.layer.borderColor = UIColor.brandMainColor.cgColor
            button.addTarget(self, action: #selector(goMySchemeVC), for: .touchUpInside)
            return button
        }()
        submitHoldView.addSubview(mySchemeBtn)
        mySchemeBtn.snp.makeConstraints { make in
            make.left.top.bottom.equalToSuperview()
            make.right.equalTo(submitHoldView.snp.centerX).offset(-6)
        }
        self.mySchemeBtn = mySchemeBtn
        
        let preInforBtn = {
            let button = UIButton(type: .custom)
            button.backgroundColor =  UIColor.brandMainColor
            button.titleLabel?.font = UIFont.PFSC_M(ofSize: 16)
            button.contentHorizontalAlignment = .center
            button.setTitle("个人信息表", for: .normal)
            button.setTitleColor(.white, for: .normal)
            button.layer.cornerRadius = kCornerRadius3
            button.clipsToBounds = true
            button.addTarget(self, action: #selector(goInfoListVC), for: .touchUpInside)
            return button
        }()
        
        self.preInforBtn = preInforBtn
        submitHoldView.addSubview(preInforBtn)
        preInforBtn.snp.makeConstraints { make in
            make.right.top.bottom.equalToSuperview()
            make.left.equalTo(submitHoldView.snp.centerX).offset(6)
        }
        preInforBtn.layoutIfNeeded()
        preInforBtn.addYinHeGradualLayer()
        
        let submitBtn2 = {
            let button = UIButton(type: .custom)
            button.backgroundColor =  UIColor.brandMainColor
            button.titleLabel?.font = UIFont.PFSC_M(ofSize: 16)
            button.contentHorizontalAlignment = .center
            button.setTitle("提交信息", for: .normal)
            button.setTitleColor(.white, for: .normal)
            button.layer.cornerRadius = kCornerRadius3
            button.clipsToBounds = true
            button.addTarget(self, action: #selector(submitAllInfo), for: .touchUpInside)
            button.isHidden = true
            return button
        }()
        
        self.submitBtn2 = submitBtn2
        submitHoldView.addSubview(submitBtn2)
        submitBtn2.snp.makeConstraints { make in
            make.right.top.bottom.equalToSuperview()
            make.left.equalTo(submitHoldView.snp.centerX).offset(6)
        }
        submitBtn2.layoutIfNeeded()
        submitBtn2.addYinHeGradualLayer()
        
        homeTableView.delegate = self
        homeTableView.dataSource = self
        view.addSubview(homeTableView)
        homeTableView.snp.makeConstraints { make in
            make.left.right.equalToSuperview()
            make.top.equalTo(k_Height_NavigationtBarAndStatuBar)
            make.bottom.equalTo(myBottomView.snp.top)
        }
        
        myHeadView.addSubview(headerTitleDesLable)
        headerTitleDesLable.snp.makeConstraints { make in
            make.top.equalTo(16)
            make.left.equalTo(24)
            make.right.equalTo(-24)
            make.height.equalTo(29)
        }
        
        let desLable = UILabel(text: "此表由主申请人填写，我们将会根据您的个人信息制作资料清单，请按顺序填写，提交后1-2个工作日内联系您哦~")
        desLable.font = UIFont.PFSC_R(ofSize: 12)
        desLable.numberOfLines = 0
        desLable.textColor = UIColor.mainTextColor
        desLable.lineBreakMode = .byWordWrapping
        self.myDeslable = desLable
        
        myHeadView.addSubview(desLable)
        desLable.snp.makeConstraints { make in
            make.top.equalTo(headerTitleDesLable.snp.bottom).offset(6)
            make.left.equalTo(24)
            make.right.equalTo(-24)
        }
        
        myHeadView.frame = CGRect(x: 0, y: 0, width: KScreenWidth, height: 100)
        homeTableView.tableHeaderView = myHeadView
        homeTableView.reloadData()
    }
}

// MARK: - UITableViewDelegate 和 UITableViewDataSource
extension YHInformationPerfectListVC: UITableViewDelegate, UITableViewDataSource {
    func numberOfSections(in tableView: UITableView) -> Int {
        return 1
    }
    
    func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        return serviceCenterMainReqVM.arrInfoFillStep.count
    }
    
    func tableView(_ tableView: UITableView, heightForRowAt indexPath: IndexPath) -> CGFloat {
        return YHInformationPerfectCell.cellHeight
    }
    
    func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        let newCell = tableView.dequeueReusableCell(withClass: YHInformationPerfectCell.self)
        newCell.selectionStyle = .none
        newCell.dataModel = serviceCenterMainReqVM.arrInfoFillStep[indexPath.row]
        return newCell
    }
    
    func tableView(_ tableView: UITableView, didSelectRowAt indexPath: IndexPath) {
        tableView.deselectRow(at: indexPath, animated: true)
        printLog("点击了 \(indexPath.section)section  --- \(indexPath.row)row")
        
        // 处理跳转逻辑
        handleJumpLogic( tapIndex: indexPath.row)
    }
    
    private func  handleJumpLogic(tapIndex: Int) {
// #if DEBUG
//        // 开发模式下 任意跳转
//        handleJumpLogicDebug(tapIndex: tapIndex)
//        return
// #endif
        // 正式环境
        handleJumpLogicRelease(tapIndex: tapIndex)
    }
    
    private func  handleJumpLogicRelease(tapIndex: Int) {
        if self.serviceCenterMainReqVM.myInfoFillStep == 7 {
            goInfoListVCOp(index: tapIndex)
            return
        }
        
        if self.serviceCenterMainReqVM.myInfoFillStep == 6 {
            handleJumpLogicDebug(tapIndex: tapIndex)
        } else {
            // 请先完成 xxx 的填写
            if serviceCenterMainReqVM.myTargetIndex > -1, serviceCenterMainReqVM.myTargetIndex < serviceCenterMainReqVM.arrInfoFillStep.count {
                
                if tapIndex <= serviceCenterMainReqVM.myTargetIndex {
                    handleJumpLogicDebug(tapIndex: tapIndex)
                } else {
                    let model =  serviceCenterMainReqVM.arrInfoFillStep[serviceCenterMainReqVM.myTargetIndex]
                    let msg = "请先完成" + model.name + "填写"
                    YHHUD.flash(message: msg)
                }
                
            }
            
        }
    }
    
    private func  handleJumpLogicDebug(tapIndex: Int) {
        
        if serviceCenterMainReqVM.application_type == 0 {
            // 优才
            if tapIndex == 0 {
                if self.serviceCenterMainReqVM.informationFillStepModel?.sweet_notify_status == 0 {
                    self.showTipsAlert()
                    return
                }
                // 主申请人信息
                let vc = YHMainApplicantInformationViewController()
                vc.orderId = orderId ?? 0
                navigationController?.pushViewController(vc)
                
            } else if tapIndex == 1 {
                // 家庭程序信息
                
                let vc = YHFamilyMemberInfoListVC(orderId: orderId ?? 0)
                vc.orderId = orderId ?? 0
                navigationController?.pushViewController(vc)
                
            } else if tapIndex == 2 {
                // 基本信息
                let vc = YHBasicInfoFillViewController()
                vc.orderId = orderId
                navigationController?.pushViewController(vc)
                
            } else if tapIndex == 3 {
                // 学历/专业资格
                let vc = YHEducationInfoListVC()
                vc.orderId = orderId ?? 0
                navigationController?.pushViewController(vc)
                
            } else if tapIndex == 4 {
                // 工作经历
                let vc = YHWorkExperienceListViewController()
                vc.orderId = orderId ?? 0
                navigationController?.pushViewController(vc)
                
            } else if tapIndex == 5 {
                // 收入记录
                if let orderId = orderId {
                    let ctl = YHIncomeRecordViewController(orderId: orderId)
                    navigationController?.pushViewController(ctl)
                }
            } else if tapIndex == 6 {
                // 其他信息
                let vc = YHOtherInfoFillViewController()
                vc.orderId = orderId
                navigationController?.pushViewController(vc)
            } else {
                YHHUD.flash(message: "优才- 未知")
            }
            
        } else if serviceCenterMainReqVM.application_type == 1 {
            // 高才A
            if tapIndex == 0 {
                if self.serviceCenterMainReqVM.informationFillStepModel?.sweet_notify_status == 0 {
                    self.showGCTipsAlert()
                    return
                }
                gotoApplyTypeVC()
                // 高A- 申请类别
            } else if tapIndex == 1 {
                // 高A- 主申请人信息
//                YHHUD.flash(message: "高A- 主申请人信息")
                let vc = YHGCMainApplicantInformationViewController()
                vc.orderId = orderId ?? 0
                navigationController?.pushViewController(vc)
            } else if tapIndex == 2 {
                // 高A- 家庭成员信息
                let vc = YHGCFamilyMemberInfoListVC(orderId: orderId ?? 0)
                vc.orderId = orderId ?? 0
                navigationController?.pushViewController(vc)
                
            } else if tapIndex == 3 {
                // 高A- 收入记录/工作经验
                let ctl = YHGCIncomeRecordViewController(orderId: orderId ?? 0)
                navigationController?.pushViewController(ctl)
            } else if tapIndex == 4 {
                // 高A- 基本资料
                let ctl = YHGCBasicInfoFillViewController()
                ctl.orderId = orderId ?? 0
                navigationController?.pushViewController(ctl)
            } else {
                YHHUD.flash(message: "高A- 未知")
                
            }
            
        } else if serviceCenterMainReqVM.application_type == 2 || serviceCenterMainReqVM.application_type == 3 {
            // 高才BC
            if tapIndex == 0 {
                if self.serviceCenterMainReqVM.informationFillStepModel?.sweet_notify_status == 0 {
                    self.showGCTipsAlert()
                    return
                }
                gotoApplyTypeVC()
                // 高才BC- 申请类别
            } else if tapIndex == 1 {
                // 高才BC- 主申请人信息
//                YHHUD.flash(message: "高才BC- 主申请人信息")
                let vc = YHGCMainApplicantInformationViewController()
                vc.orderId = orderId ?? 0
                navigationController?.pushViewController(vc)
            } else if tapIndex == 2 {
                // 高才BC- 家庭成员信息
//                YHHUD.flash(message: "高才BC- 家庭成员信息")
                let vc = YHGCFamilyMemberInfoListVC(orderId: orderId ?? 0)
                vc.orderId = orderId ?? 0
                navigationController?.pushViewController(vc)
                
            } else if tapIndex == 3 {
                // 高才BC- 学历资格
//                YHHUD.flash(message: "高才BC- 学历资格")
                let vc = YHGCEducationInfoListVC()
                vc.orderId = orderId ?? 0
                navigationController?.pushViewController(vc)
                
            } else if tapIndex == 4 {
                // 高才BC- 工作经验
//                YHHUD.flash(message: "高才BC- 工作经验")
                let vc = YHGCWorkExperienceListViewController()
                vc.orderId = orderId ?? 0
                navigationController?.pushViewController(vc)
            } else if tapIndex == 5 {
                // 高才BC- 基本资料
                let ctl = YHGCBasicInfoFillViewController()
                ctl.orderId = orderId ?? 0
                navigationController?.pushViewController(ctl)
            } else {
//                YHHUD.flash(message: "高才BC- 未知")
                
            }
        }
    }
    
    private func gotoApplyTypeVC() {
        let orderId = orderId ?? 0
        YHHUD.show(.progress(message: "加载中..."))
        YHGCApplicationTypeViewModel().getApplyType(orderId: orderId) { [weak self] model, error in
            YHHUD.hide()
            guard let self = self else {
                return
            }
            guard let model = model else {
                if let errorMsg = error?.errorMsg, errorMsg.count > 0 {
                    YHHUD.flash(message: errorMsg)
                }
                return
            }
            let type = YHGCApplicationType(rawValue: model.apply_type)
            if let type = type {
                let ctl = YHGCApplicationTypeResultController(type: type)
                self.navigationController?.pushViewController(ctl)
            } else {
                let ctl = YHGCApplicationTypeController(orderId: orderId)
                self.navigationController?.pushViewController(ctl)
            }
        }
        
    }
}
