//
//  YHHomeSearchView.swift
//  galaxy
//
//  Created by davidhuangA on 2024/4/7.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
class YHHomeSearchView: UIView {
    static let viewH: CGFloat = 36.0
    lazy var placeHolderLabel: UILabel = {
        let lable = UILabel()
        lable.text = "香港身份"
        lable.font = UIFont.PFSC_R(ofSize: 13)
        lable.textColor = UIColor.yhGreyColor
        return lable
    }()
    
    private lazy var scanBtn: UIButton = {
        let btn = UIButton()
        btn.setImage(UIImage(named: "qr_scan_icon"), for: .normal)
        btn.YH_clickEdgeInsets = UIEdgeInsets(top: 20, left: 20, bottom: 20, right: 20)
        btn.addTarget(self, action: #selector(didClickScanBtn(btn:)), for: .touchUpInside)
        return btn
    }()
    
    var placeHolder: String = "" {
        didSet {
            self.placeHolderLabel.text = placeHolder
        }
    }
    
    var didClickScanBtnEvent: (() -> Void)?
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        initView()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
}

private extension YHHomeSearchView {
    func initView() {
        backgroundColor = UIColor(hex: 0xF4F6FA, alpha: 1.0)
        
        let imageV: UIImageView = UIImageView()
        imageV.contentMode = .scaleAspectFill
        imageV.image = UIImage(named: "home_search_icon")
        addSubview(imageV)
        imageV.snp.makeConstraints { make in
            make.centerY.equalToSuperview()
            make.left.equalTo(12)
            make.width.height.equalTo(16)
        }
        
        addSubview(scanBtn)
        scanBtn.snp.makeConstraints { make in
            make.width.height.equalTo(24.0)
            make.right.equalToSuperview().offset(-12)
            make.centerY.equalToSuperview()
        }
        
        addSubview(placeHolderLabel)
        placeHolderLabel.snp.makeConstraints { make in
            make.centerY.equalToSuperview()
            make.left.equalTo(imageV.snp.right).offset(8)
            make.height.equalTo(18)
            make.right.equalTo(scanBtn.snp.left).offset(-12)
        }
    }
    
    @objc func didClickScanBtn(btn: UIButton) {
        didClickScanBtnEvent?()
    }
}
